/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JmsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":destinationType:destinationName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jms".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "destinationType", "queue", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "destinationName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(103);
        props.add("acceptMessagesWhileStopping");
        props.add("acknowledgementModeName");
        props.add("allowAdditionalHeaders");
        props.add("allowNullBody");
        props.add("allowReplyManagerQuickStop");
        props.add("allowSerializedHeaders");
        props.add("alwaysCopyMessage");
        props.add("artemisConsumerPriority");
        props.add("artemisStreamingEnabled");
        props.add("asyncConsumer");
        props.add("asyncStartListener");
        props.add("asyncStopListener");
        props.add("autoStartup");
        props.add("browseLimit");
        props.add("cacheLevel");
        props.add("cacheLevelName");
        props.add("clientId");
        props.add("concurrentConsumers");
        props.add("connectionFactory");
        props.add("consumerType");
        props.add("correlationProperty");
        props.add("defaultTaskExecutorType");
        props.add("deliveryDelay");
        props.add("deliveryMode");
        props.add("deliveryPersistent");
        props.add("destinationName");
        props.add("destinationResolver");
        props.add("destinationType");
        props.add("disableReplyTo");
        props.add("disableTimeToLive");
        props.add("durableSubscriptionName");
        props.add("eagerLoadingOfProperties");
        props.add("eagerPoisonBody");
        props.add("errorHandler");
        props.add("errorHandlerLogStackTrace");
        props.add("errorHandlerLoggingLevel");
        props.add("exceptionHandler");
        props.add("exceptionListener");
        props.add("exchangePattern");
        props.add("explicitQosEnabled");
        props.add("exposeListenerSession");
        props.add("forceSendOriginalMessage");
        props.add("formatDateHeadersToIso8601");
        props.add("headerFilterStrategy");
        props.add("idleConsumerLimit");
        props.add("idleReceivesPerTaskLimit");
        props.add("idleTaskExecutionLimit");
        props.add("includeAllJMSXProperties");
        props.add("includeSentJMSMessageID");
        props.add("jmsKeyFormatStrategy");
        props.add("jmsMessageType");
        props.add("lazyCreateTransactionManager");
        props.add("lazyStartProducer");
        props.add("mapJmsMessage");
        props.add("maxConcurrentConsumers");
        props.add("maxMessagesPerTask");
        props.add("messageConverter");
        props.add("messageCreatedStrategy");
        props.add("messageIdEnabled");
        props.add("messageListenerContainerFactory");
        props.add("messageTimestampEnabled");
        props.add("password");
        props.add("preserveMessageQos");
        props.add("priority");
        props.add("pubSubNoLocal");
        props.add("receiveTimeout");
        props.add("recoveryInterval");
        props.add("replyTo");
        props.add("replyToCacheLevelName");
        props.add("replyToConcurrentConsumers");
        props.add("replyToConsumerType");
        props.add("replyToDeliveryPersistent");
        props.add("replyToDestinationSelectorName");
        props.add("replyToMaxConcurrentConsumers");
        props.add("replyToOnTimeoutMaxConcurrentConsumers");
        props.add("replyToOverride");
        props.add("replyToSameDestinationAllowed");
        props.add("replyToType");
        props.add("requestTimeout");
        props.add("requestTimeoutCheckerInterval");
        props.add("selector");
        props.add("streamMessageTypeEnabled");
        props.add("subscriptionDurable");
        props.add("subscriptionName");
        props.add("subscriptionShared");
        props.add("synchronous");
        props.add("taskExecutor");
        props.add("temporaryQueueResolver");
        props.add("testConnectionOnStartup");
        props.add("timeToLive");
        props.add("transacted");
        props.add("transactedInOut");
        props.add("transactionManager");
        props.add("transactionName");
        props.add("transactionTimeout");
        props.add("transferException");
        props.add("transferExchange");
        props.add("useMessageIDAsCorrelationID");
        props.add("username");
        props.add("waitForProvisionCorrelationToBeUpdatedCounter");
        props.add("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime");
        props.add("waitForTemporaryReplyToToBeUpdatedCounter");
        props.add("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

