/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.UrlRewrite;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.CamelFilterWrapper;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.MultiPartFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpComponent
extends HttpComponent {
    public static final String TMP_DIR = "CamelJettyTempDir";
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent.class);
    private static final String JETTY_SSL_KEYSTORE = "org.eclipse.jetty.ssl.keystore";
    private static final String JETTY_SSL_KEYPASSWORD = "org.eclipse.jetty.ssl.keypassword";
    private static final String JETTY_SSL_PASSWORD = "org.eclipse.jetty.ssl.password";
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected Map<Integer, SslSelectChannelConnector> sslSocketConnectors;
    protected Map<Integer, SelectChannelConnector> socketConnectors;
    protected Map<String, Object> sslSocketConnectorProperties;
    protected Map<String, Object> socketConnectorProperties;
    protected Integer httpClientMinThreads;
    protected Integer httpClientMaxThreads;
    protected Integer minThreads;
    protected Integer maxThreads;
    protected ThreadPool threadPool;
    protected MBeanContainer mbContainer;
    protected boolean enableJmx;
    protected JettyHttpBinding jettyHttpBinding;
    protected Long continuationTimeout;
    protected boolean useContinuation = true;
    protected SSLContextParameters sslContextParameters;
    protected Integer requestBufferSize;
    protected Integer requestHeaderSize;
    protected Integer responseBufferSize;
    protected Integer responseHeaderSize;
    protected String proxyHost;
    private Integer proxyPort;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        List handlerList = this.resolveAndRemoveReferenceListParameter(parameters, "handlers", Handler.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        JettyHttpBinding jettyBinding = (JettyHttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "jettyHttpBindingRef", JettyHttpBinding.class);
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        Boolean enableMultipartFilter = (Boolean)this.getAndRemoveParameter(parameters, "enableMultipartFilter", Boolean.class, true);
        Filter multipartFilter = (Filter)this.resolveAndRemoveReferenceParameter(parameters, "multipartFilterRef", Filter.class);
        List filters = this.resolveAndRemoveReferenceListParameter(parameters, "filtersRef", Filter.class);
        Long continuationTimeout = (Long)this.getAndRemoveParameter(parameters, "continuationTimeout", Long.class);
        Boolean useContinuation = (Boolean)this.getAndRemoveParameter(parameters, "useContinuation", Boolean.class);
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParametersRef", SSLContextParameters.class);
        SSLContextParameters ssl = sslContextParameters != null ? sslContextParameters : this.sslContextParameters;
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class, this.getProxyHost());
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class, this.getProxyPort());
        Integer responseBufferSize = (Integer)this.getAndRemoveParameter(parameters, "responseBufferSize", Integer.class, this.getResponseBufferSize());
        Integer httpClientMinThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMinThreads", Integer.class, this.httpClientMinThreads);
        Integer httpClientMaxThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMaxThreads", Integer.class, this.httpClientMaxThreads);
        Map httpClientParameters = IntrospectionSupport.extractProperties(parameters, (String)"httpClient.");
        String address = remaining;
        URI addressUri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)address));
        URI endpointUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        JettyHttpEndpoint endpoint = new JettyHttpEndpoint(this, endpointUri.toString(), httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (httpClientParameters != null && !httpClientParameters.isEmpty()) {
            endpoint.setHttpClientParameters(httpClientParameters);
        }
        if (handlerList.size() > 0) {
            endpoint.setHandlers(handlerList);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (jettyBinding == null) {
            jettyBinding = this.getJettyHttpBinding();
        }
        if (jettyBinding != null) {
            endpoint.setJettyBinding(jettyBinding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        endpoint.setEnableMultipartFilter(enableMultipartFilter);
        if (multipartFilter != null) {
            endpoint.setMultipartFilter(multipartFilter);
            endpoint.setEnableMultipartFilter(true);
        }
        if (filters != null) {
            endpoint.setFilters(filters);
        }
        if (continuationTimeout != null) {
            endpoint.setContinuationTimeout(continuationTimeout);
        }
        if (useContinuation != null) {
            endpoint.setUseContinuation(useContinuation);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (ssl != null) {
            endpoint.setSslContextParameters(ssl);
        }
        if (responseBufferSize != null) {
            endpoint.setResponseBufferSize(responseBufferSize);
        }
        if (httpClientMinThreads != null) {
            endpoint.setHttpClientMinThreads(httpClientMinThreads);
        }
        if (httpClientMaxThreads != null) {
            endpoint.setHttpClientMaxThreads(httpClientMaxThreads);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(endpoint) : this.getSocketConnector(endpoint.getPort());
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getHttpUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)? " + (Object)((Object)endpoint));
                }
                Server server = this.createServer();
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                server.setSendServerVersion(endpoint.isSendServerVersion());
                server.addConnector((Connector)connector);
                connectorRef = new ConnectorRef(server, (Connector)connector, this.createServletForConnector(server, (Connector)connector, endpoint.getHandlers(), endpoint));
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                connectorRef.server.start();
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                if (endpoint.getHandlers() != null && !endpoint.getHandlers().isEmpty()) {
                    connectorRef.server.stop();
                    this.addJettyHandlers(connectorRef.server, endpoint.getHandlers());
                    connectorRef.server.start();
                }
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server, connectorKey);
            }
            if (endpoint.isEnableMultipartFilter()) {
                this.enableMultipartFilter(endpoint, connectorRef.server, connectorKey);
            }
            if (endpoint.getFilters() != null && endpoint.getFilters().size() > 0) {
                this.setFilters(endpoint, connectorRef.server, connectorKey);
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            server.getContainer().addEventListener((Container.Listener)containerToRegister);
        }
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private void setFilters(JettyHttpEndpoint endpoint, Server server, String connectorKey) {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        List<Filter> filters = endpoint.getFilters();
        for (Filter filter : filters) {
            FilterHolder filterHolder = new FilterHolder();
            filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
            String pathSpec = endpoint.getPath();
            if (pathSpec == null || "".equals(pathSpec)) {
                pathSpec = "/";
            }
            if (endpoint.isMatchOnUriPrefix()) {
                pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
            }
            this.addFilter(context, filterHolder, pathSpec);
        }
    }

    private void addFilter(ServletContextHandler context, FilterHolder filterHolder, String pathSpec) {
        context.getServletHandler().addFilterWithMapping(filterHolder, pathSpec, 0);
    }

    private void enableMultipartFilter(HttpEndpoint endpoint, Server server, String connectorKey) throws Exception {
        Filter filter;
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        CamelContext camelContext = this.getCamelContext();
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("deleteFiles", "true");
        if (ObjectHelper.isNotEmpty((Object)camelContext.getProperty(TMP_DIR))) {
            File file = new File(camelContext.getProperty(TMP_DIR));
            if (!file.isDirectory()) {
                throw new RuntimeCamelException("The temp file directory of camel-jetty is not exists, please recheck it with directory name :" + (String)camelContext.getProperties().get(TMP_DIR));
            }
            context.setAttribute("javax.servlet.context.tempdir", (Object)file);
        }
        if ((filter = ((JettyHttpEndpoint)endpoint).getMultipartFilter()) == null) {
            filter = new MultiPartFilter();
        }
        filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
        String pathSpec = endpoint.getPath();
        if (pathSpec == null || "".equals(pathSpec)) {
            pathSpec = "/";
        }
        if (endpoint.isMatchOnUriPrefix()) {
            pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
        }
        this.addFilter(context, filterHolder, pathSpec);
        LOG.debug("using multipart filter implementation " + filter.getClass().getName() + " for path " + pathSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.mbContainer.removeBean((Object)connectorRef.server);
                        this.mbContainer.removeBean((Object)connectorRef.connector);
                    }
                }
            }
        }
    }

    private String getConnectorKey(HttpEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    protected SslSelectChannelConnector getSslSocketConnector(JettyHttpEndpoint endpoint) throws Exception {
        SslSelectChannelConnector answer = null;
        if (this.sslSocketConnectors != null) {
            answer = this.sslSocketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createSslSocketConnector(endpoint);
        }
        return answer;
    }

    protected SslSelectChannelConnector createSslSocketConnector(JettyHttpEndpoint endpoint) throws Exception {
        SslSelectChannelConnector answer = null;
        SSLContextParameters endpointSslContextParameters = endpoint.getSslContextParameters();
        if (endpointSslContextParameters != null) {
            SslContextFactory contextFact = new SslContextFactory(){

                public boolean checkConfig() {
                    if (this.getSslContext() == null) {
                        return JettyHttpComponent.this.checkSSLContextFactoryConfig((Object)this);
                    }
                    return true;
                }

                public void checkKeyStore() {
                }
            };
            contextFact.setSslContext(endpointSslContextParameters.createSSLContext());
            for (Constructor<?> c : SslSelectChannelConnector.class.getConstructors()) {
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isInstance(contextFact)) continue;
                answer = (SslSelectChannelConnector)c.newInstance(contextFact);
            }
        } else {
            answer = new SslSelectChannelConnector();
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                this.setKeyStorePath(answer, keystoreProperty);
            } else if (this.sslKeystore != null) {
                this.setKeyStorePath(answer, this.sslKeystore);
            }
            String keystorePassword = System.getProperty(JETTY_SSL_KEYPASSWORD);
            if (keystorePassword != null) {
                this.setKeyManagerPassword(answer, keystorePassword);
            } else if (this.sslKeyPassword != null) {
                this.setKeyManagerPassword(answer, this.sslKeyPassword);
            }
            String password = System.getProperty(JETTY_SSL_PASSWORD);
            if (password != null) {
                this.setKeyStorePassword(answer, password);
            } else if (this.sslPassword != null) {
                this.setKeyStorePassword(answer, this.sslPassword);
            }
        }
        if (this.getSslSocketConnectorProperties() != null) {
            if (endpointSslContextParameters != null) {
                LOG.warn("An SSLContextParameters instance is configured in addition to SslSocketConnectorProperties.  Any SslSocketConnector propertiesrelated to the SSLContext will be ignored in favor of the settings provided throughSSLContextParameters.");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>(this.getSslSocketConnectorProperties());
            IntrospectionSupport.setProperties((Object)answer, properties);
            if (properties.size() > 0) {
                throw new IllegalArgumentException("There are " + properties.size() + " parameters that couldn't be set on the SslSocketConnector." + " Check the uri if the parameters are spelt correctly and that they are properties of the SslSocketConnector." + " Unknown parameters=[" + properties + "]");
            }
        }
        if (answer != null && this.requestBufferSize != null) {
            answer.setRequestBufferSize(this.requestBufferSize.intValue());
        }
        if (answer != null && this.requestHeaderSize != null) {
            answer.setRequestHeaderSize(this.requestHeaderSize.intValue());
        }
        if (answer != null && this.responseBufferSize != null) {
            answer.setResponseBufferSize(this.responseBufferSize.intValue());
        }
        if (answer != null && this.responseHeaderSize != null) {
            answer.setResponseBufferSize(this.responseHeaderSize.intValue());
        }
        return answer;
    }

    private void invokeSslContextFactoryMethod(Object connector, String method, String value) {
        Object factory;
        try {
            factory = connector.getClass().getMethod("getSslContextFactory", new Class[0]).invoke(connector, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error invoking method getSslContextFactory on " + connector, (Throwable)e);
        }
        try {
            factory.getClass().getMethod(method, String.class).invoke(factory, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error invoking method " + method + " on " + factory, (Throwable)e);
        }
    }

    private void setKeyStorePassword(SslSelectChannelConnector answer, String password) {
        this.invokeSslContextFactoryMethod(answer, "setKeyStorePassword", password);
    }

    private void setKeyManagerPassword(SslSelectChannelConnector answer, String keystorePassword) {
        this.invokeSslContextFactoryMethod(answer, "setKeyManagerPassword", keystorePassword);
    }

    private void setKeyStorePath(SslSelectChannelConnector answer, String keystoreProperty) {
        this.invokeSslContextFactoryMethod(answer, "setKeyStorePath", keystoreProperty);
    }

    protected boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public Map<Integer, SslSelectChannelConnector> getSslSocketConnectors() {
        return this.sslSocketConnectors;
    }

    public void setSslSocketConnectors(Map<Integer, SslSelectChannelConnector> connectors) {
        this.sslSocketConnectors = connectors;
    }

    public SelectChannelConnector getSocketConnector(int port) throws Exception {
        SelectChannelConnector answer = null;
        if (this.socketConnectors != null) {
            answer = this.socketConnectors.get(port);
        }
        if (answer == null) {
            answer = this.createSocketConnector();
        }
        return answer;
    }

    protected SelectChannelConnector createSocketConnector() throws Exception {
        SelectChannelConnector answer = new SelectChannelConnector();
        if (this.getSocketConnectorProperties() != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>(this.getSocketConnectorProperties());
            IntrospectionSupport.setProperties((Object)answer, properties);
            if (properties.size() > 0) {
                throw new IllegalArgumentException("There are " + properties.size() + " parameters that couldn't be set on the SocketConnector." + " Check the uri if the parameters are spelt correctly and that they are properties of the SelectChannelConnector." + " Unknown parameters=[" + properties + "]");
            }
        }
        if (this.requestBufferSize != null) {
            answer.setRequestBufferSize(this.requestBufferSize.intValue());
        }
        if (this.requestHeaderSize != null) {
            answer.setRequestHeaderSize(this.requestHeaderSize.intValue());
        }
        if (this.responseBufferSize != null) {
            answer.setResponseBufferSize(this.responseBufferSize.intValue());
        }
        if (this.responseHeaderSize != null) {
            answer.setResponseBufferSize(this.responseHeaderSize.intValue());
        }
        return answer;
    }

    public void setSocketConnectors(Map<Integer, SelectChannelConnector> socketConnectors) {
        this.socketConnectors = socketConnectors;
    }

    public static CamelHttpClient createHttpClient(JettyHttpEndpoint endpoint, Integer minThreads, Integer maxThreads, SSLContextParameters ssl) throws Exception {
        int port;
        String host;
        CamelHttpClient httpClient = new CamelHttpClient();
        httpClient.setConnectorType(2);
        CamelContext context = endpoint.getCamelContext();
        if (context != null && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyPort"))) {
            host = context.getProperty("http.proxyHost");
            port = Integer.parseInt(context.getProperty("http.proxyPort"));
            LOG.debug("CamelContext properties http.proxyHost and http.proxyPort detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(new Address(host, port));
        }
        if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyHost()) && endpoint.getProxyPort() > 0) {
            host = endpoint.getProxyHost();
            port = endpoint.getProxyPort();
            LOG.debug("proxyHost and proxyPort options detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(new Address(host, port));
        }
        if (minThreads != null || maxThreads != null) {
            if (minThreads == null || maxThreads == null) {
                throw new IllegalArgumentException("Both min and max thread pool sizes must be provided.");
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            qtp.setMinThreads(minThreads.intValue());
            qtp.setMaxThreads(maxThreads.intValue());
            qtp.setDaemon(true);
            qtp.setName("CamelJettyClient(" + ObjectHelper.getIdentityHashCode((Object)((Object)httpClient)) + ")");
            httpClient.setThreadPool((ThreadPool)qtp);
        }
        if (ssl != null) {
            httpClient.setSSLContext(ssl.createSSLContext());
        }
        if (LOG.isDebugEnabled()) {
            if (minThreads != null) {
                LOG.debug("Created HttpClient with thread pool {}-{} -> {}", new Object[]{minThreads, maxThreads, httpClient});
            } else {
                LOG.debug("Created HttpClient with default thread pool size -> {}", (Object)httpClient);
            }
        }
        return httpClient;
    }

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public JettyHttpBinding getJettyHttpBinding() {
        return this.jettyHttpBinding;
    }

    public void setJettyHttpBinding(JettyHttpBinding jettyHttpBinding) {
        this.jettyHttpBinding = jettyHttpBinding;
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            MBeanServer mbs = null;
            ManagementStrategy mStrategy = this.getCamelContext().getManagementStrategy();
            ManagementAgent mAgent = mStrategy.getManagementAgent();
            if (mAgent != null) {
                mbs = mAgent.getMBeanServer();
            }
            if (mbs != null) {
                this.mbContainer = new MBeanContainer(mbs);
                this.startMbContainer();
            } else {
                LOG.warn("JMX disabled in CamelContext. Jetty JMX extensions will remain disabled.");
            }
        }
        return this.mbContainer;
    }

    public void setMbContainer(MBeanContainer mbContainer) {
        this.mbContainer = mbContainer;
    }

    public Map<String, Object> getSslSocketConnectorProperties() {
        return this.sslSocketConnectorProperties;
    }

    public void setSslSocketConnectorProperties(Map<String, Object> sslSocketConnectorProperties) {
        this.sslSocketConnectorProperties = sslSocketConnectorProperties;
    }

    public Map<String, Object> getSocketConnectorProperties() {
        return this.socketConnectorProperties;
    }

    public void setSocketConnectorProperties(Map<String, Object> socketConnectorProperties) {
        this.socketConnectorProperties = socketConnectorProperties;
    }

    public void addSocketConnectorProperty(String key, Object value) {
        if (this.socketConnectorProperties == null) {
            this.socketConnectorProperties = new HashMap<String, Object>();
        }
        this.socketConnectorProperties.put(key, value);
    }

    public void addSslSocketConnectorProperty(String key, Object value) {
        if (this.sslSocketConnectorProperties == null) {
            this.sslSocketConnectorProperties = new HashMap<String, Object>();
        }
        this.sslSocketConnectorProperties.put(key, value);
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public boolean isUseContinuation() {
        return this.useContinuation;
    }

    public void setUseContinuation(boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public Integer getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(Integer requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public void setRequestHeaderSize(Integer requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(Integer responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected CamelServlet createServletForConnector(Server server, Connector connector, List<Handler> handlers, JettyHttpEndpoint endpoint) throws Exception {
        CamelServlet camelServlet;
        boolean jetty;
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        this.addJettyHandlers(server, handlers);
        boolean bl = jetty = endpoint.getUseContinuation() != null ? endpoint.getUseContinuation().booleanValue() : this.isUseContinuation();
        if (jetty) {
            Long timeout;
            CamelContinuationServlet jettyServlet = new CamelContinuationServlet();
            Long l = timeout = endpoint.getContinuationTimeout() != null ? endpoint.getContinuationTimeout() : this.getContinuationTimeout();
            if (timeout != null) {
                LOG.info("Using Jetty continuation timeout: " + timeout + " millis for: " + (Object)((Object)endpoint));
                jettyServlet.setContinuationTimeout(timeout);
            } else {
                LOG.info("Using default Jetty continuation timeout for: " + (Object)((Object)endpoint));
            }
            camelServlet = jettyServlet;
        } else {
            camelServlet = new CamelServlet();
            LOG.info("Jetty continuation is disabled for: " + (Object)((Object)endpoint));
        }
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        context.addServlet(holder, "/*");
        return camelServlet;
    }

    protected void addJettyHandlers(Server server, List<Handler> handlers) {
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof HandlerWrapper) {
                    ((HandlerWrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                HandlerCollection handlerCollection = new HandlerCollection();
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler((Handler)handlerCollection);
            }
        }
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + (Object)((Object)this));
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            if (this.minThreads != null) {
                qtp.setMinThreads(this.minThreads.intValue());
            }
            if (this.maxThreads != null) {
                qtp.setMaxThreads(this.maxThreads.intValue());
            }
            qtp.setName("CamelJettyServer(" + ObjectHelper.getIdentityHashCode((Object)server) + ")");
            try {
                qtp.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyServer thread pool: " + qtp, (Throwable)e);
            }
            server.setThreadPool((ThreadPool)qtp);
        }
        if (this.getThreadPool() != null) {
            server.setThreadPool(this.getThreadPool());
        }
        return server;
    }

    protected void startMbContainer() {
        if (this.mbContainer != null && !this.mbContainer.isStarted()) {
            try {
                this.mbContainer.start();
                this.mbContainer.addBean((Object)this.mbContainer);
            }
            catch (Throwable e) {
                LOG.warn("Could not start Jetty MBeanContainer. Jetty JMX extensions will remain disabled.", e);
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.startMbContainer();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (CONNECTORS.size() > 0) {
            for (String connectorKey : CONNECTORS.keySet()) {
                ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
                if (connectorRef == null || connectorRef.getRefCount() != 0) continue;
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                connectorRef.server.stop();
                if (this.mbContainer != null) {
                    this.mbContainer.removeBean((Object)connectorRef.server);
                    this.mbContainer.removeBean((Object)connectorRef.connector);
                }
                CONNECTORS.remove(connectorKey);
            }
        }
        if (this.mbContainer != null) {
            this.mbContainer.stop();
            this.mbContainer = null;
        }
    }

    class ConnectorRef {
        Server server;
        Connector connector;
        CamelServlet servlet;
        int refCount;

        public ConnectorRef(Server server, Connector connector, CamelServlet servlet) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

