/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.component.http4.HttpPollingConsumer;
import org.apache.camel.component.http4.HttpProducer;
import org.apache.camel.component.http4.NoopCookieStore;
import org.apache.camel.component.http4.PreemptiveAuthInterceptor;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="http4,http4s", title="HTTP4,HTTP4S", syntax="http4:httpUri", producerOnly=true, label="http", lenientProperties=true)
public class HttpEndpoint
extends HttpCommonEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    @UriParam(label="advanced")
    private HttpContext httpContext;
    @UriParam(label="advanced")
    private HttpClientConfigurer httpClientConfigurer;
    @UriParam(label="advanced", prefix="httpClient.", multiValue=true)
    private Map<String, Object> httpClientOptions;
    @UriParam(label="advanced")
    private HttpClientConnectionManager clientConnectionManager;
    @UriParam(label="advanced")
    private HttpClientBuilder clientBuilder;
    @UriParam(label="advanced")
    private HttpClient httpClient;
    @UriParam(label="producer")
    private CookieStore cookieStore = new BasicCookieStore();
    @UriParam(label="producer")
    private boolean authenticationPreemptive;
    @UriParam(label="producer", defaultValue="true")
    private boolean clearExpiredCookies = true;

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientConnectionManager clientConnectionManager) throws URISyntaxException {
        this(endPointURI, component, httpURI, HttpClientBuilder.create(), clientConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        this(endPointURI, component, null, clientBuilder, clientConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (HttpCommonComponent)component, httpURI);
        this.clientBuilder = clientBuilder;
        this.httpClientConfigurer = clientConfigurer;
        this.clientConnectionManager = clientConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from http endpoint");
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpClient createHttpClient() {
        HttpClientConfigurer configurer;
        ObjectHelper.notNull((Object)this.clientBuilder, (String)"httpClientBuilder");
        ObjectHelper.notNull((Object)this.clientConnectionManager, (String)"httpConnectionManager");
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setConnectionManager(this.clientConnectionManager);
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() == this.getClientConnectionManager()) {
            this.clientBuilder.setConnectionManagerShared(true);
        }
        if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyPort"))) {
            String host = this.getCamelContext().getProperty("http.proxyHost");
            int port = Integer.parseInt(this.getCamelContext().getProperty("http.proxyPort"));
            String scheme = this.getCamelContext().getProperty("http.proxyScheme");
            if (scheme == null) {
                scheme = HttpHelper.isSecureConnection((String)this.getEndpointUri()) ? "https" : "http";
            }
            LOG.debug("CamelContext properties http.proxyHost, http.proxyPort, and http.proxyScheme detected. Using http proxy host: {} port: {} scheme: {}", new Object[]{host, port, scheme});
            HttpHost proxy = new HttpHost(host, port, scheme);
            this.clientBuilder.setProxy(proxy);
        }
        if (this.isAuthenticationPreemptive()) {
            this.clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        }
        if ((configurer = this.getHttpClientConfigurer()) != null) {
            configurer.configureHttpClient(this.clientBuilder);
        }
        if (this.isBridgeEndpoint()) {
            this.clientBuilder.setDefaultCookieStore((CookieStore)new NoopCookieStore());
        }
        LOG.debug("Setup the HttpClientBuilder {}", (Object)this.clientBuilder);
        return this.clientBuilder.build();
    }

    public HttpComponent getComponent() {
        return (HttpComponent)super.getComponent();
    }

    protected void doStop() throws Exception {
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() != this.clientConnectionManager) {
            this.clientConnectionManager.shutdown();
        }
        if (this.httpClient != null && this.httpClient instanceof Closeable) {
            IOHelper.close((Closeable)((Closeable)this.httpClient));
        }
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public void setClientBuilder(HttpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public boolean isClearExpiredCookies() {
        return this.clearExpiredCookies;
    }

    public void setClearExpiredCookies(boolean clearExpiredCookies) {
        this.clearExpiredCookies = clearExpiredCookies;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    public void setAuthenticationPreemptive(boolean authenticationPreemptive) {
        this.authenticationPreemptive = authenticationPreemptive;
    }

    public Map<String, Object> getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public void setHttpClientOptions(Map<String, Object> httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
    }
}

