/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cafe;

import org.apache.camel.example.cafe.DrinkType;
import org.apache.camel.example.cafe.Order;
import org.apache.camel.util.ObjectHelper;

public class OrderItem {
    private DrinkType type;
    private int shots = 1;
    private boolean iced;
    private final Order order;

    public OrderItem(Order order, DrinkType type, int shots, boolean iced) {
        this.order = order;
        this.type = type;
        this.shots = shots;
        this.iced = iced;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isIced() {
        return this.iced;
    }

    public int getShots() {
        return this.shots;
    }

    public DrinkType getDrinkType() {
        return this.type;
    }

    public String toString() {
        return (this.iced ? "iced " : "hot ") + this.shots + " shot " + (Object)((Object)this.type);
    }

    public boolean equals(Object o) {
        if (o instanceof OrderItem) {
            OrderItem that = (OrderItem)o;
            return ObjectHelper.equal((Object)((Object)this.type), (Object)((Object)that.type)) && ObjectHelper.equal((Object)this.order.getNumber(), (Object)that.order.getNumber()) && ObjectHelper.equal((Object)this.iced, (Object)that.iced) && ObjectHelper.equal((Object)this.shots, (Object)that.shots);
        }
        return false;
    }

    public int hashCode() {
        if (this.iced) {
            return this.type.hashCode() + this.order.getNumber() * 10000 + this.shots * 100;
        }
        return this.type.hashCode() + this.order.getNumber() * 10000 + this.shots * 100 + 5;
    }
}

