/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cafe;

import java.util.List;
import org.apache.camel.example.cafe.Drink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delivery {
    private static final String SEPARATOR = "-----------------------";
    private List<Drink> deliveredDrinks;
    private int orderNumber;

    public Delivery(List<Drink> deliveredDrinks) {
        assert (deliveredDrinks.size() > 0);
        this.deliveredDrinks = deliveredDrinks;
        this.orderNumber = deliveredDrinks.get(0).getOrderNumber();
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public List<Drink> getDeliveredDrinks() {
        return this.deliveredDrinks;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("-----------------------\n");
        buffer.append("Order #" + this.getOrderNumber() + "\n");
        for (Drink drink : this.getDeliveredDrinks()) {
            buffer.append(drink);
            buffer.append("\n");
        }
        buffer.append("-----------------------\n");
        return buffer.toString();
    }
}

