/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cafe;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.example.cafe.DrinkType;
import org.apache.camel.example.cafe.Order;
import org.apache.camel.example.cafe.stuff.Barista;
import org.apache.camel.example.cafe.stuff.CafeAggregationStrategy;
import org.apache.camel.example.cafe.stuff.DrinkRouter;
import org.apache.camel.example.cafe.stuff.OrderSplitter;
import org.apache.camel.example.cafe.stuff.Waiter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.Registry;

public class CafeRouteBuilder
extends RouteBuilder {
    public static void main(String[] args) throws Exception {
        CafeRouteBuilder builder = new CafeRouteBuilder();
        builder.runCafeRouteDemo();
    }

    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = new JndiRegistry();
        jndi.bind("drinkRouter", (Object)new DrinkRouter());
        jndi.bind("orderSplitter", (Object)new OrderSplitter());
        jndi.bind("barista", (Object)new Barista());
        jndi.bind("waiter", (Object)new Waiter());
        jndi.bind("aggregatorStrategy", (Object)new CafeAggregationStrategy());
        return jndi;
    }

    public void runCafeRouteDemo() throws Exception {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.setRegistry((Registry)this.createRegistry());
        camelContext.addRoutes((RoutesBuilder)this);
        camelContext.start();
        ProducerTemplate template = camelContext.createProducerTemplate();
        Order order = new Order(2);
        order.addItem(DrinkType.ESPRESSO, 2, true);
        order.addItem(DrinkType.CAPPUCCINO, 4, false);
        order.addItem(DrinkType.LATTE, 4, false);
        order.addItem(DrinkType.MOCHA, 2, false);
        template.sendBody("direct:cafe", (Object)order);
        Thread.sleep(6000L);
        camelContext.stop();
    }

    public void configure() {
        ((SplitDefinition)this.from("direct:cafe").split().method("orderSplitter")).to("direct:drink");
        this.from("direct:drink").recipientList().method("drinkRouter");
        ((RouteDefinition)this.from("seda:coldDrinks?concurrentConsumers=2").to("bean:barista?method=prepareColdDrink")).to("direct:deliveries");
        ((RouteDefinition)this.from("seda:hotDrinks?concurrentConsumers=3").to("bean:barista?method=prepareHotDrink")).to("direct:deliveries");
        ((AggregateDefinition)((AggregateDefinition)this.from("direct:deliveries").aggregate((AggregationStrategy)new CafeAggregationStrategy()).method("waiter", "checkOrder")).completionTimeout(5000L).to("bean:waiter?method=prepareDelivery")).to("bean:waiter?method=deliverCafes");
    }
}

