/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPDataFormatUtil;
import org.apache.camel.converter.crypto.PGPSecretKeyAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAndPrivateKeyAndUserId;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public class DefaultPGPSecretKeyAccessor
implements PGPSecretKeyAccessor {
    private final Map<String, List<PGPSecretKeyAndPrivateKeyAndUserId>> userIdPart2SecretKeyList = new HashMap<String, List<PGPSecretKeyAndPrivateKeyAndUserId>>(3);
    private final Map<Long, PGPPrivateKey> keyId2PrivateKey = new HashMap<Long, PGPPrivateKey>(3);
    private final PGPSecretKeyRingCollection pgpSecretKeyring;
    private final String password;
    private final String provider;

    public DefaultPGPSecretKeyAccessor(byte[] secretKeyRing, String password, String provider) throws PGPException, IOException {
        ObjectHelper.notNull((Object)secretKeyRing, (String)"secretKeyRing");
        StringHelper.notEmpty((String)password, (String)"password");
        StringHelper.notEmpty((String)provider, (String)"provider");
        this.pgpSecretKeyring = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(secretKeyRing)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        this.password = password;
        this.provider = provider;
    }

    @Override
    public List<PGPSecretKeyAndPrivateKeyAndUserId> getSignerKeys(Exchange exchange, List<String> useridParts) throws Exception {
        ArrayList<PGPSecretKeyAndPrivateKeyAndUserId> result = new ArrayList<PGPSecretKeyAndPrivateKeyAndUserId>(3);
        for (String useridPart : useridParts) {
            List<PGPSecretKeyAndPrivateKeyAndUserId> partResult = this.userIdPart2SecretKeyList.get(useridPart);
            if (partResult == null) {
                partResult = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(Collections.singletonMap(useridPart, this.password), this.provider, this.pgpSecretKeyring);
                this.userIdPart2SecretKeyList.put(useridPart, partResult);
            }
            result.addAll(partResult);
        }
        return result;
    }

    @Override
    public PGPPrivateKey getPrivateKey(Exchange exchange, long keyId) throws Exception {
        Long keyIdLong = keyId;
        PGPPrivateKey result = this.keyId2PrivateKey.get(keyIdLong);
        if (result == null && (result = PGPDataFormatUtil.findPrivateKeyWithkeyId(keyId, this.password, null, this.provider, this.pgpSecretKeyring)) != null) {
            this.keyId2PrivateKey.put(keyIdLong, result);
        }
        return result;
    }
}

