/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.util.ServiceHelper;

@XmlRootElement(name="proxy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelProxyFactoryBean
extends AbstractCamelFactoryBean<Object> {
    @XmlAttribute
    private String serviceUrl;
    @XmlAttribute
    private String serviceRef;
    @XmlAttribute
    private String serviceInterface;
    @XmlTransient
    private Endpoint endpoint;
    @XmlTransient
    private Object serviceProxy;
    @XmlTransient
    private Producer producer;
    @XmlTransient
    private ExtendedBlueprintContainer blueprintContainer;

    @Override
    public Object getObject() {
        return this.serviceProxy;
    }

    @Override
    public Class<Object> getObjectType() {
        return Object.class;
    }

    @Override
    protected CamelContext getCamelContextWithId(String camelContextId) {
        if (this.blueprintContainer != null) {
            return (CamelContext)this.blueprintContainer.getComponentInstance(camelContextId);
        }
        return null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.endpoint == null) {
            this.getCamelContext();
            if (this.getServiceUrl() == null && this.getServiceRef() == null) {
                throw new IllegalArgumentException("serviceUrl or serviceRef must be specified.");
            }
            if (this.getServiceInterface() == null) {
                throw new IllegalArgumentException("serviceInterface must be specified.");
            }
            this.endpoint = this.getServiceRef() != null ? (Endpoint)this.getCamelContext().getRegistry().lookup(this.getServiceRef(), Endpoint.class) : this.getCamelContext().getEndpoint(this.getServiceUrl());
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Could not resolve endpoint: " + this.getServiceUrl());
            }
        }
        try {
            this.producer = this.endpoint.createProducer();
            ServiceHelper.startService((Service)this.producer);
            Class clazz = this.blueprintContainer.loadClass(this.getServiceInterface());
            this.serviceProxy = ProxyHelper.createProxy((Endpoint)this.endpoint, (Producer)this.producer, (Class[])new Class[]{clazz});
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(this.endpoint, (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Exception {
        ServiceHelper.stopService((Object)this.producer);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(String serviceRef) {
        this.serviceRef = serviceRef;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public ExtendedBlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }
}

