/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.CamelContextHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintComponentResolver
extends OsgiComponentResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(BlueprintComponentResolver.class);

    public BlueprintComponentResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    @Override
    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean instanceof Component) {
                LOG.debug("Found component: {} in registry: {}", (Object)name, bean);
                return (Component)bean;
            }
            Component component = (Component)CamelContextHelper.convertTo((CamelContext)context, Component.class, (Object)bean);
            if (component != null) {
                return component;
            }
        }
        catch (Exception e) {
            LOG.debug("Ignored error looking up bean: " + name + ". Error: " + e);
        }
        try {
            bean = context.getRegistry().lookup(".camelBlueprint.componentResolver." + name);
            if (bean instanceof ComponentResolver) {
                LOG.debug("Found component resolver: {} in registry: {}", (Object)name, bean);
                return ((ComponentResolver)bean).resolveComponent(name, context);
            }
        }
        catch (Exception e) {
            LOG.debug("Ignored error looking up bean: " + name + ". Error: " + e);
        }
        return this.getComponent(name, context);
    }
}

