/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class IntegerPatternFormatFactory
extends AbstractFormatFactory {
    public IntegerPatternFormatFactory() {
        this.supportedClasses.add(Integer.TYPE);
        this.supportedClasses.add(Integer.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((String)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new IntegerPatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class IntegerPatternFormat
    extends NumberPatternFormat<Integer> {
        IntegerPatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Integer parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().parse(string).intValue();
            }
            return Integer.valueOf(string);
        }
    }
}

