/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.properties.ClasspathPropertiesSource;
import org.apache.camel.component.properties.DefaultPropertiesFunctionResolver;
import org.apache.camel.component.properties.DefaultPropertiesLookup;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.EnvPropertiesFunction;
import org.apache.camel.component.properties.FilePropertiesSource;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesFunctionResolver;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.RefPropertiesSource;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.component.properties.ServicePropertiesFunction;
import org.apache.camel.component.properties.SysPropertiesFunction;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed PropertiesComponent")
@JdkService(value="properties-component-factory")
@Configurer(bootstrap=true)
public class PropertiesComponent
extends ServiceSupport
implements org.apache.camel.spi.PropertiesComponent,
StaticService,
CamelContextAware {
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    public static final int ENVIRONMENT_VARIABLES_MODE_NEVER = 0;
    public static final int ENVIRONMENT_VARIABLES_MODE_FALLBACK = 1;
    public static final int ENVIRONMENT_VARIABLES_MODE_OVERRIDE = 2;
    public static final String OVERRIDE_PROPERTIES = PropertiesComponent.class.getName() + ".OverrideProperties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesComponent.class);
    private static final String NEGATE_PREFIX = "{{!";
    private CamelContext camelContext;
    private PropertiesFunctionResolver propertiesFunctionResolver = new DefaultPropertiesFunctionResolver();
    private PropertiesParser propertiesParser = new DefaultPropertiesParser(this);
    private final PropertiesLookup propertiesLookup = new DefaultPropertiesLookup(this);
    private final List<PropertiesLookupListener> propertiesLookupListeners = new ArrayList<PropertiesLookupListener>();
    private final List<PropertiesSource> sources = new ArrayList<PropertiesSource>();
    private List<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
    private String location;
    private boolean ignoreMissingLocation;
    private boolean nestedPlaceholder = true;
    private String encoding;
    private boolean defaultFallbackEnabled = true;
    private Properties initialProperties;
    private Properties overrideProperties;
    private final ThreadLocal<Properties> localProperties = new ThreadLocal();
    private volatile boolean localPropertiesEnabled;
    private int systemPropertiesMode = 2;
    private int environmentVariableMode = 2;
    private boolean autoDiscoverPropertiesSources = true;

    public PropertiesComponent() {
        this.addPropertiesFunction(new EnvPropertiesFunction());
        this.addPropertiesFunction(new SysPropertiesFunction());
        this.addPropertiesFunction(new ServicePropertiesFunction());
        this.addPropertiesFunction(new ServiceHostPropertiesFunction());
        this.addPropertiesFunction(new ServicePortPropertiesFunction());
    }

    public PropertiesComponent(String location) {
        this();
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this();
        this.setLocations(locations);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String parseUri(String uri) {
        return this.parseUri(uri, false);
    }

    public String parseUri(String uri, boolean keepUnresolvedOptional) {
        return this.parseUri(uri, this.propertiesLookup, keepUnresolvedOptional);
    }

    public Optional<String> resolveProperty(String key) {
        try {
            String value = this.parseUri(key, this.propertiesLookup, false);
            return Optional.of(value);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public Properties loadProperties() {
        OrderedLocationProperties prop = new OrderedLocationProperties();
        if (this.initialProperties != null) {
            prop.putAll("initial", this.initialProperties);
        }
        if (!this.sources.isEmpty()) {
            int i = this.sources.size();
            while (i-- > 0) {
                PropertiesSource ps = this.sources.get(i);
                if (!(ps instanceof LoadablePropertiesSource)) continue;
                LoadablePropertiesSource lps = (LoadablePropertiesSource)ps;
                Properties p = lps.loadProperties();
                if (p instanceof OrderedLocationProperties) {
                    prop.putAll((OrderedLocationProperties)p);
                    continue;
                }
                if (ps instanceof LocationPropertiesSource) {
                    String loc = ((LocationPropertiesSource)ps).getLocation().getPath();
                    prop.putAll(loc, p);
                    continue;
                }
                prop.putAll(lps.getName(), p);
            }
        }
        if (this.overrideProperties != null) {
            OrderedLocationProperties override = new OrderedLocationProperties();
            override.putAll(prop);
            override.putAll("override", this.overrideProperties);
            prop = override;
        }
        return prop;
    }

    public Properties loadProperties(Predicate<String> filter) {
        return this.loadProperties(filter, k -> k);
    }

    public Properties loadProperties(Predicate<String> filter, Function<String, String> keyMapper) {
        Object value;
        OrderedLocationProperties prop = new OrderedLocationProperties();
        if (this.initialProperties != null) {
            for (String name : this.initialProperties.stringPropertyNames()) {
                if (!filter.test(name)) continue;
                value = this.initialProperties.get(name);
                name = keyMapper.apply(name);
                prop.put("initial", (Object)name, value);
            }
        }
        if (!this.sources.isEmpty()) {
            int i = this.sources.size();
            while (i-- > 0) {
                PropertiesSource ps = this.sources.get(i);
                if (!(ps instanceof LoadablePropertiesSource)) continue;
                LoadablePropertiesSource lps = (LoadablePropertiesSource)ps;
                Properties p = lps.loadProperties(filter);
                if (p instanceof OrderedLocationProperties) {
                    OrderedLocationProperties olp = (OrderedLocationProperties)p;
                    for (String name : olp.stringPropertyNames()) {
                        String loc = olp.getLocation((Object)name);
                        String value2 = olp.getProperty(name);
                        name = keyMapper.apply(name);
                        prop.put(loc, (Object)name, (Object)value2);
                    }
                    continue;
                }
                String loc = lps.getName();
                if (ps instanceof LocationPropertiesSource) {
                    LocationPropertiesSource olp = (LocationPropertiesSource)ps;
                    loc = olp.getLocation().getPath();
                }
                for (String name : p.stringPropertyNames()) {
                    String value3 = p.getProperty(name);
                    name = keyMapper.apply(name);
                    prop.put(loc, (Object)name, (Object)value3);
                }
            }
        }
        if (this.overrideProperties != null) {
            for (String name : this.overrideProperties.stringPropertyNames()) {
                if (!filter.test(name)) continue;
                value = this.overrideProperties.get(name);
                name = keyMapper.apply(name);
                prop.put("override", (Object)name, value);
            }
        }
        return prop;
    }

    protected String parseUri(String uri, PropertiesLookup properties, boolean keepUnresolvedOptional) {
        boolean negate;
        LOG.trace("Parsing uri {}", (Object)uri);
        Object key = uri;
        if (!((String)key).contains("{{") && !((String)key).startsWith("{{")) {
            key = "{{" + (String)key;
        }
        if (!((String)key).contains("}}") && !((String)key).endsWith("}}")) {
            key = (String)key + "}}";
        }
        if (negate = ((String)key).startsWith(NEGATE_PREFIX)) {
            key = "{{" + ((String)key).substring(NEGATE_PREFIX.length());
        }
        String answer = this.propertiesParser.parseUri((String)key, properties, this.defaultFallbackEnabled, keepUnresolvedOptional, this.nestedPlaceholder);
        if (negate) {
            if ("true".equalsIgnoreCase(answer)) {
                answer = "false";
            } else if ("false".equalsIgnoreCase(answer)) {
                answer = "true";
            }
        }
        if (answer != null) {
            answer = PropertiesComponent.unescape(answer);
        }
        LOG.trace("Parsed uri {} -> {}", (Object)uri, (Object)answer);
        return answer;
    }

    public List<String> getLocations() {
        if (this.locations.isEmpty()) {
            return Collections.emptyList();
        }
        return this.locations.stream().map(PropertiesLocation::toString).collect(Collectors.toList());
    }

    public void setLocations(List<PropertiesLocation> locations) {
        locations = this.parseLocations(locations);
        this.locations = Collections.unmodifiableList(locations);
        this.sources.removeIf(s -> s instanceof LocationPropertiesSource);
        for (PropertiesLocation loc : locations) {
            this.addPropertiesLocationsAsPropertiesSource(loc);
        }
    }

    public void setLocations(String[] locationStrings) {
        ArrayList<PropertiesLocation> propertiesLocations = new ArrayList<PropertiesLocation>();
        if (locationStrings != null) {
            for (String locationString : locationStrings) {
                propertiesLocations.add(new PropertiesLocation(locationString));
            }
        }
        this.setLocations(propertiesLocations);
    }

    public void addLocation(PropertiesLocation location) {
        this.locations.add(location);
    }

    public void addLocation(String location) {
        if (location != null) {
            ArrayList<PropertiesLocation> newLocations = new ArrayList<PropertiesLocation>();
            for (String loc : location.split(",")) {
                newLocations.add(new PropertiesLocation(loc));
            }
            List<PropertiesLocation> current = this.locations;
            if (!current.isEmpty()) {
                newLocations.addAll(0, current);
            }
            this.setLocations(newLocations);
        }
    }

    public void setLocation(String location) {
        this.location = location;
        if (location != null) {
            this.setLocations(location.split(","));
        }
    }

    public String getLocation() {
        return this.location;
    }

    @ManagedAttribute(description="Encoding to use when loading properties file from the file system or classpath")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    public PropertiesFunctionResolver getPropertiesFunctionResolver() {
        return this.propertiesFunctionResolver;
    }

    public void setPropertiesFunctionResolver(PropertiesFunctionResolver propertiesFunctionResolver) {
        this.propertiesFunctionResolver = propertiesFunctionResolver;
    }

    @ManagedAttribute(description="Whether to support using fallback values if a property cannot be found")
    public boolean isDefaultFallbackEnabled() {
        return this.defaultFallbackEnabled;
    }

    public void setDefaultFallbackEnabled(boolean defaultFallbackEnabled) {
        this.defaultFallbackEnabled = defaultFallbackEnabled;
    }

    @ManagedAttribute(description="Ignore missing location")
    public boolean isIgnoreMissingLocation() {
        return this.ignoreMissingLocation;
    }

    public void setIgnoreMissingLocation(boolean ignoreMissingLocation) {
        this.ignoreMissingLocation = ignoreMissingLocation;
    }

    @ManagedAttribute(description="Nested placeholder")
    public boolean isNestedPlaceholder() {
        return this.nestedPlaceholder;
    }

    public void setNestedPlaceholder(boolean nestedPlaceholder) {
        this.nestedPlaceholder = nestedPlaceholder;
    }

    public Properties getInitialProperties() {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public void setLocalProperties(Properties localProperties) {
        if (localProperties != null) {
            this.localProperties.set(localProperties);
            this.localPropertiesEnabled = true;
        } else {
            this.localProperties.remove();
            this.localPropertiesEnabled = false;
        }
    }

    public Properties getLocalProperties() {
        return this.localPropertiesEnabled ? this.localProperties.get() : null;
    }

    public PropertiesFunction getPropertiesFunction(String name) {
        if (name == null) {
            return null;
        }
        return this.propertiesFunctionResolver.resolvePropertiesFunction(name);
    }

    public void addPropertiesFunction(PropertiesFunction function) {
        this.propertiesFunctionResolver.addPropertiesFunction(function);
    }

    public boolean hasPropertiesFunction(String name) {
        return this.propertiesFunctionResolver.hasFunction(name);
    }

    @ManagedAttribute(description="System properties mode")
    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    @ManagedAttribute(description="Environment variable mode")
    public int getEnvironmentVariableMode() {
        return this.environmentVariableMode;
    }

    public void setEnvironmentVariableMode(int environmentVariableMode) {
        this.environmentVariableMode = environmentVariableMode;
    }

    public boolean isAutoDiscoverPropertiesSources() {
        return this.autoDiscoverPropertiesSources;
    }

    public void setAutoDiscoverPropertiesSources(boolean autoDiscoverPropertiesSources) {
        this.autoDiscoverPropertiesSources = autoDiscoverPropertiesSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertiesSource(PropertiesSource propertiesSource) {
        CamelContextAware.trySetCamelContext((Object)propertiesSource, (CamelContext)this.getCamelContext());
        Object object = this.lock;
        synchronized (object) {
            this.sources.add(propertiesSource);
            this.sources.sort((Comparator<PropertiesSource>)OrderedComparator.get());
            if (!this.isNew()) {
                ServiceHelper.initService((Object)propertiesSource);
            }
            if (this.isStarted()) {
                ServiceHelper.startService((Object)propertiesSource);
            }
        }
    }

    public PropertiesSource getPropertiesSource(String name) {
        for (PropertiesSource source : this.sources) {
            if (!name.equals(source.getName())) continue;
            return source;
        }
        return null;
    }

    public List<PropertiesSource> getPropertiesSources() {
        return this.sources;
    }

    public void addPropertiesLookupListener(PropertiesLookupListener propertiesLookupListener) {
        this.propertiesLookupListeners.add(propertiesLookupListener);
    }

    public void removePropertiesLookupListener(PropertiesLookupListener propertiesLookupListener) {
        this.propertiesLookupListeners.remove(propertiesLookupListener);
    }

    public List<PropertiesLookupListener> getPropertiesLookupListeners() {
        return this.propertiesLookupListeners;
    }

    @ManagedOperation(description="Reload properties from the given location patterns")
    public boolean reloadProperties(String pattern) {
        if (ObjectHelper.isEmpty((String)pattern)) {
            pattern = "*";
        }
        LOG.debug("Reloading properties (pattern: {})", (Object)pattern);
        boolean answer = false;
        for (PropertiesSource source : this.sources) {
            if (!(source instanceof LocationPropertiesSource) || !(source instanceof LoadablePropertiesSource)) continue;
            LocationPropertiesSource loc = (LocationPropertiesSource)source;
            LoadablePropertiesSource loadable = (LoadablePropertiesSource)source;
            String schemeAndPath = loc.getLocation().getResolver() + ":" + loc.getLocation().getPath();
            String path = loc.getLocation().getPath();
            if (!PatternHelper.matchPattern((String)schemeAndPath, (String)pattern) && !PatternHelper.matchPattern((String)path, (String)pattern)) continue;
            loadable.reloadProperties(schemeAndPath);
            LOG.trace("Reloaded properties: {}", (Object)schemeAndPath);
            answer = true;
        }
        return answer;
    }

    public void keepOnlyChangeProperties(Properties properties) {
        Properties loaded = this.loadProperties();
        for (String key : loaded.stringPropertyNames()) {
            String v2;
            String v1 = loaded.getProperty(key);
            if (!Objects.equals(v1, v2 = properties.getProperty(key))) continue;
            properties.remove(key);
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        CamelContextAware.trySetCamelContext((Object)this.propertiesFunctionResolver, (CamelContext)this.camelContext);
        if (this.systemPropertiesMode != 0 && this.systemPropertiesMode != 1 && this.systemPropertiesMode != 2) {
            throw new IllegalArgumentException("Option systemPropertiesMode has invalid value: " + this.systemPropertiesMode);
        }
        if (this.environmentVariableMode != 0 && this.environmentVariableMode != 1 && this.environmentVariableMode != 2) {
            throw new IllegalArgumentException("Option environmentVariableMode has invalid value: " + this.environmentVariableMode);
        }
        if (this.propertiesParser instanceof DefaultPropertiesParser) {
            ((DefaultPropertiesParser)this.propertiesParser).setPropertiesComponent(this);
        }
        if (this.isAutoDiscoverPropertiesSources()) {
            try {
                for (PropertiesSource source : this.getCamelContext().getRegistry().findByType(PropertiesSource.class)) {
                    this.addPropertiesSource(source);
                    LOG.debug("PropertiesComponent added custom PropertiesSource (registry): {}", (Object)source);
                }
                FactoryFinder factoryFinder = this.getCamelContext().getCamelContextExtension().getBootstrapFactoryFinder();
                Class type = factoryFinder.findClass("properties-source-factory").orElse(null);
                if (type != null) {
                    Object obj = this.getCamelContext().getInjector().newInstance(type, false);
                    if (obj instanceof PropertiesSource) {
                        PropertiesSource ps = (PropertiesSource)obj;
                        this.addPropertiesSource(ps);
                        LOG.debug("PropertiesComponent added custom PropertiesSource (factory): {}", (Object)ps);
                    } else if (obj != null) {
                        LOG.warn("PropertiesComponent cannot add custom PropertiesSource as the type is not a {} but: {}", (Object)PropertiesSource.class.getName(), (Object)type.getName());
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("Error discovering and using custom PropertiesSource due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
            }
        }
        this.sources.sort((Comparator<PropertiesSource>)OrderedComparator.get());
        ServiceHelper.initService((Object[])new Object[]{this.sources, this.propertiesFunctionResolver});
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object[])new Object[]{this.sources, this.propertiesFunctionResolver});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.sources, this.propertiesFunctionResolver});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.sources, this.propertiesFunctionResolver});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.sources, this.propertiesFunctionResolver});
    }

    private void addPropertiesLocationsAsPropertiesSource(PropertiesLocation location) {
        if ("ref".equals(location.getResolver())) {
            this.addPropertiesSource(new RefPropertiesSource(this, location));
        } else if ("file".equals(location.getResolver())) {
            this.addPropertiesSource(new FilePropertiesSource(this, location));
        } else if ("classpath".equals(location.getResolver())) {
            this.addPropertiesSource(new ClasspathPropertiesSource(this, location));
        }
    }

    private List<PropertiesLocation> parseLocations(List<PropertiesLocation> locations) {
        ArrayList<PropertiesLocation> answer = new ArrayList<PropertiesLocation>();
        for (PropertiesLocation propertiesLocation : locations) {
            LOG.trace("Parsing location: {}", (Object)propertiesLocation);
            try {
                String path = FilePathResolver.resolvePath((String)propertiesLocation.getPath());
                LOG.debug("Parsed location: {}", (Object)path);
                if (!ObjectHelper.isNotEmpty((String)path)) continue;
                answer.add(new PropertiesLocation(propertiesLocation.getResolver(), path, propertiesLocation.isOptional()));
            }
            catch (IllegalArgumentException e) {
                if (!this.ignoreMissingLocation && !propertiesLocation.isOptional()) {
                    throw e;
                }
                LOG.debug("Ignored missing location: {}", (Object)propertiesLocation);
            }
        }
        return answer;
    }

    private static String unescape(String input) {
        int index = input.indexOf(92);
        if (index == -1) {
            return input;
        }
        int length = input.length();
        StringBuilder result = new StringBuilder(length);
        int start = 0;
        do {
            result.append(input, start, index);
            start = index + 1;
            if (index + 2 >= length) break;
            char next = input.charAt(index + 1);
            char afterNext = input.charAt(index + 2);
            if (next == '{' && afterNext == '{' || next == '}' && afterNext == '}') continue;
            result.append('\\');
        } while ((index = input.indexOf(92, start)) != -1);
        if (start < length) {
            result.append(input, start, length);
        }
        return result.toString();
    }
}

