/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.babel;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.babel.TableCollectionType;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlBabelCreateTable
extends SqlCreateTable {
    private final TableCollectionType tableCollectionType;
    private final boolean volatile_;

    public SqlBabelCreateTable(SqlParserPos pos, boolean replace, TableCollectionType tableCollectionType, boolean volatile_, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(pos, replace, ifNotExists, name, columnList, query);
        this.tableCollectionType = tableCollectionType;
        this.volatile_ = volatile_;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        switch (this.tableCollectionType) {
            case SET: {
                writer.keyword("SET");
                break;
            }
            case MULTISET: {
                writer.keyword("MULTISET");
                break;
            }
        }
        if (this.volatile_) {
            writer.keyword("VOLATILE");
        }
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.query != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
    }
}

