/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.joinlibrary;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class Join {
    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> innerJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection) {
        return Join.innerJoin("InnerJoin", leftCollection, rightCollection);
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> innerJoin(String name, PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection) {
        return (PCollection)leftCollection.apply(name, InnerJoin.with(rightCollection));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> leftOuterJoin(String name, PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V2 nullValue) {
        return (PCollection)leftCollection.apply(name, LeftOuterJoin.with(rightCollection, nullValue));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> leftOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V2 nullValue) {
        return Join.leftOuterJoin("LeftOuterJoin", leftCollection, rightCollection, nullValue);
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> rightOuterJoin(String name, PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V1 nullValue) {
        return (PCollection)leftCollection.apply(name, RightOuterJoin.with(rightCollection, nullValue));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> rightOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V1 nullValue) {
        return Join.rightOuterJoin("RightOuterJoin", leftCollection, rightCollection, nullValue);
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> fullOuterJoin(String name, PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V1 leftNullValue, V2 rightNullValue) {
        return (PCollection)leftCollection.apply(name, FullOuterJoin.with(rightCollection, leftNullValue, rightNullValue));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> fullOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, V1 leftNullValue, V2 rightNullValue) {
        return Join.fullOuterJoin("FullOuterJoin", leftCollection, rightCollection, leftNullValue, rightNullValue);
    }

    public static class FullOuterJoin<K, V1, V2>
    extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, KV<V1, V2>>>> {
        private transient PCollection<KV<K, V2>> rightCollection;
        private V1 leftNullValue;
        private V2 rightNullValue;

        private FullOuterJoin(PCollection<KV<K, V2>> rightCollection, V1 leftNullValue, V2 rightNullValue) {
            this.rightCollection = rightCollection;
            this.leftNullValue = leftNullValue;
            this.rightNullValue = rightNullValue;
        }

        public static <K, V1, V2> FullOuterJoin<K, V1, V2> with(PCollection<KV<K, V2>> rightCollection, V1 leftNullValue, V2 rightNullValue) {
            return new FullOuterJoin<K, V1, V2>(rightCollection, leftNullValue, rightNullValue);
        }

        public PCollection<KV<K, KV<V1, V2>>> expand(PCollection<KV<K, V1>> leftCollection) {
            Preconditions.checkNotNull(leftCollection);
            Preconditions.checkNotNull(this.rightCollection);
            Preconditions.checkNotNull(this.leftNullValue);
            Preconditions.checkNotNull(this.rightNullValue);
            final TupleTag v1Tuple = new TupleTag();
            final TupleTag v2Tuple = new TupleTag();
            PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, this.rightCollection).apply("CoGBK", (PTransform)CoGroupByKey.create());
            return ((PCollection)coGbkResultCollection.apply("Join", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    block5: {
                        Iterable rightValuesIterable;
                        Iterable leftValuesIterable;
                        KV e;
                        block6: {
                            block4: {
                                e = (KV)c.element();
                                leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                                rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                                if (!leftValuesIterable.iterator().hasNext() || !rightValuesIterable.iterator().hasNext()) break block4;
                                for (Object rightValue : rightValuesIterable) {
                                    for (Object leftValue : leftValuesIterable) {
                                        c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                                    }
                                }
                                break block5;
                            }
                            if (!leftValuesIterable.iterator().hasNext() || rightValuesIterable.iterator().hasNext()) break block6;
                            for (Object leftValue : leftValuesIterable) {
                                c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, (Object)rightNullValue)));
                            }
                            break block5;
                        }
                        if (leftValuesIterable.iterator().hasNext() || !rightValuesIterable.iterator().hasNext()) break block5;
                        for (Object rightValue : rightValuesIterable) {
                            c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of((Object)leftNullValue, rightValue)));
                        }
                    }
                }
            }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)this.rightCollection.getCoder()).getValueCoder())));
        }
    }

    public static class RightOuterJoin<K, V1, V2>
    extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, KV<V1, V2>>>> {
        private transient PCollection<KV<K, V2>> rightCollection;
        private V1 nullValue;

        private RightOuterJoin(PCollection<KV<K, V2>> rightCollection, V1 nullValue) {
            this.rightCollection = rightCollection;
            this.nullValue = nullValue;
        }

        public static <K, V1, V2> RightOuterJoin<K, V1, V2> with(PCollection<KV<K, V2>> rightCollection, V1 nullValue) {
            return new RightOuterJoin<K, V1, V2>(rightCollection, nullValue);
        }

        public PCollection<KV<K, KV<V1, V2>>> expand(PCollection<KV<K, V1>> leftCollection) {
            Preconditions.checkNotNull(leftCollection);
            Preconditions.checkNotNull(this.rightCollection);
            Preconditions.checkNotNull(this.nullValue);
            final TupleTag v1Tuple = new TupleTag();
            final TupleTag v2Tuple = new TupleTag();
            PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, this.rightCollection).apply("CoGBK", (PTransform)CoGroupByKey.create());
            return ((PCollection)coGbkResultCollection.apply("Join", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV e = (KV)c.element();
                    Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                    Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                    for (Object rightValue : rightValuesIterable) {
                        if (leftValuesIterable.iterator().hasNext()) {
                            for (Object leftValue : leftValuesIterable) {
                                c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                            }
                            continue;
                        }
                        c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of((Object)nullValue, rightValue)));
                    }
                }
            }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)this.rightCollection.getCoder()).getValueCoder())));
        }
    }

    public static class LeftOuterJoin<K, V1, V2>
    extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, KV<V1, V2>>>> {
        private transient PCollection<KV<K, V2>> rightCollection;
        private V2 nullValue;

        private LeftOuterJoin(PCollection<KV<K, V2>> rightCollection, V2 nullValue) {
            this.rightCollection = rightCollection;
            this.nullValue = nullValue;
        }

        public static <K, V1, V2> LeftOuterJoin<K, V1, V2> with(PCollection<KV<K, V2>> rightCollection, V2 nullValue) {
            return new LeftOuterJoin<K, V1, V2>(rightCollection, nullValue);
        }

        public PCollection<KV<K, KV<V1, V2>>> expand(PCollection<KV<K, V1>> leftCollection) {
            Preconditions.checkNotNull(leftCollection);
            Preconditions.checkNotNull(this.rightCollection);
            Preconditions.checkNotNull(this.nullValue);
            final TupleTag v1Tuple = new TupleTag();
            final TupleTag v2Tuple = new TupleTag();
            PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, this.rightCollection).apply("CoGBK", (PTransform)CoGroupByKey.create());
            return ((PCollection)coGbkResultCollection.apply("Join", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV e = (KV)c.element();
                    Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                    Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                    for (Object leftValue : leftValuesIterable) {
                        if (rightValuesIterable.iterator().hasNext()) {
                            for (Object rightValue : rightValuesIterable) {
                                c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                            }
                            continue;
                        }
                        c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, (Object)nullValue)));
                    }
                }
            }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)this.rightCollection.getCoder()).getValueCoder())));
        }
    }

    public static class InnerJoin<K, V1, V2>
    extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, KV<V1, V2>>>> {
        private transient PCollection<KV<K, V2>> rightCollection;

        private InnerJoin(PCollection<KV<K, V2>> rightCollection) {
            this.rightCollection = rightCollection;
        }

        public static <K, V1, V2> InnerJoin<K, V1, V2> with(PCollection<KV<K, V2>> rightCollection) {
            return new InnerJoin<K, V1, V2>(rightCollection);
        }

        public PCollection<KV<K, KV<V1, V2>>> expand(PCollection<KV<K, V1>> leftCollection) {
            Preconditions.checkNotNull(leftCollection);
            Preconditions.checkNotNull(this.rightCollection);
            final TupleTag v1Tuple = new TupleTag();
            final TupleTag v2Tuple = new TupleTag();
            PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, this.rightCollection).apply("CoGBK", (PTransform)CoGroupByKey.create());
            return ((PCollection)coGbkResultCollection.apply("Join", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV e = (KV)c.element();
                    Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                    Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                    for (Object leftValue : leftValuesIterable) {
                        for (Object rightValue : rightValuesIterable) {
                            c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                        }
                    }
                }
            }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)this.rightCollection.getCoder()).getValueCoder())));
        }
    }
}

