/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.ComplexPart;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class MultipartFormDataFormatter
implements MessageFormatter {
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
        Part[] parts = this.createMultipatFormDataRequest(omElement);
        if (parts.length > 0) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            try {
                Part.sendParts((OutputStream)bytesOut, (Part[])parts, (byte[])format.getMimeBoundary().getBytes());
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
            return bytesOut.toByteArray();
        }
        return new byte[0];
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        try {
            byte[] b = this.getBytes(messageContext, format);
            if (b != null && b.length > 0) {
                outputStream.write(b);
            } else {
                outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new AxisFault("An error occured while writing the request");
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String contentType = "multipart/form-data";
        String encoding = format.getCharSetEncoding();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        contentType = contentType + "; " + "boundary=" + format.getMimeBoundary();
        return contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    private Part[] createMultipatFormDataRequest(OMElement dataOut) {
        ArrayList<ComplexPart> parts = new ArrayList<ComplexPart>();
        if (dataOut != null) {
            Iterator iter1 = dataOut.getChildElements();
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            while (iter1.hasNext()) {
                OMElement ele = (OMElement)iter1.next();
                Iterator iter2 = ele.getChildElements();
                if (iter2.hasNext()) {
                    OMElement omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
                    omElement.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory));
                    parts.add(new ComplexPart(ele.getQName().getLocalPart(), omElement.toString()));
                    continue;
                }
                parts.add((ComplexPart)new StringPart(ele.getQName().getLocalPart(), ele.getText()));
            }
        }
        Part[] partsArray = new Part[parts.size()];
        return parts.toArray(partsArray);
    }

    private OMElement processComplexType(OMElement parent, Iterator iter, OMFactory omFactory) {
        OMElement omElement = null;
        while (iter.hasNext()) {
            OMElement ele = (OMElement)iter.next();
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            Iterator iter2 = ele.getChildElements();
            if (iter2.hasNext()) {
                parent.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory));
                continue;
            }
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            omElement.setText(ele.getText());
            parent.addChild((OMNode)omElement);
        }
        return omElement;
    }
}

