/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResourceFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestResourceFileUtils.class);

    public static String getTestFilePath(String fileName) {
        String userDir = System.getProperty("user.dir");
        String filePath = TestResourceFileUtils.getTestFilePath(userDir, "", fileName);
        return filePath;
    }

    public static FileInputStream getFileInputStream(String fileName) {
        return TestResourceFileUtils.getFileInputStream("", fileName);
    }

    public static FileInputStream getFileInputStream(String subDir, String fileName) {
        String userDir = System.getProperty("user.dir");
        String filePath = TestResourceFileUtils.getTestFilePath(userDir, subDir, fileName);
        File f = new File(filePath);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            LOG.error("File could not be found at: {}", (Object)filePath, (Object)e);
        }
        return fs;
    }

    public static String getDirectory(String subDir) {
        String userDir = System.getProperty("user.dir");
        return TestResourceFileUtils.getTestFilePath(userDir, subDir, "");
    }

    public static <T> T readObjectFromJson(String subDir, String filename, Class<T> objectClass) throws IOException {
        String userDir = System.getProperty("user.dir");
        String filePath = TestResourceFileUtils.getTestJsonPath(userDir, subDir, filename);
        String json = FileUtils.readFileToString((File)new File(filePath));
        return (T)AtlasType.fromJson((String)json, objectClass);
    }

    public static <T> T readObjectFromJson(String filename, Class<T> objectClass) throws IOException {
        return TestResourceFileUtils.readObjectFromJson("", filename, objectClass);
    }

    public static String getJson(String subDir, String filename) throws IOException {
        String userDir = System.getProperty("user.dir");
        String filePath = TestResourceFileUtils.getTestJsonPath(userDir, subDir, filename);
        return FileUtils.readFileToString((File)new File(filePath));
    }

    public static String getJson(String filename) throws IOException {
        return TestResourceFileUtils.getJson("", filename);
    }

    private static String getTestFilePath(String startPath, String subDir, String fileName) {
        if (StringUtils.isNotEmpty((String)subDir)) {
            return startPath + "/src/test/resources/" + subDir + "/" + fileName;
        }
        return startPath + "/src/test/resources/" + fileName;
    }

    private static String getTestJsonPath(String startPath, String subDir, String fileName) {
        return startPath + "/src/test/resources/json/" + subDir + "/" + fileName + ".json";
    }
}

