/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStreamForImport;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;

public class TestLoadModelUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TestLoadModelUtils.class);

    public static List<String> getAllModels(String dirName) throws IOException {
        ArrayList<String> ret = null;
        File topModelsDir = new File(System.getProperty("user.dir") + "/../addons/models");
        Object[] topModelsDirContents = topModelsDir.exists() ? topModelsDir.listFiles() : null;
        Assert.assertTrue((topModelsDirContents != null ? 1 : 0) != 0, (String)(topModelsDir.getAbsolutePath() + ": unable to find/read directory"));
        if (topModelsDirContents != null) {
            Arrays.sort(topModelsDirContents);
            for (Object modelDir : topModelsDirContents) {
                if (((File)modelDir).exists() && ((File)modelDir).isDirectory() && ((File)modelDir).getAbsolutePath().contains(dirName)) {
                    Object[] models = ((File)modelDir).listFiles();
                    Arrays.sort(models);
                    ret = new ArrayList<String>();
                    for (File model : (File[])Objects.requireNonNull(models)) {
                        ret.add(TestLoadModelUtils.getFileContents((File)modelDir, model.getName()));
                    }
                }
                if (ret == null || ret.size() <= 0) {
                    continue;
                }
                break;
            }
        } else {
            throw new IOException("Unable to retrieve model contents.");
        }
        return ret;
    }

    public static String getModelJson(String fileName) throws IOException {
        String ret = null;
        File topModelsDir = new File(System.getProperty("user.dir") + "/../addons/models");
        Object[] topModelsDirContents = topModelsDir.exists() ? topModelsDir.listFiles() : null;
        Assert.assertTrue((topModelsDirContents != null ? 1 : 0) != 0, (String)(topModelsDir.getAbsolutePath() + ": unable to find/read directory"));
        if (topModelsDirContents != null) {
            Object modelDir;
            Arrays.sort(topModelsDirContents);
            Object[] objectArray = topModelsDirContents;
            int n = objectArray.length;
            for (int i = 0; !(i >= n || ((File)(modelDir = objectArray[i])).exists() && ((File)modelDir).isDirectory() && (ret = TestLoadModelUtils.getFileContents((File)modelDir, fileName)) != null); ++i) {
            }
            if (ret == null) {
                ret = TestLoadModelUtils.getFileContents(topModelsDir, fileName);
            }
        } else {
            throw new IOException("Unable to retrieve model contents.");
        }
        Assert.assertTrue((ret != null ? 1 : 0) != 0, (String)(fileName + ": unable to find model file"));
        return ret;
    }

    public static String getFileContents(File dir, String fileName) throws IOException {
        File file;
        if (dir.exists() && dir.isDirectory() && (file = new File(dir, fileName)).exists() && file.isFile()) {
            return FileUtils.readFileToString((File)file);
        }
        return null;
    }

    public static String getModelJsonFromResources(String fileName) throws IOException {
        String filePath = TestResourceFileUtils.getTestFilePath(fileName);
        File f = new File(filePath);
        String s = FileUtils.readFileToString((File)f);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)s), (String)"Model file read correctly from resources!");
        return s;
    }

    public static AtlasTypesDef loadTypes(String entitiesSubDir, String fileName) {
        try {
            return TestResourceFileUtils.readObjectFromJson(entitiesSubDir, fileName, AtlasTypesDef.class);
        }
        catch (IOException e) {
            throw new SkipException(String.format("loadTypes: '%s' could not be loaded.", fileName));
        }
    }

    public static AtlasEntity.AtlasEntityWithExtInfo loadEntity(String entitiesSubDir, String fileName) {
        try {
            return TestResourceFileUtils.readObjectFromJson(entitiesSubDir, fileName, AtlasEntity.AtlasEntityWithExtInfo.class);
        }
        catch (IOException e) {
            throw new SkipException(String.format("loadEntity: '%s' could not be loaded.", fileName));
        }
    }

    public static void createTypes(AtlasTypeDefStore typeDefStore, String entitiesSubDir, String typesDef) {
        try {
            typeDefStore.createTypesDef(TestLoadModelUtils.loadTypes(entitiesSubDir, typesDef));
        }
        catch (AtlasBaseException e) {
            throw new SkipException("setup: could not load typesDef.");
        }
    }

    public static void createAtlasEntity(AtlasEntityStoreV2 entityStoreV1, AtlasEntity.AtlasEntityWithExtInfo atlasEntity) {
        try {
            EntityMutationResponse response = entityStoreV1.createOrUpdateForImport((EntityStream)new AtlasEntityStreamForImport(atlasEntity, null));
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.getCreatedEntities() != null && response.getCreatedEntities().size() > 0 || response.getMutatedEntities() != null && response.getMutatedEntities().size() > 0 ? 1 : 0) != 0);
        }
        catch (AtlasBaseException e) {
            throw new SkipException(String.format("createAtlasEntity: could not loaded '%s'.", atlasEntity.getEntity().getTypeName()));
        }
    }

    public static void loadModelFromJson(String fileName, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        AtlasTypesDef typesFromJson = TestLoadModelUtils.getAtlasTypesDefFromFile(fileName);
        TestLoadModelUtils.addReplicationAttributes(typesFromJson);
        TestLoadModelUtils.createTypesAsNeeded(typesFromJson, typeDefStore, typeRegistry);
    }

    public static void loadAllModels(String dirName, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        List<String> allModels = TestLoadModelUtils.getAllModels(dirName);
        for (String model : allModels) {
            AtlasTypesDef typesFromJson = (AtlasTypesDef)AtlasJson.fromJson((String)model, AtlasTypesDef.class);
            TestLoadModelUtils.createTypesAsNeeded(typesFromJson, typeDefStore, typeRegistry);
        }
    }

    private static void addReplicationAttributes(AtlasTypesDef typesFromJson) throws IOException {
        if (typesFromJson.getEntityDefs() == null || typesFromJson.getEntityDefs().size() == 0) {
            return;
        }
        AtlasEntityDef ed = (AtlasEntityDef)typesFromJson.getEntityDefs().get(0);
        if (!ed.getName().equals("Referenceable")) {
            return;
        }
        String replAttr1Json = TestResourceFileUtils.getJson("stocksDB-Entities", "replicationAttrs");
        String replAttr2Json = StringUtils.replace((String)replAttr1Json, (String)"From", (String)"To");
        ed.addAttribute((AtlasStructDef.AtlasAttributeDef)AtlasType.fromJson((String)replAttr1Json, AtlasStructDef.AtlasAttributeDef.class));
        ed.addAttribute((AtlasStructDef.AtlasAttributeDef)AtlasType.fromJson((String)replAttr2Json, AtlasStructDef.AtlasAttributeDef.class));
    }

    public static void loadModelFromResourcesJson(String fileName, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        AtlasTypesDef typesFromJson = TestLoadModelUtils.getAtlasTypesDefFromResourceFile(fileName);
        TestLoadModelUtils.createTypesAsNeeded(typesFromJson, typeDefStore, typeRegistry);
    }

    public static void createTypesAsNeeded(AtlasTypesDef typesFromJson, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        if (typesFromJson == null) {
            return;
        }
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)typesFromJson, (AtlasTypeRegistry)typeRegistry);
        if (typesToCreate != null && !typesToCreate.isEmpty()) {
            typeDefStore.createTypesDef(typesToCreate);
        }
    }

    private static AtlasTypesDef getAtlasTypesDefFromFile(String fileName) throws IOException {
        String sampleTypes = TestLoadModelUtils.getModelJson(fileName);
        if (sampleTypes == null) {
            return null;
        }
        return (AtlasTypesDef)AtlasType.fromJson((String)sampleTypes, AtlasTypesDef.class);
    }

    private static AtlasTypesDef getAtlasTypesDefFromResourceFile(String fileName) throws IOException {
        String sampleTypes = TestLoadModelUtils.getModelJsonFromResources(fileName);
        return (AtlasTypesDef)AtlasType.fromJson((String)sampleTypes, AtlasTypesDef.class);
    }

    public static void loadBaseModel(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0010-base_model.json", typeDefStore, typeRegistry);
    }

    public static void loadFsModel(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("1020-fs_model.json", typeDefStore, typeRegistry);
    }

    public static void loadHiveModel(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("1030-hive_model.json", typeDefStore, typeRegistry);
    }
}

