/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.services;

import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.services.MetricsService;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasMetricsCounter;
import org.apache.atlas.util.AtlasMetricsUtil;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class MetricsServiceTest
extends AtlasTestBase {
    public static final String IMPORT_FILE = "metrics-entities-data.zip";
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private ImportService importService;
    @Inject
    private MetricsService metricsService;
    @Inject
    private AtlasMetricsUtil metricsUtil;
    TestClock clock = new TestClock(Clock.systemUTC(), ZoneOffset.UTC);
    long msgOffset = 0L;
    private final Map<String, Long> activeEntityMetricsExpected = new HashMap<String, Long>(){
        {
            this.put("hive_storagedesc", 5L);
            this.put("AtlasServer", 1L);
            this.put("hive_column_lineage", 8L);
            this.put("hive_table", 5L);
            this.put("hive_column", 13L);
            this.put("hive_db", 2L);
            this.put("hive_process", 3L);
        }
    };
    private final Map<String, Long> deletedEntityMetricsExpected = new HashMap<String, Long>(){
        {
            this.put("hive_storagedesc", 1L);
            this.put("hive_table", 1L);
            this.put("hive_column", 2L);
            this.put("hive_db", 1L);
        }
    };
    private final Map<String, Long> tagMetricsExpected = new HashMap<String, Long>(){
        {
            this.put("PII", 1L);
        }
    };
    private final Map<String, Object> metricExpected = new HashMap<String, Object>(){
        {
            this.put("Notification:currentHour", 11L);
            this.put("Notification:currentHourFailed", 1L);
            this.put("Notification:previousHour", 11L);
            this.put("Notification:previousHourFailed", 1L);
            this.put("Notification:currentDay", 33L);
            this.put("Notification:currentDayFailed", 3L);
            this.put("Notification:previousDay", 11L);
            this.put("Notification:previousDayFailed", 1L);
        }
    };

    @BeforeClass
    public void setup() throws Exception {
        RequestContext.clear();
        super.initialize();
        this.loadModelFilesAndImportTestData();
        this.sleep();
    }

    private void sleep() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void testGetMetrics() {
        AtlasMetrics metrics = this.metricsService.getMetrics();
        Assert.assertNotNull((Object)metrics);
        Assert.assertEquals((int)metrics.getNumericMetric("general", "entityCount").intValue(), (int)42);
        Assert.assertEquals((int)metrics.getNumericMetric("general", "tagCount").intValue(), (int)1);
        Assert.assertTrue((metrics.getNumericMetric("general", "typeUnusedCount").intValue() >= 10 ? 1 : 0) != 0);
        Assert.assertTrue((metrics.getNumericMetric("general", "typeCount").intValue() >= 44 ? 1 : 0) != 0);
        Map tagMetricsActual = (Map)metrics.getMetric("tag", "tagEntities");
        Map activeEntityMetricsActual = (Map)metrics.getMetric("entity", "entityActive");
        Map deletedEntityMetricsActual = (Map)metrics.getMetric("entity", "entityDeleted");
        Assert.assertEquals((int)tagMetricsActual.size(), (int)1);
        Assert.assertEquals((int)activeEntityMetricsActual.size(), (int)7);
        Assert.assertEquals((int)deletedEntityMetricsActual.size(), (int)4);
        Assert.assertEquals((Map)tagMetricsActual, this.tagMetricsExpected);
        Assert.assertEquals((Map)activeEntityMetricsActual, this.activeEntityMetricsExpected);
        Assert.assertEquals((Map)deletedEntityMetricsActual, this.deletedEntityMetricsExpected);
    }

    @Test
    public void testNotificationMetrics() {
        Instant now = Clock.systemUTC().instant();
        Instant dayStartTime = AtlasMetricsCounter.getDayStartTime((Instant)now);
        Instant dayEndTime = AtlasMetricsCounter.getNextDayStartTime((Instant)now);
        Instant hourStartTime = dayEndTime.minusSeconds(3600L);
        this.prepareNotificationData(dayStartTime, hourStartTime);
        this.clock.setInstant(dayEndTime.minusSeconds(1L));
        Map notificationMetricMap = this.metricsUtil.getStats();
        this.clock.setInstant(null);
        this.verifyNotificationMetric(this.metricExpected, notificationMetricMap);
    }

    private void loadModelFilesAndImportTestData() {
        try {
            TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("0000-Area0/patches/001-base_model_replication_attributes.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1020-fs_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/patches/001-hive_column_add_position.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/patches/002-hive_column_table_add_options.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/patches/003-hive_column_update_table_remove_constraint.json", this.typeDefStore, this.typeRegistry);
            ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, MetricsServiceTest.getZipSource(IMPORT_FILE));
        }
        catch (IOException | AtlasBaseException e) {
            throw new SkipException("Model loading failed!");
        }
    }

    private void prepareNotificationData(Instant dayStartTime, Instant hourStartTime) {
        Instant prevDayStartTime = AtlasMetricsCounter.getDayStartTime((Instant)dayStartTime.minusSeconds(1L));
        this.msgOffset = 0L;
        this.clock.setInstant(prevDayStartTime);
        this.metricsUtil.init((Clock)this.clock);
        this.clock.setInstant(null);
        this.processMessage(prevDayStartTime.plusSeconds(3L));
        this.processMessage(dayStartTime.plusSeconds(3L));
        this.processMessage(hourStartTime.minusSeconds(3L));
        this.processMessage(hourStartTime.plusSeconds(3L));
    }

    private void processMessage(Instant instant) {
        this.clock.setInstant(instant);
        this.metricsUtil.onNotificationProcessingComplete("ATLAS_HOOK", 0, ++this.msgOffset, new AtlasMetricsUtil.NotificationStat(true, 1L));
        for (int i = 0; i < 10; ++i) {
            this.metricsUtil.onNotificationProcessingComplete("ATLAS_HOOK", 0, this.msgOffset++, new AtlasMetricsUtil.NotificationStat(false, 1L));
        }
        this.clock.setInstant(null);
    }

    private void verifyNotificationMetric(Map<String, Object> metricExpected, Map<String, Object> notificationMetrics) {
        Assert.assertNotNull(notificationMetrics);
        Assert.assertNotEquals((Object)notificationMetrics.size(), (Object)0);
        Assert.assertTrue((notificationMetrics.size() >= metricExpected.size() ? 1 : 0) != 0);
        for (Map.Entry<String, Object> entry : metricExpected.entrySet()) {
            Assert.assertEquals((Object)notificationMetrics.get(entry.getKey()), (Object)entry.getValue(), (String)entry.getKey());
        }
    }

    public static InputStream getZipSource(String fileName) throws AtlasBaseException {
        return ZipFileResourceTestUtils.getFileInputStream(fileName);
    }

    private static class TestClock
    extends Clock {
        private final Clock baseClock;
        private final ZoneId zone;
        private Instant instant = null;

        public TestClock(Clock baseClock, ZoneId zone) {
            this.baseClock = baseClock;
            this.zone = zone;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public TestClock withZone(ZoneId zone) {
            return new TestClock(this.baseClock, zone);
        }

        @Override
        public Instant instant() {
            return this.instant != null ? this.instant : this.baseClock.instant();
        }

        public void setInstant(Instant instant) {
            this.instant = instant;
        }
    }
}

