/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.tagpropagation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.exception.EntityNotFoundException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ClassificationPropagationWithTasksTest
extends AtlasTestBase {
    private static final String IMPORT_FILE = "tag-propagation-data.zip";
    private static final String HDFS_PATH_EMPLOYEES = "a3955120-ac17-426f-a4af-972ec8690e5f";
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasEntityStore entityStore;
    @Inject
    private ImportService importService;
    @Inject
    private EntityGraphMapper entityGraphMapper;
    @Inject
    private TaskManagement tasksManagement;

    @BeforeClass
    public void setup() throws Exception {
        RequestContext.clear();
        super.initialize();
        this.tasksManagement.start();
        this.entityGraphMapper.setTasksUseFlag(true);
        this.loadModelFilesAndImportTestData();
    }

    private void loadModelFilesAndImportTestData() {
        try {
            TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1020-fs_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
            this.loadSampleClassificationDefs();
            ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, ClassificationPropagationWithTasksTest.getZipSource(IMPORT_FILE));
        }
        catch (IOException | AtlasBaseException e) {
            throw new SkipException("Model loading failed!");
        }
    }

    private void loadSampleClassificationDefs() throws AtlasBaseException {
        AtlasClassificationDef tagX = new AtlasClassificationDef("tagX");
        AtlasClassificationDef tagY = new AtlasClassificationDef("tagY");
        this.typeDefStore.createTypesDef(new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Arrays.asList(tagX, tagY), Collections.emptyList(), Collections.emptyList()));
    }

    public static InputStream getZipSource(String fileName) throws IOException {
        return ZipFileResourceTestUtils.getFileInputStream(fileName);
    }

    @Test
    public void parameterValidation() throws AtlasBaseException {
        try {
            this.entityGraphMapper.propagateClassification(null, null, null);
            this.entityGraphMapper.propagateClassification("unknown", "abcd", "xyz");
        }
        catch (AtlasBaseException e) {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)(e.getCause() instanceof EntityNotFoundException));
        }
        List ret = this.entityGraphMapper.propagateClassification(HDFS_PATH_EMPLOYEES, "", "");
        Assert.assertNull((Object)ret);
        ret = this.entityGraphMapper.deleteClassificationPropagation("", "");
        Assert.assertNull((Object)ret);
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        ret = this.entityGraphMapper.propagateClassification(hdfs_employees.getGuid(), "", "");
        Assert.assertNull((Object)ret);
    }

    @Test
    public void add() throws AtlasBaseException {
        String TAG_NAME_X = "tagX";
        String TAG_NAME_Y = "tagY";
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tagX = new AtlasClassification("tagX");
        tagX.setEntityGuid(hdfs_employees.getGuid());
        tagX.setPropagate(Boolean.valueOf(true));
        AtlasClassification tagY = new AtlasClassification("tagY");
        tagY.setEntityGuid(hdfs_employees.getGuid());
        tagY.setPropagate(Boolean.valueOf(false));
        this.entityStore.addClassification(Collections.singletonList(HDFS_PATH_EMPLOYEES), tagX);
        this.entityStore.addClassification(Collections.singletonList(HDFS_PATH_EMPLOYEES), tagY);
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid((String)hdfs_employees.getGuid());
        AtlasVertex classificationVertex = GraphHelper.getClassificationVertex((AtlasVertex)entityVertex, (String)"tagX");
        Assert.assertNotNull((Object)entityVertex);
        Assert.assertNotNull((Object)classificationVertex);
        AtlasEntity entityUpdated = this.getEntity(HDFS_PATH_EMPLOYEES);
        Assert.assertNotNull((Object)entityUpdated.getPendingTasks());
        List impactedEntities = this.entityGraphMapper.propagateClassification(hdfs_employees.getGuid(), classificationVertex.getId().toString(), "");
        Assert.assertNotNull((Object)impactedEntities);
    }

    @Test(dependsOnMethods={"add"})
    public void update() throws AtlasBaseException {
        String TAG_NAME_Y = "tagY";
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tagY = new AtlasClassification("tagY");
        tagY.setEntityGuid(hdfs_employees.getGuid());
        tagY.setPropagate(Boolean.valueOf(true));
        this.entityStore.updateClassifications(hdfs_employees.getGuid(), Collections.singletonList(tagY));
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid((String)hdfs_employees.getGuid());
        AtlasVertex classificationVertex = GraphHelper.getClassificationVertex((AtlasVertex)entityVertex, (String)"tagY");
        Assert.assertNotNull((Object)RequestContext.get().getQueuedTasks());
        Assert.assertTrue((RequestContext.get().getQueuedTasks().size() > 0 ? 1 : 0) != 0, (String)"No tasks were queued!");
        Assert.assertNotNull((Object)entityVertex);
        Assert.assertNotNull((Object)classificationVertex);
    }

    @Test(dependsOnMethods={"update"})
    public void delete() throws AtlasBaseException {
        String TAG_NAME = "tagX";
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        this.entityGraphMapper.propagateClassification(hdfs_employees.getGuid(), "", "");
        AtlasClassification tagX = new AtlasClassification("tagX");
        tagX.setEntityGuid(hdfs_employees.getGuid());
        tagX.setPropagate(Boolean.valueOf(false));
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid((String)hdfs_employees.getGuid());
        AtlasVertex classificationVertex = GraphHelper.getClassificationVertex((AtlasVertex)entityVertex, (String)"tagX");
        this.entityStore.deleteClassification(HDFS_PATH_EMPLOYEES, tagX.getTypeName());
        Assert.assertNotNull((Object)entityVertex);
        Assert.assertNotNull((Object)classificationVertex);
        List impactedEntities = this.entityGraphMapper.deleteClassificationPropagation(hdfs_employees.getGuid(), classificationVertex.getId().toString());
        Assert.assertNotNull((Object)impactedEntities);
    }

    private AtlasEntity getEntity(String entityGuid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(entityGuid);
        return entityWithExtInfo.getEntity();
    }
}

