/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.DeleteType;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public abstract class InverseReferenceUpdateV2Test
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    AtlasTypeDefStore typeDefStore;
    @Inject
    AtlasEntityStore entityStore;
    private AtlasEntity.AtlasEntitiesWithExtInfo deptEntity;
    private final DeleteType deleteType;
    protected Map<String, AtlasObjectId> nameIdMap = new HashMap<String, AtlasObjectId>();

    protected InverseReferenceUpdateV2Test(DeleteType deleteType) {
        this.deleteType = deleteType;
    }

    @BeforeClass
    public void setUp() throws Exception {
        AtlasTypesDef[] testTypesDefs;
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        super.initialize();
        for (AtlasTypesDef typesDef : testTypesDefs = new AtlasTypesDef[]{TestUtilsV2.defineDeptEmployeeTypes(), TestUtilsV2.defineInverseReferenceTestTypes()}) {
            AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)typesDef, (AtlasTypeRegistry)this.typeRegistry);
            if (typesToCreate.isEmpty()) continue;
            this.typeDefStore.createTypesDef(typesToCreate);
        }
        this.deptEntity = TestUtilsV2.createDeptEg2();
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.deptEntity), false);
        for (AtlasEntityHeader entityHeader : response.getCreatedEntities()) {
            this.nameIdMap.put((String)entityHeader.getAttribute("name"), AtlasTypeUtil.getAtlasObjectId((AtlasEntityHeader)entityHeader));
        }
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @BeforeMethod
    public void init() throws Exception {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        RequestContext.get().setDeleteType(this.deleteType);
    }

    @Test
    public void testInverseReferenceAutoUpdate_NonComposite_OneToMany() throws Exception {
        AtlasObjectId juliusId = this.nameIdMap.get("Julius");
        AtlasEntity maxEntityForUpdate = new AtlasEntity("Employee");
        maxEntityForUpdate.setAttribute("manager", (Object)juliusId);
        AtlasEntityType employeeType = this.typeRegistry.getEntityTypeByName("Employee");
        Map<String, String> uniqAttributes = Collections.singletonMap("name", "Max");
        EntityMutationResponse updateResponse = this.entityStore.updateByUniqueAttributes(employeeType, uniqAttributes, new AtlasEntity.AtlasEntityWithExtInfo(maxEntityForUpdate));
        List partialUpdatedEntities = updateResponse.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        AtlasObjectId maxId = this.nameIdMap.get("Max");
        String janeGuid = this.nameIdMap.get("Jane").getGuid();
        AtlasEntity.AtlasEntitiesWithExtInfo storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)maxId.getGuid(), (Object)juliusId.getGuid(), (Object)janeGuid));
        AtlasEntity storedEntity = storedEntities.getEntity(maxId.getGuid());
        this.verifyReferenceValue(storedEntity, "manager", juliusId.getGuid());
        storedEntity = storedEntities.getEntity(juliusId.getGuid());
        this.verifyReferenceList(storedEntity, "subordinates", (List<AtlasObjectId>)ImmutableList.of((Object)maxId));
        storedEntity = storedEntities.getEntity(janeGuid);
        this.verify_testInverseReferenceAutoUpdate_NonComposite_OneToMany(storedEntity);
    }

    protected abstract void verify_testInverseReferenceAutoUpdate_NonComposite_OneToMany(AtlasEntity var1) throws Exception;

    @Test
    public void testInverseReferenceAutoUpdate_NonCompositeManyToOne() throws Exception {
        AtlasEntityType bType = this.typeRegistry.getEntityTypeByName("B");
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity a3 = new AtlasEntity("A");
        a3.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b = new AtlasEntity("B");
        b.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        atlasEntitiesWithExtInfo.addEntity(a1);
        atlasEntitiesWithExtInfo.addEntity(a2);
        atlasEntitiesWithExtInfo.addEntity(a3);
        atlasEntitiesWithExtInfo.addEntity(b);
        AtlasEntityStream entityStream = new AtlasEntityStream(atlasEntitiesWithExtInfo);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        AtlasEntity bForPartialUpdate = new AtlasEntity("B");
        bForPartialUpdate.setAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bForPartialUpdate));
        List partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b.getGuid()));
        AtlasEntity storedEntity = storedEntities.getEntity(a1.getGuid());
        this.verifyReferenceValue(storedEntity, "oneB", b.getGuid());
        storedEntity = storedEntities.getEntity(a2.getGuid());
        this.verifyReferenceValue(storedEntity, "oneB", b.getGuid());
        storedEntity = storedEntities.getEntity(b.getGuid());
        this.verifyReferenceList(storedEntity, "manyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        bForPartialUpdate.setAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bForPartialUpdate));
        partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)4);
        this.init();
        storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)a3.getGuid(), (Object)b.getGuid()));
        this.verifyReferenceValue(storedEntities.getEntity(a3.getGuid()), "oneB", b.getGuid());
        this.verify_testInverseReferenceAutoUpdate_NonCompositeManyToOne(storedEntities.getEntity(a1.getGuid()), storedEntities.getEntity(a2.getGuid()), storedEntities.getEntity(a3.getGuid()), storedEntities.getEntity(b.getGuid()));
    }

    protected abstract void verify_testInverseReferenceAutoUpdate_NonCompositeManyToOne(AtlasEntity var1, AtlasEntity var2, AtlasEntity var3, AtlasEntity var4);

    @Test
    public void testInverseReferenceAutoUpdate_NonComposite_OneToOne() throws Exception {
        AtlasEntityType bType = this.typeRegistry.getEntityTypeByName("B");
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b = new AtlasEntity("B");
        b.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        atlasEntitiesWithExtInfo.addEntity(a1);
        atlasEntitiesWithExtInfo.addEntity(a2);
        atlasEntitiesWithExtInfo.addEntity(b);
        AtlasEntityStream entityStream = new AtlasEntityStream(atlasEntitiesWithExtInfo);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        AtlasEntity bForPartialUpdate = new AtlasEntity("B");
        bForPartialUpdate.setAttribute("a", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bForPartialUpdate));
        List partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)2);
        AtlasEntity.AtlasEntitiesWithExtInfo storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)b.getGuid()));
        AtlasEntity storedEntity = storedEntities.getEntity(a1.getGuid());
        this.verifyReferenceValue(storedEntity, "b", b.getGuid());
        storedEntity = storedEntities.getEntity(b.getGuid());
        this.verifyReferenceValue(storedEntity, "a", a1.getGuid());
        bForPartialUpdate.setAttribute("a", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bForPartialUpdate));
        partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b.getGuid()));
        storedEntity = storedEntities.getEntity(a2.getGuid());
        this.verifyReferenceValue(storedEntity, "b", b.getGuid());
        storedEntity = storedEntities.getEntity(b.getGuid());
        this.verifyReferenceValue(storedEntity, "a", a2.getGuid());
        storedEntity = storedEntities.getEntity(a1.getGuid());
        Object refValue = storedEntity.getAttribute("b");
        this.verify_testInverseReferenceAutoUpdate_NonComposite_OneToOne(storedEntities.getEntity(a1.getGuid()), storedEntities.getEntity(b.getGuid()));
    }

    protected abstract void verify_testInverseReferenceAutoUpdate_NonComposite_OneToOne(AtlasEntity var1, AtlasEntity var2);

    @Test
    public void testInverseReferenceAutoUpdate_NonComposite_ManyToMany() throws Exception {
        AtlasEntityType bType = this.typeRegistry.getEntityTypeByName("B");
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity a3 = new AtlasEntity("A");
        a3.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b1 = new AtlasEntity("B");
        b1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b2 = new AtlasEntity("B");
        b2.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        atlasEntitiesWithExtInfo.addEntity(a1);
        atlasEntitiesWithExtInfo.addEntity(a2);
        atlasEntitiesWithExtInfo.addEntity(a3);
        atlasEntitiesWithExtInfo.addEntity(b1);
        atlasEntitiesWithExtInfo.addEntity(b2);
        AtlasEntityStream entityStream = new AtlasEntityStream(atlasEntitiesWithExtInfo);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        AtlasEntity b1ForPartialUpdate = new AtlasEntity("B");
        b1ForPartialUpdate.setAttribute("manyToManyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b1.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(b1ForPartialUpdate));
        List partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b1.getGuid()));
        AtlasEntity storedEntity = storedEntities.getEntity(b1.getGuid());
        this.verifyReferenceList(storedEntity, "manyToManyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        storedEntity = storedEntities.getEntity(a1.getGuid());
        this.verifyReferenceList(storedEntity, "manyB", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1)));
        storedEntity = storedEntities.getEntity(a2.getGuid());
        this.verifyReferenceList(storedEntity, "manyB", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1)));
    }

    @Test
    public void testInverseReferenceAutoUpdate_Map() throws Exception {
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b1 = new AtlasEntity("B");
        b1.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b2 = new AtlasEntity("B");
        b2.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity b3 = new AtlasEntity("B");
        b3.setAttribute("name", (Object)TestUtilsV2.randomString());
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        atlasEntitiesWithExtInfo.addEntity(a1);
        atlasEntitiesWithExtInfo.addEntity(b1);
        atlasEntitiesWithExtInfo.addEntity(b2);
        atlasEntitiesWithExtInfo.addEntity(b3);
        AtlasEntityStream entityStream = new AtlasEntityStream(atlasEntitiesWithExtInfo);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        AtlasEntityType aType = this.typeRegistry.getEntityTypeByName("A");
        AtlasEntity aForPartialUpdate = new AtlasEntity("A");
        aForPartialUpdate.setAttribute("mapToB", (Object)ImmutableMap.of((Object)"b1", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1), (Object)"b2", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b2)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(aType, Collections.singletonMap("name", a1.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(aForPartialUpdate));
        List partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)b2.getGuid(), (Object)b1.getGuid()));
        AtlasEntity storedEntity = storedEntities.getEntity(a1.getGuid());
        Object value = storedEntity.getAttribute("mapToB");
        Assert.assertTrue((boolean)(value instanceof Map));
        Map refMap = (Map)value;
        Assert.assertEquals((int)refMap.size(), (int)2);
        AtlasObjectId referencedEntityId = (AtlasObjectId)refMap.get("b1");
        Assert.assertEquals((Object)referencedEntityId, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1));
        referencedEntityId = (AtlasObjectId)refMap.get("b2");
        Assert.assertEquals((Object)referencedEntityId, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b2));
        storedEntity = storedEntities.getEntity(b1.getGuid());
        this.verifyReferenceValue(storedEntity, "mappedFromA", a1.getGuid());
        storedEntity = storedEntities.getEntity(b2.getGuid());
        this.verifyReferenceValue(storedEntity, "mappedFromA", a1.getGuid());
        aForPartialUpdate.setAttribute("mapToB", (Object)ImmutableMap.of((Object)"b3", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b3)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(aType, Collections.singletonMap("name", a1.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(aForPartialUpdate));
        partialUpdatedEntities = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)4);
        storedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)b2.getGuid(), (Object)b1.getGuid(), (Object)b3.getGuid()));
        AtlasEntity storedB3 = storedEntities.getEntity(b3.getGuid());
        this.verifyReferenceValue(storedB3, "mappedFromA", a1.getGuid());
        this.verify_testInverseReferenceAutoUpdate_Map(storedEntities.getEntity(a1.getGuid()), storedEntities.getEntity(b1.getGuid()), storedEntities.getEntity(b2.getGuid()), storedB3);
    }

    protected abstract void verify_testInverseReferenceAutoUpdate_Map(AtlasEntity var1, AtlasEntity var2, AtlasEntity var3, AtlasEntity var4);

    protected void verifyReferenceValue(AtlasEntity entity, String refName, String expectedGuid) {
        Object refValue = entity.getAttribute(refName);
        if (expectedGuid == null) {
            Assert.assertNull((Object)refValue);
        } else {
            Assert.assertTrue((boolean)(refValue instanceof AtlasObjectId));
            AtlasObjectId referencedObjectId = (AtlasObjectId)refValue;
            Assert.assertEquals((String)referencedObjectId.getGuid(), (String)expectedGuid);
        }
    }

    protected void verifyReferenceList(AtlasEntity entity, String refName, List<AtlasObjectId> expectedValues) {
        Object refValue = entity.getAttribute(refName);
        Assert.assertTrue((boolean)(refValue instanceof List));
        List refList = (List)refValue;
        Assert.assertEquals((int)refList.size(), (int)expectedValues.size());
        if (expectedValues.size() > 0) {
            Assert.assertTrue((boolean)refList.containsAll(expectedValues));
        }
    }
}

