/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.EntityCorrelationStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class EntityCorrelationStoreTest
extends BasicTestSetup {
    @Inject
    AtlasGraph graph;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
    }

    @Test
    public void verify() throws IOException, AtlasBaseException {
        String nonExistentQName = "db01@cm";
        String db01QName = "db01x@cm";
        EntityCorrelationStore entityCorrelationStore = new EntityCorrelationStore();
        String db01 = TestResourceFileUtils.getJson("entities", "db01");
        AtlasEntity.AtlasEntitiesWithExtInfo db = (AtlasEntity.AtlasEntitiesWithExtInfo)AtlasType.fromJson((String)db01, AtlasEntity.AtlasEntitiesWithExtInfo.class);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(db), false);
        String dbGuid = response.getFirstEntityCreated().getGuid();
        this.entityStore.deleteById(dbGuid);
        entityCorrelationStore.add(dbGuid, 2L);
        this.graph.commit();
        String guid = entityCorrelationStore.findCorrelatedGuid("db01@cm", 1L);
        Assert.assertNull((Object)guid);
        String fetchedGuid = entityCorrelationStore.findCorrelatedGuid("db01x@cm", 1L);
        Assert.assertNotNull((Object)fetchedGuid);
        Assert.assertEquals((String)fetchedGuid, (String)dbGuid);
        guid = entityCorrelationStore.findCorrelatedGuid("db01x@cm", 2L);
        Assert.assertNull((Object)guid);
    }
}

