/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.io.IOException;
import java.util.Collection;
import org.apache.atlas.AtlasException;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class DifferentialAuditsTest
extends BasicTestSetup {
    private static final Logger LOG = LoggerFactory.getLogger(DifferentialAuditsTest.class);

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
    }

    @Test
    public void t1() throws IOException, AtlasException, AtlasBaseException {
        String db01 = TestResourceFileUtils.getJson("entities", "db01");
        String tbl01 = TestResourceFileUtils.getJson("entities", "tbl01");
        String tbl012Col = TestResourceFileUtils.getJson("entities", "tbl01-2cols");
        AtlasEntity.AtlasEntitiesWithExtInfo db = (AtlasEntity.AtlasEntitiesWithExtInfo)AtlasType.fromJson((String)db01, AtlasEntity.AtlasEntitiesWithExtInfo.class);
        AtlasEntity.AtlasEntitiesWithExtInfo tbl = (AtlasEntity.AtlasEntitiesWithExtInfo)AtlasType.fromJson((String)tbl01, AtlasEntity.AtlasEntitiesWithExtInfo.class);
        AtlasEntity.AtlasEntitiesWithExtInfo tbl2Cols = (AtlasEntity.AtlasEntitiesWithExtInfo)AtlasType.fromJson((String)tbl012Col, AtlasEntity.AtlasEntitiesWithExtInfo.class);
        ((AtlasEntityStoreV2)this.entityStore).setStoreDifferentialAudits(true);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(db), false);
        Assert.assertNotNull((Object)response);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tbl2Cols), false);
        Collection diffEntities = RequestContext.get().getDifferentialEntities();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((int)diffEntities.size(), (int)0);
        RequestContext.get().clearCache();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tbl), false);
        Assert.assertNotNull((Object)response);
        diffEntities = RequestContext.get().getDifferentialEntities();
        Assert.assertEquals((int)diffEntities.size(), (int)1);
        RequestContext.get().clearCache();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tbl), false);
        Assert.assertNotNull((Object)response);
        diffEntities = RequestContext.get().getDifferentialEntities();
        Assert.assertEquals((int)diffEntities.size(), (int)0);
    }
}

