/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.repository.store.graph.v2.BulkImporterImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BulkImportPercentTest {
    private final int MAX_PERCENT = 100;
    private final float MAX_PERCENT_FLOAT = 100.0f;
    private List<Integer> percentHolder;
    private Logger log;

    public void setupPercentHolder(long max) {
        this.percentHolder = new ArrayList<Integer>();
    }

    @BeforeClass
    void mockLog() {
        this.log = (Logger)Mockito.mock(Logger.class);
        ((Logger)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Integer d = (Integer)args[1];
                BulkImportPercentTest.this.percentHolder.add(Integer.valueOf(d));
                return null;
            }
        }).when((Object)this.log)).info(Matchers.anyString(), new Object[]{Matchers.anyInt(), Matchers.anyLong(), Matchers.anyString()});
    }

    @Test
    public void percentTest_Equal4() throws Exception {
        this.runWithSize(4L);
        this.assertEqualsForPercentHolder(25.0, 50.0, 75.0, 100.0);
    }

    @Test
    public void percentTest_Equal10() throws Exception {
        this.runWithSize(10L);
        this.assertEqualsForPercentHolder(10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0);
    }

    private void assertEqualsForPercentHolder(double ... expected) {
        Assert.assertEquals((int)this.percentHolder.size(), (int)expected.length);
        Object[] actual = this.percentHolder.toArray();
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((Double.compare(((Integer)actual[i]).intValue(), expected[i]) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void bulkImportPercentageTestLessThan100() throws Exception {
        int streamSize = 20;
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0, 100.0);
    }

    @Test
    public void percentTest_Equal101() throws Exception {
        int streamSize = 101;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal200() throws Exception {
        int streamSize = 200;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal202() throws Exception {
        int streamSize = 202;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal1001() throws Exception {
        int streamSize = 1001;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal100M() throws Exception {
        long streamSize = 100000000L;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal4323() throws Exception {
        int streamSize = 4323;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void percentTest_Equal269() throws Exception {
        int streamSize = 269;
        double[] expected = this.fillPercentHolderWith100();
        this.runWithSize(streamSize);
        this.assertEqualsForPercentHolder(expected);
    }

    @Test
    public void exceedingInitialStreamSize_KeepsPercentAt100() throws Exception {
        this.runWithSize(4L);
        double[] expected = this.fillPercentHolderWith100();
        float f = BulkImporterImpl.updateImportProgress((Logger)this.log, (long)5L, (long)4L, (float)100.0f, (String)"additional info");
        Assert.assertTrue(((double)(f - 100.0f) <= 1.0E-4 ? 1 : 0) != 0);
    }

    private void runWithSize(long streamSize) throws Exception {
        float currentPercent = 0.0f;
        this.setupPercentHolder(streamSize);
        int currentIndex = 0;
        while ((long)currentIndex < streamSize) {
            currentPercent = this.invokeBulkImportProgress(currentIndex + 1, streamSize, currentPercent);
            ++currentIndex;
        }
    }

    private float invokeBulkImportProgress(int currentIndex, long streamSize, float currentPercent) throws Exception {
        return BulkImporterImpl.updateImportProgress((Logger)this.log, (long)currentIndex, (long)streamSize, (float)currentPercent, (String)"additional info");
    }

    private double[] fillPercentHolderWith100() {
        double start = 1.0;
        double[] expected = new double[100];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = start;
            start += 1.0;
        }
        return expected;
    }

    @Test
    public void jsonArrayTest() {
        String t1 = "123-abcd";
        String t2 = "456-efgh";
        String jsonArray = BulkImporterImpl.getJsonArray(null, (String)t1);
        Assert.assertEquals((String)jsonArray, (String)String.format("[\"%s\"]", t1));
        Assert.assertEquals((String)BulkImporterImpl.getJsonArray((String)jsonArray, (String)t2), (String)String.format("[\"%s\",\"%s\"]", t1, t2));
    }
}

