/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.DeleteType;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestRelationshipUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipStoreV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public abstract class AtlasRelationshipStoreV2Test
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    AtlasTypeDefStore typeDefStore;
    @Inject
    DeleteHandlerDelegate deleteDelegate;
    @Inject
    EntityGraphMapper graphMapper;
    @Inject
    AtlasEntityChangeNotifier entityNotifier;
    @Inject
    AtlasGraph atlasGraph;
    AtlasEntityStore entityStore;
    AtlasRelationshipStore relationshipStore;
    AtlasEntityChangeNotifier mockChangeNotifier = (AtlasEntityChangeNotifier)Mockito.mock(AtlasEntityChangeNotifier.class);
    private final DeleteType deleteType;
    protected Map<String, AtlasObjectId> employeeNameIdMap = new HashMap<String, AtlasObjectId>();

    protected AtlasRelationshipStoreV2Test(DeleteType delteType) {
        this.deleteType = delteType;
    }

    @BeforeClass
    public void setUp() throws Exception {
        super.initialize();
        new GraphBackedSearchIndexer(this.typeRegistry);
        AtlasTypesDef employeeTypes = TestRelationshipUtilsV2.getDepartmentEmployeeTypes();
        this.typeDefStore.createTypesDef(employeeTypes);
        AtlasEntity.AtlasEntitiesWithExtInfo employeeInstances = TestRelationshipUtilsV2.getDepartmentEmployeeInstances();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(employeeInstances), false);
        for (AtlasEntityHeader entityHeader : response.getCreatedEntities()) {
            this.employeeNameIdMap.put((String)entityHeader.getAttribute("name"), AtlasTypeUtil.getAtlasObjectId((AtlasEntityHeader)entityHeader));
        }
        this.init();
        AtlasTypesDef typesDef = TestRelationshipUtilsV2.getInverseReferenceTestTypes();
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)typesDef, (AtlasTypeRegistry)this.typeRegistry);
        if (!typesToCreate.isEmpty()) {
            this.typeDefStore.createTypesDef(typesToCreate);
        }
    }

    @BeforeTest
    public void init() throws Exception {
        this.entityStore = new AtlasEntityStoreV2(this.atlasGraph, this.deleteDelegate, this.typeRegistry, (IAtlasEntityChangeNotifier)this.mockChangeNotifier, this.graphMapper);
        this.relationshipStore = new AtlasRelationshipStoreV2(this.atlasGraph, this.typeRegistry, this.deleteDelegate, (IAtlasEntityChangeNotifier)this.entityNotifier);
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        RequestContext.get().setDeleteType(this.deleteType);
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void testDepartmentEmployeeEntitiesUsingRelationship() throws Exception {
        AtlasObjectId hrId = this.employeeNameIdMap.get("hr");
        AtlasObjectId maxId = this.employeeNameIdMap.get("Max");
        AtlasObjectId johnId = this.employeeNameIdMap.get("John");
        AtlasObjectId juliusId = this.employeeNameIdMap.get("Julius");
        AtlasObjectId janeId = this.employeeNameIdMap.get("Jane");
        AtlasObjectId mikeId = this.employeeNameIdMap.get("Mike");
        AtlasEntity hrDept = this.getEntityFromStore(hrId.getGuid());
        AtlasEntity max = this.getEntityFromStore(maxId.getGuid());
        AtlasEntity john = this.getEntityFromStore(johnId.getGuid());
        AtlasEntity julius = this.getEntityFromStore(juliusId.getGuid());
        AtlasEntity jane = this.getEntityFromStore(janeId.getGuid());
        AtlasEntity mike = this.getEntityFromStore(mikeId.getGuid());
        List<AtlasObjectId> deptEmployees = AtlasRelationshipStoreV2Test.toAtlasObjectIds(hrDept.getRelationshipAttribute("employees"));
        Assert.assertNotNull(deptEmployees);
        Assert.assertEquals((int)deptEmployees.size(), (int)5);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(deptEmployees, maxId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(deptEmployees, johnId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(deptEmployees, juliusId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(deptEmployees, janeId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(deptEmployees, mikeId);
        AtlasObjectId maxDepartmentId = AtlasRelationshipStoreV2Test.toAtlasObjectId(max.getRelationshipAttribute("department"));
        Assert.assertNotNull((Object)maxDepartmentId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(maxDepartmentId, hrId);
        AtlasObjectId maxManagerId = AtlasRelationshipStoreV2Test.toAtlasObjectId(max.getRelationshipAttribute("manager"));
        Assert.assertNotNull((Object)maxManagerId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(maxManagerId, janeId);
        List<AtlasObjectId> maxMentorsId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(max.getRelationshipAttribute("mentors"));
        Assert.assertNotNull(maxMentorsId);
        Assert.assertEquals((int)maxMentorsId.size(), (int)1);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(maxMentorsId.get(0), juliusId);
        List<AtlasObjectId> maxMenteesId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(max.getRelationshipAttribute("mentees"));
        Assert.assertNotNull(maxMenteesId);
        Assert.assertEquals((int)maxMenteesId.size(), (int)1);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(maxMenteesId.get(0), johnId);
        List<AtlasObjectId> maxFriendsIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(max.getRelationshipAttribute("friends"));
        Assert.assertNotNull(maxFriendsIds);
        Assert.assertEquals((int)maxFriendsIds.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(maxFriendsIds, mikeId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(maxFriendsIds, johnId);
        AtlasObjectId johnDepartmentId = AtlasRelationshipStoreV2Test.toAtlasObjectId(john.getRelationshipAttribute("department"));
        Assert.assertNotNull((Object)johnDepartmentId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(johnDepartmentId, hrId);
        AtlasObjectId johnManagerId = AtlasRelationshipStoreV2Test.toAtlasObjectId(john.getRelationshipAttribute("manager"));
        Assert.assertNotNull((Object)johnManagerId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(johnManagerId, janeId);
        List<AtlasObjectId> johnMentorIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(john.getRelationshipAttribute("mentors"));
        Assert.assertNotNull(johnMentorIds);
        Assert.assertEquals((int)johnMentorIds.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(johnMentorIds, maxId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(johnMentorIds, juliusId);
        List<AtlasObjectId> johnMenteesId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(john.getRelationshipAttribute("mentees"));
        AtlasRelationshipStoreV2Test.assertEmpty(johnMenteesId);
        List<AtlasObjectId> johnFriendsIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(john.getRelationshipAttribute("friends"));
        Assert.assertNotNull(johnFriendsIds);
        Assert.assertEquals((int)johnFriendsIds.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(johnFriendsIds, mikeId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(johnFriendsIds, maxId);
        AtlasObjectId mikeDepartmentId = AtlasRelationshipStoreV2Test.toAtlasObjectId(mike.getRelationshipAttribute("department"));
        Assert.assertNotNull((Object)mikeDepartmentId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(mikeDepartmentId, hrId);
        AtlasObjectId mikeManagerId = AtlasRelationshipStoreV2Test.toAtlasObjectId(mike.getRelationshipAttribute("manager"));
        Assert.assertNotNull((Object)mikeManagerId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(mikeManagerId, juliusId);
        List<AtlasObjectId> mikeMentorIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(mike.getRelationshipAttribute("mentors"));
        AtlasRelationshipStoreV2Test.assertEmpty(mikeMentorIds);
        List<AtlasObjectId> mikeMenteesId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(mike.getRelationshipAttribute("mentees"));
        AtlasRelationshipStoreV2Test.assertEmpty(mikeMenteesId);
        List<AtlasObjectId> mikeFriendsIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(mike.getRelationshipAttribute("friends"));
        Assert.assertNotNull(mikeFriendsIds);
        Assert.assertEquals((int)mikeFriendsIds.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(mikeFriendsIds, maxId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(mikeFriendsIds, johnId);
        AtlasObjectId janeDepartmentId = AtlasRelationshipStoreV2Test.toAtlasObjectId(jane.getRelationshipAttribute("department"));
        Assert.assertNotNull((Object)janeDepartmentId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(janeDepartmentId, hrId);
        AtlasObjectId janeManagerId = AtlasRelationshipStoreV2Test.toAtlasObjectId(jane.getRelationshipAttribute("manager"));
        Assert.assertNull((Object)janeManagerId);
        List<AtlasObjectId> janeMentorIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(jane.getRelationshipAttribute("mentors"));
        AtlasRelationshipStoreV2Test.assertEmpty(janeMentorIds);
        List<AtlasObjectId> janeMenteesId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(jane.getRelationshipAttribute("mentees"));
        AtlasRelationshipStoreV2Test.assertEmpty(janeMenteesId);
        List<AtlasObjectId> janeSubordinateIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(jane.getRelationshipAttribute("subordinates"));
        Assert.assertNotNull(janeSubordinateIds);
        Assert.assertEquals((int)janeSubordinateIds.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(janeSubordinateIds, maxId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(janeSubordinateIds, johnId);
        List<AtlasObjectId> janeFriendsIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(jane.getRelationshipAttribute("friends"));
        AtlasRelationshipStoreV2Test.assertEmpty(janeFriendsIds);
        AtlasObjectId janeSiblingId = AtlasRelationshipStoreV2Test.toAtlasObjectId(jane.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)janeSiblingId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(janeSiblingId, juliusId);
        AtlasObjectId juliusDepartmentId = AtlasRelationshipStoreV2Test.toAtlasObjectId(julius.getRelationshipAttribute("department"));
        Assert.assertNotNull((Object)juliusDepartmentId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(juliusDepartmentId, hrId);
        AtlasObjectId juliusManagerId = AtlasRelationshipStoreV2Test.toAtlasObjectId(julius.getRelationshipAttribute("manager"));
        Assert.assertNull((Object)juliusManagerId);
        List<AtlasObjectId> juliusMentorIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("mentors"));
        AtlasRelationshipStoreV2Test.assertEmpty(juliusMentorIds);
        List<AtlasObjectId> juliusMenteesId = AtlasRelationshipStoreV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("mentees"));
        Assert.assertNotNull(juliusMenteesId);
        Assert.assertEquals((int)juliusMenteesId.size(), (int)2);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(juliusMenteesId, maxId);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(juliusMenteesId, johnId);
        List<AtlasObjectId> juliusSubordinateIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("subordinates"));
        Assert.assertNotNull(juliusSubordinateIds);
        Assert.assertEquals((int)juliusSubordinateIds.size(), (int)1);
        AtlasRelationshipStoreV2Test.assertObjectIdsContains(juliusSubordinateIds, mikeId);
        List<AtlasObjectId> juliusFriendsIds = AtlasRelationshipStoreV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("friends"));
        AtlasRelationshipStoreV2Test.assertEmpty(juliusFriendsIds);
        AtlasObjectId juliusSiblingId = AtlasRelationshipStoreV2Test.toAtlasObjectId(julius.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)juliusSiblingId);
        AtlasRelationshipStoreV2Test.assertObjectIdEquals(juliusSiblingId, janeId);
    }

    @Test(enabled=false)
    public void testRelationshipAttributeUpdate_NonComposite_OneToMany() throws Exception {
        AtlasObjectId maxId = this.employeeNameIdMap.get("Max");
        AtlasObjectId juliusId = this.employeeNameIdMap.get("Julius");
        AtlasObjectId janeId = this.employeeNameIdMap.get("Jane");
        AtlasObjectId mikeId = this.employeeNameIdMap.get("Mike");
        AtlasObjectId johnId = this.employeeNameIdMap.get("John");
        AtlasEntity maxEntityForUpdate = new AtlasEntity("Employee");
        maxEntityForUpdate.setRelationshipAttribute("manager", (Object)juliusId);
        AtlasEntityType employeeType = this.typeRegistry.getEntityTypeByName("Employee");
        Map<String, String> uniqAttributes = Collections.singletonMap("name", "Max");
        EntityMutationResponse updateResponse = this.entityStore.updateByUniqueAttributes(employeeType, uniqAttributes, new AtlasEntity.AtlasEntityWithExtInfo(maxEntityForUpdate));
        List partialUpdatedEntities = updateResponse.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)maxId.getGuid(), (Object)juliusId.getGuid(), (Object)janeId.getGuid()));
        AtlasEntity maxEntity = updatedEntities.getEntity(maxId.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(maxEntity, "manager", juliusId.getGuid());
        AtlasEntity juliusEntity = updatedEntities.getEntity(juliusId.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(juliusEntity, "subordinates", (List<AtlasObjectId>)ImmutableList.of((Object)maxId, (Object)mikeId));
        AtlasEntity janeEntity = updatedEntities.getEntity(janeId.getGuid());
        this.verifyRelationshipAttributeUpdate_NonComposite_OneToMany(janeEntity);
        maxEntityForUpdate = new AtlasEntity("Employee");
        maxEntityForUpdate.setRelationshipAttribute("friends", (Object)ImmutableList.of((Object)johnId, (Object)juliusId));
        this.init();
        updateResponse = this.entityStore.updateByUniqueAttributes(employeeType, uniqAttributes, new AtlasEntity.AtlasEntityWithExtInfo(maxEntityForUpdate));
        partialUpdatedEntities = updateResponse.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)maxId.getGuid(), (Object)mikeId.getGuid(), (Object)johnId.getGuid(), (Object)juliusId.getGuid()));
        maxEntity = updatedEntities.getEntity(maxId.getGuid());
        juliusEntity = updatedEntities.getEntity(juliusId.getGuid());
        AtlasEntity mikeEntity = updatedEntities.getEntity(mikeId.getGuid());
        AtlasEntity johnEntity = updatedEntities.getEntity(johnId.getGuid());
        this.verifyRelationshipAttributeUpdate_ManyToMany_Friends(maxEntity, juliusEntity, mikeEntity, johnEntity);
        AtlasEntity juliusEntityForUpdate = new AtlasEntity("Employee");
        juliusEntityForUpdate.setRelationshipAttribute("sibling", (Object)mikeId);
        this.init();
        updateResponse = this.entityStore.updateByUniqueAttributes(employeeType, Collections.singletonMap("name", "Julius"), new AtlasEntity.AtlasEntityWithExtInfo(juliusEntityForUpdate));
        partialUpdatedEntities = updateResponse.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)3);
        updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)juliusId.getGuid(), (Object)janeId.getGuid(), (Object)mikeId.getGuid()));
        juliusEntity = updatedEntities.getEntity(juliusId.getGuid());
        janeEntity = updatedEntities.getEntity(janeId.getGuid());
        mikeEntity = updatedEntities.getEntity(mikeId.getGuid());
        this.verifyRelationshipAttributeUpdate_OneToOne_Sibling(juliusEntity, janeEntity, mikeEntity);
    }

    @Test
    public void testRelationshipAttributeUpdate_NonComposite_ManyToOne() throws Exception {
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)"a1_name");
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)"a2_name");
        AtlasEntity a3 = new AtlasEntity("A");
        a3.setAttribute("name", (Object)"a3_name");
        AtlasEntity b = new AtlasEntity("B");
        b.setAttribute("name", (Object)"b_name");
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        entitiesWithExtInfo.addEntity(a1);
        entitiesWithExtInfo.addEntity(a2);
        entitiesWithExtInfo.addEntity(a3);
        entitiesWithExtInfo.addEntity(b);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesWithExtInfo), false);
        AtlasEntity bPartialUpdate = new AtlasEntity("B");
        bPartialUpdate.setRelationshipAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        this.init();
        EntityMutationResponse response = this.entityStore.updateByUniqueAttributes(this.typeRegistry.getEntityTypeByName("B"), Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bPartialUpdate));
        Assert.assertEquals((int)response.getPartialUpdatedEntities().size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b.getGuid()));
        AtlasEntity a1Entity = updatedEntities.getEntity(a1.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(a1Entity, "oneB", b.getGuid());
        AtlasEntity a2Entity = updatedEntities.getEntity(a2.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(a2Entity, "oneB", b.getGuid());
        AtlasEntity bEntity = updatedEntities.getEntity(b.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(bEntity, "manyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        bPartialUpdate.setRelationshipAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
        this.init();
        response = this.entityStore.updateByUniqueAttributes(this.typeRegistry.getEntityTypeByName("B"), Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(bPartialUpdate));
        Assert.assertEquals((int)response.getPartialUpdatedEntities().size(), (int)4);
        this.init();
        updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)a3.getGuid(), (Object)b.getGuid()));
        a1Entity = updatedEntities.getEntity(a1.getGuid());
        a2Entity = updatedEntities.getEntity(a2.getGuid());
        bEntity = updatedEntities.getEntity(b.getGuid());
        AtlasEntity a3Entity = updatedEntities.getEntity(a3.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(a3Entity, "oneB", b.getGuid());
        this.verifyRelationshipAttributeUpdate_NonComposite_ManyToOne(a1Entity, a2Entity, a3Entity, bEntity);
    }

    @Test
    public void testRelationshipAttributeUpdate_NonComposite_OneToOne() throws Exception {
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)"a1_name");
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)"a2_name");
        AtlasEntity b = new AtlasEntity("B");
        b.setAttribute("name", (Object)"b_name");
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        entitiesWithExtInfo.addEntity(a1);
        entitiesWithExtInfo.addEntity(a2);
        entitiesWithExtInfo.addEntity(b);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesWithExtInfo), false);
        AtlasEntity partialUpdateB = new AtlasEntity("B");
        partialUpdateB.setRelationshipAttribute("a", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1));
        this.init();
        AtlasEntityType bType = this.typeRegistry.getEntityTypeByName("B");
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(partialUpdateB));
        List partialUpdatedEntitiesHeader = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntitiesHeader.size(), (int)2);
        AtlasEntity.AtlasEntitiesWithExtInfo partialUpdatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)b.getGuid()));
        AtlasEntity a1Entity = partialUpdatedEntities.getEntity(a1.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(a1Entity, "b", b.getGuid());
        AtlasEntity bEntity = partialUpdatedEntities.getEntity(b.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(bEntity, "a", a1.getGuid());
        this.init();
        partialUpdateB.setRelationshipAttribute("a", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2));
        response = this.entityStore.updateByUniqueAttributes(bType, Collections.singletonMap("name", b.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(partialUpdateB));
        partialUpdatedEntitiesHeader = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntitiesHeader.size(), (int)3);
        partialUpdatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b.getGuid()));
        bEntity = partialUpdatedEntities.getEntity(b.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(bEntity, "a", a2.getGuid());
        AtlasEntity a2Entity = partialUpdatedEntities.getEntity(a2.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeValue(a2Entity, "b", b.getGuid());
        a1Entity = partialUpdatedEntities.getEntity(a1.getGuid());
        this.verifyRelationshipAttributeUpdate_NonComposite_OneToOne(a1Entity, bEntity);
    }

    @Test
    public void testRelationshipAttributeUpdate_NonComposite_ManyToMany() throws Exception {
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)"a1_name");
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)"a2_name");
        AtlasEntity a3 = new AtlasEntity("A");
        a3.setAttribute("name", (Object)"a3_name");
        AtlasEntity b1 = new AtlasEntity("B");
        b1.setAttribute("name", (Object)"b1_name");
        AtlasEntity b2 = new AtlasEntity("B");
        b2.setAttribute("name", (Object)"b2_name");
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        entitiesWithExtInfo.addEntity(a1);
        entitiesWithExtInfo.addEntity(a2);
        entitiesWithExtInfo.addEntity(a3);
        entitiesWithExtInfo.addEntity(b1);
        entitiesWithExtInfo.addEntity(b2);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesWithExtInfo), false);
        AtlasEntity b1PartialUpdate = new AtlasEntity("B");
        b1PartialUpdate.setRelationshipAttribute("manyToManyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        this.init();
        EntityMutationResponse response = this.entityStore.updateByUniqueAttributes(this.typeRegistry.getEntityTypeByName("B"), Collections.singletonMap("name", b1.getAttribute("name")), new AtlasEntity.AtlasEntityWithExtInfo(b1PartialUpdate));
        List updatedEntityHeaders = response.getPartialUpdatedEntities();
        Assert.assertEquals((int)updatedEntityHeaders.size(), (int)3);
        AtlasEntity.AtlasEntitiesWithExtInfo updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)a1.getGuid(), (Object)a2.getGuid(), (Object)b1.getGuid()));
        AtlasEntity b1Entity = updatedEntities.getEntity(b1.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(b1Entity, "manyToManyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        AtlasEntity a1Entity = updatedEntities.getEntity(a1.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(a1Entity, "manyB", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1)));
        AtlasEntity a2Entity = updatedEntities.getEntity(a2.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(a2Entity, "manyB", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b1)));
    }

    @Test
    public void testRelationshipAttributeOnPartialUpdate() throws Exception {
        AtlasObjectId maxId = this.employeeNameIdMap.get("Max");
        AtlasObjectId janeId = this.employeeNameIdMap.get("Jane");
        AtlasObjectId mikeId = this.employeeNameIdMap.get("Mike");
        AtlasObjectId johnId = this.employeeNameIdMap.get("John");
        AtlasEntity maxEntityForUpdate = new AtlasEntity("Employee");
        maxEntityForUpdate.setRelationshipAttribute("friends", Arrays.asList(janeId));
        AtlasEntityType employeeType = this.typeRegistry.getEntityTypeByName("Employee");
        Map<String, String> uniqAttributes = Collections.singletonMap("name", "Max");
        this.init();
        EntityMutationResponse updateResponse = this.entityStore.updateByUniqueAttributes(employeeType, uniqAttributes, new AtlasEntity.AtlasEntityWithExtInfo(maxEntityForUpdate));
        List partialUpdatedEntities = updateResponse.getPartialUpdatedEntities();
        Assert.assertEquals((int)partialUpdatedEntities.size(), (int)2);
        AtlasEntity.AtlasEntitiesWithExtInfo updatedEntities = this.entityStore.getByIds((List)ImmutableList.of((Object)maxId.getGuid(), (Object)janeId.getGuid()));
        AtlasEntity maxEntity = updatedEntities.getEntity(maxId.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(maxEntity, "friends", (List<AtlasObjectId>)ImmutableList.of((Object)mikeId, (Object)johnId, (Object)janeId));
        AtlasEntity janeEntity = updatedEntities.getEntity(janeId.getGuid());
        AtlasRelationshipStoreV2Test.verifyRelationshipAttributeList(janeEntity, "friends", (List<AtlasObjectId>)ImmutableList.of((Object)maxId));
    }

    protected abstract void verifyRelationshipAttributeUpdate_NonComposite_OneToOne(AtlasEntity var1, AtlasEntity var2);

    protected abstract void verifyRelationshipAttributeUpdate_NonComposite_OneToMany(AtlasEntity var1) throws Exception;

    protected abstract void verifyRelationshipAttributeUpdate_NonComposite_ManyToOne(AtlasEntity var1, AtlasEntity var2, AtlasEntity var3, AtlasEntity var4);

    protected abstract void verifyRelationshipAttributeUpdate_ManyToMany_Friends(AtlasEntity var1, AtlasEntity var2, AtlasEntity var3, AtlasEntity var4) throws Exception;

    protected abstract void verifyRelationshipAttributeUpdate_OneToOne_Sibling(AtlasEntity var1, AtlasEntity var2, AtlasEntity var3) throws Exception;

    protected static void assertObjectIdsContains(List<AtlasObjectId> objectIds, AtlasObjectId objectId) {
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty(objectIds));
        Assert.assertTrue((boolean)objectIds.contains(objectId));
    }

    protected static void assertObjectIdEquals(AtlasObjectId objId1, AtlasObjectId objId2) {
        Assert.assertTrue((boolean)objId1.equals((Object)objId2));
    }

    private static void assertEmpty(List collection) {
        Assert.assertTrue((collection != null && collection.isEmpty() ? 1 : 0) != 0);
    }

    protected static List<AtlasObjectId> toAtlasObjectIds(Object object) {
        List objectIds;
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        if (object instanceof List && CollectionUtils.isNotEmpty((Collection)(objectIds = (List)object))) {
            for (Object obj : objectIds) {
                if (!(obj instanceof AtlasRelatedObjectId)) continue;
                AtlasRelatedObjectId relatedObjectId = (AtlasRelatedObjectId)obj;
                ret.add(new AtlasObjectId(relatedObjectId.getGuid(), relatedObjectId.getTypeName(), relatedObjectId.getUniqueAttributes()));
            }
        }
        return ret;
    }

    protected static AtlasObjectId toAtlasObjectId(Object object) {
        if (object instanceof AtlasRelatedObjectId) {
            AtlasRelatedObjectId relatedObjectId = (AtlasRelatedObjectId)object;
            return new AtlasObjectId(relatedObjectId.getGuid(), relatedObjectId.getTypeName(), relatedObjectId.getUniqueAttributes());
        }
        return null;
    }

    private AtlasEntity getEntityFromStore(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = guid != null ? this.entityStore.getById(guid) : null;
        return entity != null ? entity.getEntity() : null;
    }

    protected static void verifyRelationshipAttributeList(AtlasEntity entity, String relationshipAttrName, List<AtlasObjectId> expectedValues) {
        Object refValue = entity.getRelationshipAttribute(relationshipAttrName);
        Assert.assertTrue((boolean)(refValue instanceof List));
        List<AtlasObjectId> refList = AtlasRelationshipStoreV2Test.toAtlasObjectIds(refValue);
        Assert.assertEquals((int)refList.size(), (int)expectedValues.size());
        if (expectedValues.size() > 0) {
            Assert.assertTrue((boolean)refList.containsAll(expectedValues));
        }
    }

    protected static void verifyRelationshipAttributeValue(AtlasEntity entity, String relationshipAttrName, String expectedGuid) {
        Object refValue = entity.getRelationshipAttribute(relationshipAttrName);
        if (expectedGuid == null) {
            Assert.assertNull((Object)refValue);
        } else {
            Assert.assertTrue((boolean)(refValue instanceof AtlasObjectId));
            AtlasObjectId referencedObjectId = (AtlasObjectId)refValue;
            Assert.assertEquals((String)referencedObjectId.getGuid(), (String)expectedGuid);
        }
    }
}

