/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipDefStoreV2;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasRelationshipDefStoreV2Test
extends AtlasTestBase {
    @Inject
    private AtlasRelationshipDefStoreV2 relationshipDefStore;

    @DataProvider
    public Object[][] invalidAttributeNameWithReservedKeywords() {
        AtlasRelationshipDef invalidAttrNameType = AtlasTypeUtil.createRelationshipTypeDef((String)"Invalid_Attribute_Type", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeA", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeB", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"order", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"limit", (String)"string")});
        return new Object[][]{{invalidAttrNameType}};
    }

    @DataProvider
    public Object[][] updateValidProperties() {
        AtlasRelationshipDef existingType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"0", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef newType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description1", (String)"1", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        return new Object[][]{{existingType, newType}};
    }

    @DataProvider
    public Object[][] updateRename() {
        AtlasRelationshipDef existingType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef newType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType2", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        return new Object[][]{{existingType, newType}};
    }

    @DataProvider
    public Object[][] updateRelCat() {
        AtlasRelationshipDef existingType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef newType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.AGGREGATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        return new Object[][]{{existingType, newType}};
    }

    @DataProvider
    public Object[][] updateEnd1() {
        AtlasRelationshipDef existingType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeE", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeAttr = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeCardinality = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.LIST), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        return new Object[][]{{existingType, changeType}, {existingType, changeAttr}, {existingType, changeCardinality}};
    }

    @DataProvider
    public Object[][] updateEnd2() {
        AtlasRelationshipDef existingType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeType = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeE", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeAttr = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        AtlasRelationshipDef changeCardinality = AtlasTypeUtil.createRelationshipTypeDef((String)"basicType", (String)"description", (String)"", (AtlasRelationshipDef.RelationshipCategory)AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, (AtlasRelationshipDef.PropagateTags)AtlasRelationshipDef.PropagateTags.BOTH, (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeC", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), (AtlasRelationshipEndDef)new AtlasRelationshipEndDef("typeD", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.LIST), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"aaaa", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"bbbb", (String)"string")});
        return new Object[][]{{existingType, changeType}, {existingType, changeAttr}, {existingType, changeCardinality}};
    }

    @Test(dataProvider="invalidAttributeNameWithReservedKeywords")
    public void testCreateTypeWithReservedKeywords(AtlasRelationshipDef atlasRelationshipDef) throws AtlasException {
        try {
            ApplicationProperties.get().setProperty("atlas.types.allowReservedKeywords", (Object)false);
            this.relationshipDefStore.create(atlasRelationshipDef, null);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.ATTRIBUTE_NAME_INVALID);
        }
    }

    @Test(dataProvider="updateValidProperties")
    public void testupdateVertexPreUpdatepropagateTags(AtlasRelationshipDef existingRelationshipDef, AtlasRelationshipDef newRelationshipDef) throws AtlasBaseException {
        AtlasRelationshipDefStoreV2.preUpdateCheck((AtlasRelationshipDef)existingRelationshipDef, (AtlasRelationshipDef)newRelationshipDef);
    }

    @Test(dataProvider="updateRename")
    public void testupdateVertexPreUpdateRename(AtlasRelationshipDef existingRelationshipDef, AtlasRelationshipDef newRelationshipDef) {
        block2: {
            try {
                AtlasRelationshipDefStoreV2.preUpdateCheck((AtlasRelationshipDef)existingRelationshipDef, (AtlasRelationshipDef)newRelationshipDef);
                AssertJUnit.fail((String)"expected error");
            }
            catch (AtlasBaseException e) {
                if (e.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_INVALID_NAME_UPDATE)) break block2;
                AssertJUnit.fail((String)("unexpected AtlasErrorCode " + e.getAtlasErrorCode()));
            }
        }
    }

    @Test(dataProvider="updateRelCat")
    public void testupdateVertexPreUpdateRelcat(AtlasRelationshipDef existingRelationshipDef, AtlasRelationshipDef newRelationshipDef) {
        block2: {
            try {
                AtlasRelationshipDefStoreV2.preUpdateCheck((AtlasRelationshipDef)existingRelationshipDef, (AtlasRelationshipDef)newRelationshipDef);
                AssertJUnit.fail((String)"expected error");
            }
            catch (AtlasBaseException e) {
                if (e.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_INVALID_CATEGORY_UPDATE)) break block2;
                AssertJUnit.fail((String)("unexpected AtlasErrorCode " + e.getAtlasErrorCode()));
            }
        }
    }

    @Test(dataProvider="updateEnd1")
    public void testupdateVertexPreUpdateEnd1(AtlasRelationshipDef existingRelationshipDef, AtlasRelationshipDef newRelationshipDef) {
        block2: {
            try {
                AtlasRelationshipDefStoreV2.preUpdateCheck((AtlasRelationshipDef)existingRelationshipDef, (AtlasRelationshipDef)newRelationshipDef);
                AssertJUnit.fail((String)"expected error");
            }
            catch (AtlasBaseException e) {
                if (e.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_INVALID_END1_UPDATE)) break block2;
                AssertJUnit.fail((String)("unexpected AtlasErrorCode " + e.getAtlasErrorCode()));
            }
        }
    }

    @Test(dataProvider="updateEnd2")
    public void testupdateVertexPreUpdateEnd2(AtlasRelationshipDef existingRelationshipDef, AtlasRelationshipDef newRelationshipDef) {
        block2: {
            try {
                AtlasRelationshipDefStoreV2.preUpdateCheck((AtlasRelationshipDef)existingRelationshipDef, (AtlasRelationshipDef)newRelationshipDef);
                AssertJUnit.fail((String)"expected error");
            }
            catch (AtlasBaseException e) {
                if (e.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_INVALID_END2_UPDATE)) break block2;
                AssertJUnit.fail((String)("unexpected AtlasErrorCode " + e.getAtlasErrorCode()));
            }
        }
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

