/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasEntityTestBase
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    AtlasTypeDefStore typeDefStore;
    @Inject
    AtlasEntityStore entityStore;
    @Inject
    DeleteHandlerDelegate deleteDelegate;
    @Inject
    private EntityGraphMapper graphMapper;
    @Inject
    protected AtlasGraph graph;
    AtlasEntityChangeNotifier mockChangeNotifier = (AtlasEntityChangeNotifier)Mockito.mock(AtlasEntityChangeNotifier.class);

    @BeforeClass
    public void setUp() throws Exception {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        super.initialize();
        new GraphBackedSearchIndexer(this.typeRegistry);
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @BeforeTest
    public void init() throws Exception {
        this.entityStore = new AtlasEntityStoreV2(this.graph, this.deleteDelegate, this.typeRegistry, (IAtlasEntityChangeNotifier)this.mockChangeNotifier, this.graphMapper);
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    protected AtlasClassificationDef getTagWithName(AtlasTypesDef typesDef, String tagName, String attributeType) {
        AtlasClassificationDef aTag = new AtlasClassificationDef(tagName);
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef("testAttribute", attributeType, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, true, false, Collections.emptyList());
        aTag.addAttribute(attributeDef);
        typesDef.setClassificationDefs(Arrays.asList(aTag));
        return aTag;
    }

    protected void createTag(String tagName, String attributeType) {
        try {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            this.getTagWithName(typesDef, tagName, attributeType);
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag creation should've succeeded");
        }
    }

    protected String randomStrWithReservedChars() {
        return TestUtilsV2.randomString() + "\"${}%";
    }

    protected void validateMutationResponse(EntityMutationResponse response, EntityMutations.EntityOperation op, int expectedNumCreated) {
        List entitiesCreated = response.getEntitiesByOperation(op);
        Assert.assertNotNull((Object)entitiesCreated);
        Assert.assertEquals((int)entitiesCreated.size(), (int)expectedNumCreated);
    }

    protected void validateEntity(AtlasEntity.AtlasEntityExtInfo entityExtInfo, AtlasEntity actual) throws AtlasBaseException, AtlasException {
        this.validateEntity(entityExtInfo, (AtlasStruct)actual, (AtlasStruct)entityExtInfo.getEntity(actual.getGuid()));
    }

    protected void validateEntity(AtlasEntity.AtlasEntityExtInfo entityExtInfo, AtlasStruct actual, AtlasStruct expected) throws AtlasBaseException, AtlasException {
        if (expected == null) {
            Assert.assertNull((Object)actual, (String)("expected null instance. Found " + actual));
            return;
        }
        Assert.assertNotNull((Object)actual, (String)"found null instance");
        AtlasStructType entityType = (AtlasStructType)this.typeRegistry.getType(actual.getTypeName());
        for (String attrName : expected.getAttributes().keySet()) {
            Object expectedVal = expected.getAttribute(attrName);
            Object actualVal = actual.getAttribute(attrName);
            AtlasType attrType = entityType.getAttributeType(attrName);
            this.validateAttribute(entityExtInfo, actualVal, expectedVal, attrType, attrName);
        }
    }

    protected void validateAttribute(AtlasEntity.AtlasEntityExtInfo entityExtInfo, Object actual, Object expected, AtlasType attributeType, String attrName) throws AtlasBaseException, AtlasException {
        switch (attributeType.getTypeCategory()) {
            case OBJECT_ID_TYPE: {
                Assert.assertTrue((boolean)(actual instanceof AtlasObjectId));
                String guid = ((AtlasObjectId)actual).getGuid();
                Assert.assertTrue((boolean)AtlasTypeUtil.isAssignedGuid((String)guid), (String)("expected assigned guid. found " + guid));
                break;
            }
            case PRIMITIVE: 
            case ENUM: {
                Assert.assertEquals((Object)actual, (Object)expected);
                break;
            }
            case MAP: {
                AtlasMapType mapType = (AtlasMapType)attributeType;
                AtlasType valueType = mapType.getValueType();
                Map actualMap = (Map)actual;
                Map expectedMap = (Map)expected;
                if (!MapUtils.isNotEmpty((Map)expectedMap)) break;
                Assert.assertTrue((boolean)MapUtils.isNotEmpty((Map)actualMap));
                Assert.assertTrue((actualMap.size() >= expectedMap.size() ? 1 : 0) != 0);
                for (Object key : expectedMap.keySet()) {
                    this.validateAttribute(entityExtInfo, actualMap.get(key), expectedMap.get(key), valueType, attrName);
                }
                break;
            }
            case ARRAY: {
                AtlasArrayType arrType = (AtlasArrayType)attributeType;
                AtlasType elemType = arrType.getElementType();
                List actualList = (List)actual;
                List expectedList = (List)expected;
                if (!CollectionUtils.isNotEmpty((Collection)expectedList)) break;
                Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)actualList));
                Assert.assertTrue((actualList.size() >= expectedList.size() ? 1 : 0) != 0);
                for (int i = 0; i < expectedList.size(); ++i) {
                    Assert.assertTrue((boolean)actualList.contains(expectedList.get(i)));
                }
                break;
            }
            case STRUCT: {
                AtlasStruct expectedStruct = (AtlasStruct)expected;
                AtlasStruct actualStruct = (AtlasStruct)actual;
                this.validateEntity(entityExtInfo, actualStruct, expectedStruct);
                break;
            }
            default: {
                Assert.fail((String)"Unknown type category");
            }
        }
    }

    protected AtlasEntity getEntityFromStore(AtlasEntityHeader header) throws AtlasBaseException {
        return header != null ? this.getEntityFromStore(header.getGuid()) : null;
    }

    protected AtlasEntity getEntityFromStore(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = guid != null ? this.entityStore.getById(guid) : null;
        return entity != null ? entity.getEntity() : null;
    }

    protected void createTypesDef(AtlasTypesDef[] testTypesDefs) throws AtlasBaseException {
        for (AtlasTypesDef typesDef : testTypesDefs) {
            AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)typesDef, (AtlasTypeRegistry)this.typeRegistry);
            if (typesToCreate.isEmpty()) continue;
            this.typeDefStore.createTypesDef(typesToCreate);
        }
    }
}

