/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityTestBase;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.InMemoryMapEntityStream;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasEntityStoreV2Test
extends AtlasEntityTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityStoreV2Test.class);
    public static final String CSV_FILES = "/csvFiles/";
    private AtlasEntity.AtlasEntitiesWithExtInfo deptEntity;
    private AtlasEntity.AtlasEntityWithExtInfo dbEntity;
    private AtlasEntity.AtlasEntityWithExtInfo tblEntity;
    private AtlasEntity.AtlasEntityWithExtInfo nestedCollectionAttrEntity;
    private AtlasEntity.AtlasEntityWithExtInfo primitiveEntity;
    AtlasEntityChangeNotifier mockChangeNotifier = (AtlasEntityChangeNotifier)Mockito.mock(AtlasEntityChangeNotifier.class);
    @Inject
    private EntityGraphMapper graphMapper;
    @Inject
    private String dbEntityGuid;
    private String tblEntityGuid;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        AtlasTypesDef[] testTypesDefs = new AtlasTypesDef[]{TestUtilsV2.defineDeptEmployeeTypes(), TestUtilsV2.defineHiveTypes(), TestUtilsV2.defineTypeWithNestedCollectionAttributes(), TestUtilsV2.defineEnumTypes(), TestUtilsV2.defineBusinessMetadataTypes()};
        this.createTypesDef(testTypesDefs);
        this.deptEntity = TestUtilsV2.createDeptEg2();
        this.dbEntity = TestUtilsV2.createDBEntityV2();
        this.tblEntity = TestUtilsV2.createTableEntityV2((AtlasEntity)this.dbEntity.getEntity());
        this.nestedCollectionAttrEntity = TestUtilsV2.createNestedCollectionAttrEntity();
        this.primitiveEntity = TestUtilsV2.createprimitiveEntityV2();
        AtlasTypesDef typesDef11 = new AtlasTypesDef();
        ArrayList<AtlasEntityDef> primitiveEntityDef = new ArrayList<AtlasEntityDef>();
        primitiveEntityDef.add(TestUtilsV2.createPrimitiveEntityDef());
        typesDef11.setEntityDefs(primitiveEntityDef);
        this.typeDefStore.createTypesDef(typesDef11);
    }

    @Override
    @BeforeTest
    public void init() throws Exception {
        this.entityStore = new AtlasEntityStoreV2(this.graph, this.deleteDelegate, this.typeRegistry, (IAtlasEntityChangeNotifier)this.mockChangeNotifier, this.graphMapper);
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        LOG.debug("RequestContext: activeCount={}, earliestActiveRequestTime={}", (Object)RequestContext.getActiveRequestsCount(), (Object)RequestContext.earliestActiveRequestTime());
    }

    @Test
    public void testDefaultValueForPrimitiveTypes() throws Exception {
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.primitiveEntity), false);
        List entitiesCreatedResponse = response.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        List entitiesCreatedwithdefault = (List)response.getMutatedEntities().get(EntityMutations.EntityOperation.CREATE);
        AtlasEntity entityCreated = this.getEntityFromStore((AtlasEntityHeader)entitiesCreatedResponse.get(0));
        Map attributesMap = entityCreated.getAttributes();
        String description = (String)attributesMap.get("description");
        String check = (String)attributesMap.get("check");
        String sourceCode = (String)attributesMap.get("sourcecode");
        float diskUsage = ((Float)attributesMap.get("diskUsage")).floatValue();
        boolean isstoreUse = (Boolean)attributesMap.get("isstoreUse");
        int cost = (Integer)attributesMap.get("Cost");
        Assert.assertEquals((String)description, (String)"test");
        Assert.assertEquals((String)check, (String)"check");
        Assert.assertEquals((Object)Float.valueOf(diskUsage), (Object)Float.valueOf(70.5f));
        Assert.assertEquals((boolean)isstoreUse, (boolean)true);
        Assert.assertEquals((String)sourceCode, (String)"Hello World");
        Assert.assertEquals((int)cost, (int)30);
    }

    @Test(priority=-1)
    public void testCreate() throws Exception {
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.deptEntity), false);
        this.validateMutationResponse(response, EntityMutations.EntityOperation.CREATE, 5);
        AtlasEntityHeader dept1 = response.getFirstCreatedEntityByTypeName("Department");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.deptEntity, (AtlasStruct)this.getEntityFromStore(dept1), (AtlasStruct)this.deptEntity.getEntities().get(0));
        Map entitiesMutated = response.getMutatedEntities();
        List entitiesCreated = (List)entitiesMutated.get(EntityMutations.EntityOperation.CREATE);
        Assert.assertTrue((entitiesCreated.size() >= this.deptEntity.getEntities().size() ? 1 : 0) != 0);
        for (int i = 0; i < this.deptEntity.getEntities().size(); ++i) {
            AtlasEntity expected = (AtlasEntity)this.deptEntity.getEntities().get(i);
            AtlasEntity actual = this.getEntityFromStore((AtlasEntityHeader)entitiesCreated.get(i));
            this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.deptEntity, (AtlasStruct)actual, (AtlasStruct)expected);
        }
        this.init();
        EntityMutationResponse dbCreationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.dbEntity), false);
        this.validateMutationResponse(dbCreationResponse, EntityMutations.EntityOperation.CREATE, 1);
        this.dbEntityGuid = ((AtlasEntityHeader)dbCreationResponse.getCreatedEntities().get(0)).getGuid();
        AtlasEntityHeader db1 = dbCreationResponse.getFirstCreatedEntityByTypeName("hive_database");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.dbEntity, this.getEntityFromStore(db1));
        AtlasObjectId dbObjectId = (AtlasObjectId)this.tblEntity.getEntity().getAttribute("database");
        dbObjectId.setGuid(db1.getGuid());
        this.tblEntity.addReferredEntity(this.dbEntity.getEntity());
        this.init();
        EntityMutationResponse tableCreationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.tblEntity), false);
        this.validateMutationResponse(tableCreationResponse, EntityMutations.EntityOperation.CREATE, 1);
        this.tblEntityGuid = ((AtlasEntityHeader)tableCreationResponse.getCreatedEntities().get(0)).getGuid();
        AtlasEntityHeader tableEntity = tableCreationResponse.getFirstCreatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.tblEntity, this.getEntityFromStore(tableEntity));
        this.init();
        EntityMutationResponse entityMutationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.nestedCollectionAttrEntity), false);
        this.validateMutationResponse(entityMutationResponse, EntityMutations.EntityOperation.CREATE, 1);
        AtlasEntityHeader createdEntity = entityMutationResponse.getFirstCreatedEntityByTypeName("entity_with_nested_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.nestedCollectionAttrEntity, this.getEntityFromStore(createdEntity));
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testArrayOfEntityUpdate() throws Exception {
        AtlasEntity tableEntity = new AtlasEntity(this.tblEntity.getEntity());
        ArrayList<AtlasObjectId> columns = new ArrayList<AtlasObjectId>();
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        AtlasEntity col1 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        col1.setAttribute("name", (Object)"col1");
        AtlasEntity col2 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        col2.setAttribute("name", (Object)"col2");
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col1));
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col2));
        tableEntity.setAttribute("columns", columns);
        entitiesInfo.addReferredEntity(this.dbEntity.getEntity());
        entitiesInfo.addReferredEntity(col1);
        entitiesInfo.addReferredEntity(col2);
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader updatedTableHeader = response.getFirstUpdatedEntityByTypeName(tableEntity.getTypeName());
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTableHeader));
        AtlasEntity col3 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        col3.setAttribute("name", (Object)"col3");
        AtlasEntity col4 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        col4.setAttribute("name", (Object)"col4");
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col3));
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col4));
        tableEntity.setAttribute("columns", columns);
        entitiesInfo.addReferredEntity(col3);
        entitiesInfo.addReferredEntity(col4);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTableHeader = response.getFirstUpdatedEntityByTypeName(tableEntity.getTypeName());
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTableHeader));
        columns.clear();
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col4));
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col3));
        tableEntity.setAttribute("columns", columns);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTableHeader = response.getFirstUpdatedEntityByTypeName(tableEntity.getTypeName());
        AtlasEntity updatedEntity = this.getEntityFromStore(updatedTableHeader);
        Assert.assertTrue((((List)updatedEntity.getAttribute("columns")).size() >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((int)response.getEntitiesByOperation(EntityMutations.EntityOperation.DELETE).size(), (int)2);
        tableEntity.setAttribute("columns", null);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTableHeader = response.getFirstUpdatedEntityByTypeName(tableEntity.getTypeName());
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTableHeader));
        Assert.assertEquals((int)response.getEntitiesByOperation(EntityMutations.EntityOperation.DELETE).size(), (int)2);
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testUpdateEntityWithMap() throws Exception {
        AtlasEntity tableEntity = new AtlasEntity(this.tblEntity.getEntity());
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        HashMap<String, AtlasStruct> partsMap = new HashMap<String, AtlasStruct>();
        partsMap.put("part0", new AtlasStruct("partition_struct_type", "name", (Object)"test"));
        tableEntity.setAttribute("partitionsMap", partsMap);
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition1 = response.getFirstUpdatedEntityByTypeName("hive_table");
        AtlasEntity updatedTableDef1 = this.getEntityFromStore(tableDefinition1);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, updatedTableDef1);
        Assert.assertTrue((boolean)((AtlasStruct)partsMap.get("part0")).equals(((Map)updatedTableDef1.getAttribute("partitionsMap")).get("part0")));
        partsMap.put("part1", new AtlasStruct("partition_struct_type", "name", (Object)"test1"));
        tableEntity.setAttribute("partitionsMap", partsMap);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition2 = response.getFirstUpdatedEntityByTypeName("hive_table");
        AtlasEntity updatedTableDef2 = this.getEntityFromStore(tableDefinition2);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, updatedTableDef2);
        Assert.assertEquals((int)((Map)updatedTableDef2.getAttribute("partitionsMap")).size(), (int)2);
        Assert.assertTrue((boolean)((AtlasStruct)partsMap.get("part1")).equals(((Map)updatedTableDef2.getAttribute("partitionsMap")).get("part1")));
        partsMap.remove("part0");
        partsMap.put("part2", new AtlasStruct("partition_struct_type", "name", (Object)"test2"));
        tableEntity.setAttribute("partitionsMap", partsMap);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition3 = response.getFirstUpdatedEntityByTypeName("hive_table");
        AtlasEntity updatedTableDef3 = this.getEntityFromStore(tableDefinition3);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, updatedTableDef3);
        Assert.assertEquals((int)((Map)updatedTableDef3.getAttribute("partitionsMap")).size(), (int)2);
        Assert.assertNull(((Map)updatedTableDef3.getAttribute("partitionsMap")).get("part0"));
        Assert.assertTrue((boolean)((AtlasStruct)partsMap.get("part2")).equals(((Map)updatedTableDef3.getAttribute("partitionsMap")).get("part2")));
        AtlasStruct partition2 = (AtlasStruct)partsMap.get("part2");
        partition2.setAttribute("name", (Object)"test2Updated");
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition4 = response.getFirstUpdatedEntityByTypeName("hive_table");
        AtlasEntity updatedTableDef4 = this.getEntityFromStore(tableDefinition4);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, updatedTableDef4);
        Assert.assertEquals((int)((Map)updatedTableDef4.getAttribute("partitionsMap")).size(), (int)2);
        Assert.assertNull(((Map)updatedTableDef4.getAttribute("partitionsMap")).get("part0"));
        Assert.assertTrue((boolean)((AtlasStruct)partsMap.get("part2")).equals(((Map)updatedTableDef4.getAttribute("partitionsMap")).get("part2")));
        AtlasEntity col0 = new AtlasEntity("column_type", "name", (Object)"test1");
        col0.setAttribute("type", (Object)"string");
        col0.setAttribute("table", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)tableEntity));
        AtlasEntity.AtlasEntityWithExtInfo col0WithExtendedInfo = new AtlasEntity.AtlasEntityWithExtInfo(col0);
        col0WithExtendedInfo.addReferredEntity(tableEntity);
        col0WithExtendedInfo.addReferredEntity(this.dbEntity.getEntity());
        this.init();
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(col0WithExtendedInfo), false);
        AtlasEntity col1 = new AtlasEntity("column_type", "name", (Object)"test2");
        col1.setAttribute("type", (Object)"string");
        col1.setAttribute("table", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)tableEntity));
        AtlasEntity.AtlasEntityWithExtInfo col1WithExtendedInfo = new AtlasEntity.AtlasEntityWithExtInfo(col1);
        col1WithExtendedInfo.addReferredEntity(tableEntity);
        col1WithExtendedInfo.addReferredEntity(this.dbEntity.getEntity());
        this.init();
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(col1WithExtendedInfo), false);
        HashMap<String, AtlasObjectId> columnsMap = new HashMap<String, AtlasObjectId>();
        columnsMap.put("col0", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col0));
        columnsMap.put("col1", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col1));
        tableEntity.setAttribute("columnsMap", columnsMap);
        entitiesInfo.addReferredEntity(col0);
        entitiesInfo.addReferredEntity(col1);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition5 = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(tableDefinition5));
        columnsMap.clear();
        columnsMap.put("col0", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col1));
        columnsMap.put("col1", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col0));
        tableEntity.setAttribute("columnsMap", columnsMap);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition6 = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(tableDefinition6));
        Assert.assertEquals((Object)this.entityStore.getById(col0.getGuid()).getEntity().getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        Assert.assertEquals((Object)this.entityStore.getById(col1.getGuid()).getEntity().getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        columnsMap.clear();
        columnsMap.put("col0", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col0));
        tableEntity.setAttribute("columnsMap", columnsMap);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition7 = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(tableDefinition7));
        tableEntity.setAttribute("columnsMap", null);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader tableDefinition8 = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(tableDefinition8));
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testMapOfPrimitivesUpdate() throws Exception {
        AtlasEntity tableEntity = new AtlasEntity(this.tblEntity.getEntity());
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        entitiesInfo.addReferredEntity(tableEntity);
        Map paramsMap = (Map)tableEntity.getAttribute("parametersMap");
        paramsMap.put("newParam", "value");
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        this.validateMutationResponse(response, EntityMutations.EntityOperation.UPDATE, 1);
        AtlasEntityHeader updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        paramsMap.remove("key1");
        tableEntity.setAttribute("parametersMap", (Object)paramsMap);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        this.validateMutationResponse(response, EntityMutations.EntityOperation.UPDATE, 1);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testArrayOfStructs() throws Exception {
        AtlasEntity tableEntity = new AtlasEntity(this.tblEntity.getEntity());
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        ArrayList<AtlasStruct> partitions = new ArrayList<AtlasStruct>(){
            {
                this.add(new AtlasStruct("partition_struct_type", "name", (Object)"part1"));
                this.add(new AtlasStruct("partition_struct_type", "name", (Object)"part2"));
            }
        };
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        partitions.add(new AtlasStruct("partition_struct_type", "name", (Object)"part3"));
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        partitions.remove(1);
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        ((AtlasStruct)partitions.get(0)).setAttribute("name", (Object)"part4");
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        partitions.add(new AtlasStruct("partition_struct_type", "name", (Object)"part4"));
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        partitions.clear();
        tableEntity.setAttribute("partitions", (Object)partitions);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testStructs() throws Exception {
        AtlasEntity databaseEntity = this.dbEntity.getEntity();
        AtlasEntity tableEntity = new AtlasEntity(this.tblEntity.getEntity());
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        AtlasStruct serdeInstance = new AtlasStruct("serdeType", "name", (Object)"serde1Name");
        serdeInstance.setAttribute("serde", (Object)"test");
        serdeInstance.setAttribute("description", (Object)"testDesc");
        tableEntity.setAttribute("serde1", (Object)serdeInstance);
        tableEntity.setAttribute("database", (Object)new AtlasObjectId(databaseEntity.getTypeName(), "name", databaseEntity.getAttribute("name")));
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        serdeInstance.setAttribute("serde", (Object)"testUpdated");
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
        tableEntity.setAttribute("description", null);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        updatedTable = response.getFirstUpdatedEntityByTypeName("hive_table");
        Assert.assertNull((Object)updatedTable.getAttribute("description"));
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entitiesInfo, this.getEntityFromStore(updatedTable));
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testClassUpdate() throws Exception {
        this.init();
        AtlasEntity databaseInstance = TestUtilsV2.createDBEntity();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(databaseInstance), false);
        AtlasEntityHeader dbCreated = response.getFirstCreatedEntityByTypeName("hive_database");
        this.init();
        HashMap<String, AtlasEntity> tableCloneMap = new HashMap<String, AtlasEntity>();
        AtlasEntity tableClone = new AtlasEntity(this.tblEntity.getEntity());
        tableClone.setAttribute("database", (Object)new AtlasObjectId(dbCreated.getGuid(), "hive_database"));
        tableCloneMap.put(dbCreated.getGuid(), databaseInstance);
        tableCloneMap.put(tableClone.getGuid(), tableClone);
        response = this.entityStore.createOrUpdate((EntityStream)new InMemoryMapEntityStream(tableCloneMap), false);
        AtlasEntityHeader tableDefinition = response.getFirstUpdatedEntityByTypeName("hive_table");
        AtlasEntity updatedTableDefinition = this.getEntityFromStore(tableDefinition);
        Assert.assertNotNull((Object)updatedTableDefinition.getAttribute("database"));
        Assert.assertEquals((String)((AtlasObjectId)updatedTableDefinition.getAttribute("database")).getGuid(), (String)dbCreated.getGuid());
    }

    @Test
    public void testCheckOptionalAttrValueRetention() throws Exception {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
        AtlasEntity firstEntityCreated = this.getEntityFromStore(response.getFirstCreatedEntityByTypeName("hive_database"));
        String isReplicatedAttr = "isReplicated";
        String paramsAttr = "parameters";
        Assert.assertNotNull((Object)firstEntityCreated.getAttribute("isReplicated"));
        Assert.assertEquals((Object)firstEntityCreated.getAttribute("isReplicated"), (Object)Boolean.FALSE);
        Assert.assertNull((Object)firstEntityCreated.getAttribute("parameters"));
        dbEntity.setAttribute("isReplicated", (Object)Boolean.TRUE);
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("param1", "val1");
                this.put("param2", "val2");
            }
        };
        dbEntity.setAttribute("parameters", (Object)params);
        this.init();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
        AtlasEntity firstEntityUpdated = this.getEntityFromStore(response.getFirstUpdatedEntityByTypeName("hive_database"));
        Assert.assertNotNull((Object)firstEntityUpdated);
        Assert.assertNotNull((Object)firstEntityUpdated.getAttribute("isReplicated"));
        Assert.assertEquals((Object)firstEntityUpdated.getAttribute("isReplicated"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)firstEntityUpdated.getAttribute("parameters"), (Object)params);
    }

    @Test(enabled=false)
    public void testSpecialCharacters() throws Exception {
        String typeName = TestUtilsV2.randomString((int)10);
        String strAttrName = this.randomStrWithReservedChars();
        String arrayAttrName = this.randomStrWithReservedChars();
        String mapAttrName = this.randomStrWithReservedChars();
        AtlasEntityDef typeDefinition = AtlasTypeUtil.createClassTypeDef((String)typeName, (String)"Special chars test type", (Set)ImmutableSet.of(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)strAttrName, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)arrayAttrName, (String)"array<string>"), AtlasTypeUtil.createOptionalAttrDef((String)mapAttrName, (String)"map<string,string>")});
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef(null, null, null, Arrays.asList(typeDefinition));
        this.typeDefStore.createTypesDef(atlasTypesDef);
        AtlasEntity entity = new AtlasEntity();
        entity.setAttribute(strAttrName, (Object)this.randomStrWithReservedChars());
        entity.setAttribute(arrayAttrName, (Object)new String[]{this.randomStrWithReservedChars()});
        entity.setAttribute(mapAttrName, (Object)new HashMap<String, String>(){
            {
                this.put(AtlasEntityStoreV2Test.this.randomStrWithReservedChars(), AtlasEntityStoreV2Test.this.randomStrWithReservedChars());
            }
        });
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo(entity);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entityWithExtInfo), false);
        AtlasEntityHeader firstEntityCreated = response.getFirstEntityCreated();
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, this.getEntityFromStore(firstEntityCreated));
    }

    @Test(expectedExceptions={AtlasBaseException.class})
    public void testCreateRequiredAttrNull() throws Exception {
        HashMap<String, AtlasEntity> tableCloneMap = new HashMap<String, AtlasEntity>();
        AtlasEntity tableEntity = new AtlasEntity("hive_table");
        tableEntity.setAttribute("name", (Object)("table_" + TestUtilsV2.randomString()));
        tableCloneMap.put(tableEntity.getGuid(), tableEntity);
        this.entityStore.createOrUpdate((EntityStream)new InMemoryMapEntityStream(tableCloneMap), false);
        Assert.fail((String)"Expected exception while creating with required attribute null");
    }

    @Test
    public void testPartialUpdateAttr() throws Exception {
        this.init();
        AtlasEntity dbEntity = new AtlasEntity("hive_database");
        dbEntity.setAttribute("name", (Object)TestUtilsV2.randomString((int)10));
        dbEntity.setAttribute("description", (Object)"us db");
        dbEntity.setAttribute("isReplicated", (Object)false);
        dbEntity.setAttribute("created", (Object)"09081988");
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        dbEntity.setAttribute("colo", (Object)"10001");
        AtlasEntityStream dbStream = new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(dbEntity));
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)dbStream, false);
        AtlasEntityHeader dbHeader = response.getFirstEntityCreated();
        AtlasEntity createdDbEntity = this.getEntityFromStore(dbHeader);
        dbEntity = new AtlasEntity("hive_database");
        dbEntity.setGuid(createdDbEntity.getGuid());
        dbEntity.setAttribute("created", (Object)"08151947");
        dbEntity.setAttribute("isReplicated", (Object)true);
        dbStream = new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(dbEntity));
        try {
            this.entityStore.createOrUpdate((EntityStream)dbStream, false);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS);
        }
        dbStream.reset();
        response = this.entityStore.createOrUpdate((EntityStream)dbStream, true);
        dbHeader = response.getFirstEntityPartialUpdated();
        AtlasEntity updatedDbEntity = this.getEntityFromStore(dbHeader);
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("name"), (Object)createdDbEntity.getAttribute("name"));
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("description"), (Object)createdDbEntity.getAttribute("description"));
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("isReplicated"), (Object)true);
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("created"), (Object)"08151947");
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("namespace"), (Object)createdDbEntity.getAttribute("namespace"));
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("cluster"), (Object)createdDbEntity.getAttribute("cluster"));
        Assert.assertEquals((Object)updatedDbEntity.getAttribute("colo"), (Object)createdDbEntity.getAttribute("colo"));
        AtlasEntity tblEntity = new AtlasEntity("hive_table");
        tblEntity.setAttribute("name", (Object)TestUtilsV2.randomString((int)10));
        tblEntity.setAttribute("type", (Object)"type");
        tblEntity.setAttribute("tableType", (Object)"MANAGED");
        tblEntity.setAttribute("database", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)updatedDbEntity));
        AtlasEntity col1 = TestUtilsV2.createColumnEntity((AtlasEntity)tblEntity);
        AtlasEntity col2 = TestUtilsV2.createColumnEntity((AtlasEntity)tblEntity);
        col1.setAttribute("name", (Object)"col1");
        col2.setAttribute("name", (Object)"col2");
        List<AtlasObjectId> columns = new ArrayList<AtlasObjectId>();
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col1));
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col2));
        tblEntity.setAttribute("columns", columns);
        AtlasEntity.AtlasEntitiesWithExtInfo tableEntityInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tblEntity);
        tableEntityInfo.addReferredEntity(col1.getGuid(), col1);
        tableEntityInfo.addReferredEntity(col2.getGuid(), col2);
        AtlasEntityStream tblStream = new AtlasEntityStream(tableEntityInfo);
        response = this.entityStore.createOrUpdate((EntityStream)tblStream, false);
        AtlasEntityHeader tblHeader = response.getFirstEntityCreated();
        AtlasEntity createdTblEntity = this.getEntityFromStore(tblHeader);
        columns = (List)createdTblEntity.getAttribute("columns");
        Assert.assertEquals((int)columns.size(), (int)2);
        AtlasEntity col3 = TestUtilsV2.createColumnEntity((AtlasEntity)createdTblEntity);
        col3.setAttribute("name", (Object)"col3");
        col3.setAttribute("description", (Object)"description col3");
        AtlasEntity col4 = TestUtilsV2.createColumnEntity((AtlasEntity)createdTblEntity);
        col4.setAttribute("name", (Object)"col4");
        col4.setAttribute("description", (Object)"description col4");
        columns.clear();
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col3));
        columns.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col4));
        tblEntity = new AtlasEntity("hive_table");
        tblEntity.setGuid(createdTblEntity.getGuid());
        tblEntity.setAttribute("columns", columns);
        tableEntityInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tblEntity);
        tableEntityInfo.addReferredEntity(col3.getGuid(), col3);
        tableEntityInfo.addReferredEntity(col4.getGuid(), col4);
        tblStream = new AtlasEntityStream(tableEntityInfo);
        response = this.entityStore.createOrUpdate((EntityStream)tblStream, true);
        tblHeader = response.getFirstEntityPartialUpdated();
        AtlasEntity updatedTblEntity = this.getEntityFromStore(tblHeader);
        columns = (List)updatedTblEntity.getAttribute("columns");
        Assert.assertTrue((columns.size() >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testPartialUpdateArrayAttr() throws Exception {
        this.init();
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        EntityMutationResponse dbCreationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity);
        AtlasEntity columnEntity1 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        columnEntity1.setAttribute("description", (Object)"desc for col1");
        entitiesInfo.addReferredEntity(columnEntity1);
        AtlasEntity columnEntity2 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        columnEntity2.setAttribute("description", (Object)"desc for col2");
        entitiesInfo.addReferredEntity(columnEntity2);
        AtlasEntity columnEntity3 = TestUtilsV2.createColumnEntity((AtlasEntity)tableEntity);
        columnEntity3.setAttribute("description", (Object)"desc for col3");
        entitiesInfo.addReferredEntity(columnEntity3);
        tableEntity.setAttribute("columns", Arrays.asList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)columnEntity1), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)columnEntity2), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)columnEntity3)));
        this.init();
        EntityMutationResponse tblCreationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), false);
        AtlasEntityHeader createdTblHeader = tblCreationResponse.getCreatedEntityByTypeNameAndAttribute("hive_table", "name", (String)tableEntity.getAttribute("name"));
        AtlasEntity createdTblEntity = this.getEntityFromStore(createdTblHeader);
        AtlasEntityHeader column1Created = tblCreationResponse.getCreatedEntityByTypeNameAndAttribute("column_type", "name", (String)columnEntity1.getAttribute("name"));
        AtlasEntityHeader column2Created = tblCreationResponse.getCreatedEntityByTypeNameAndAttribute("column_type", "name", (String)columnEntity2.getAttribute("name"));
        AtlasEntityHeader column3Created = tblCreationResponse.getCreatedEntityByTypeNameAndAttribute("column_type", "name", (String)columnEntity3.getAttribute("name"));
        AtlasEntity col1 = new AtlasEntity("column_type");
        col1.setGuid(column1Created.getGuid());
        col1.setAttribute("description", (Object)"desc for col1:updated");
        AtlasEntity col2 = new AtlasEntity("column_type");
        col2.setGuid(column2Created.getGuid());
        col2.setAttribute("description", (Object)"desc for col2:updated");
        AtlasEntity col3 = new AtlasEntity("column_type");
        col3.setGuid(column3Created.getGuid());
        col3.setAttribute("description", (Object)"desc for col3:updated");
        AtlasEntity tableEntity1 = new AtlasEntity("hive_table");
        tableEntity1.setGuid(createdTblHeader.getGuid());
        tableEntity1.setAttribute("columns", Arrays.asList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col1), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col2), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)col3)));
        AtlasEntity.AtlasEntitiesWithExtInfo tableInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tableEntity1);
        tableInfo.addReferredEntity(col1.getGuid(), col1);
        tableInfo.addReferredEntity(col2.getGuid(), col2);
        tableInfo.addReferredEntity(col3.getGuid(), col3);
        this.init();
        EntityMutationResponse tblUpdateResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tableInfo), true);
        AtlasEntityHeader updatedTblHeader = tblUpdateResponse.getFirstEntityPartialUpdated();
        AtlasEntity updatedTblEntity2 = this.getEntityFromStore(updatedTblHeader);
        List updatedColHeaders = tblUpdateResponse.getPartialUpdatedEntitiesByTypeName("column_type");
        AtlasEntity updatedCol1Entity = this.getEntityFromStore((AtlasEntityHeader)updatedColHeaders.get(0));
        AtlasEntity updatedCol2Entity = this.getEntityFromStore((AtlasEntityHeader)updatedColHeaders.get(1));
        AtlasEntity updatedCol3Entity = this.getEntityFromStore((AtlasEntityHeader)updatedColHeaders.get(2));
        Assert.assertEquals((Object)col1.getAttribute("description"), (Object)updatedCol1Entity.getAttribute("description"));
        Assert.assertEquals((Object)col2.getAttribute("description"), (Object)updatedCol2Entity.getAttribute("description"));
        Assert.assertEquals((Object)col3.getAttribute("description"), (Object)updatedCol3Entity.getAttribute("description"));
    }

    @Test
    public void testDifferentialEntitiesOnUpdate() throws Exception {
        ApplicationProperties.get().setProperty(AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getPropertyName(), (Object)true);
        this.init();
        AtlasEntity dbEntity = new AtlasEntity("hive_database");
        dbEntity.setAttribute("name", (Object)TestUtilsV2.randomString((int)10));
        dbEntity.setAttribute("description", (Object)"us db");
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        AtlasEntityStream dbStream = new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(dbEntity));
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)dbStream, false);
        AtlasEntityHeader dbHeader = response.getFirstEntityCreated();
        AtlasEntity createdDbEntity = this.getEntityFromStore(dbHeader);
        Assert.assertEquals((int)RequestContext.get().getDifferentialEntities().size(), (int)0);
        dbEntity = new AtlasEntity("hive_database");
        dbEntity.setGuid(createdDbEntity.getGuid());
        dbEntity.setAttribute("description", (Object)"new description");
        dbStream = new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(dbEntity));
        response = this.entityStore.createOrUpdate((EntityStream)dbStream, true);
        dbHeader = response.getFirstEntityPartialUpdated();
        AtlasEntity updatedDbEntity = this.getEntityFromStore(dbHeader);
        Assert.assertEquals((int)RequestContext.get().getDifferentialEntities().size(), (int)1);
        AtlasEntity diffEntity = RequestContext.get().getDifferentialEntity(updatedDbEntity.getGuid());
        Assert.assertNotNull((Object)diffEntity.getAttribute("description"));
        Assert.assertNull((Object)diffEntity.getAttribute("namespace"));
        Assert.assertNull((Object)diffEntity.getAttribute("name"));
        ApplicationProperties.get().setProperty(AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getPropertyName(), (Object)false);
    }

    @Test
    public void testSetObjectIdAttrToNull() throws Exception {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        AtlasEntity db2Entity = TestUtilsV2.createDBEntity();
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(db2Entity), false);
        GraphTransactionInterceptor.clearCache();
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        tableEntity.setAttribute("databaseComposite", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)db2Entity));
        EntityMutationResponse tblCreationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tableEntity), false);
        AtlasEntityHeader createdTblHeader = tblCreationResponse.getCreatedEntityByTypeNameAndAttribute("hive_table", "name", (String)tableEntity.getAttribute("name"));
        AtlasEntity createdTblEntity = this.getEntityFromStore(createdTblHeader);
        this.init();
        createdTblEntity.setAttribute("databaseComposite", null);
        EntityMutationResponse tblUpdateResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(createdTblEntity), true);
        GraphTransactionInterceptor.clearCache();
        AtlasEntityHeader updatedTblHeader = tblUpdateResponse.getFirstEntityPartialUpdated();
        AtlasEntity updatedTblEntity = this.getEntityFromStore(updatedTblHeader);
        AtlasEntity deletedDb2Entity = this.getEntityFromStore(db2Entity.getGuid());
        Assert.assertEquals((Object)deletedDb2Entity.getStatus(), (Object)AtlasEntity.Status.DELETED);
    }

    @Test
    public void testTagAssociationAfterRedefinition() {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        this.getTagWithName(typesDef, "testTag", "int");
        try {
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag creation should've succeeded");
        }
        try {
            this.typeDefStore.deleteTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag deletion should've succeeded");
        }
        AtlasClassificationDef aTag = this.getTagWithName(typesDef, "testTag", "string");
        try {
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag re-creation should've succeeded");
        }
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        try {
            EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
            List createdEntity = response.getCreatedEntities();
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)createdEntity));
            String guid = ((AtlasEntityHeader)createdEntity.get(0)).getGuid();
            this.entityStore.addClassification(Arrays.asList(guid), new AtlasClassification(aTag.getName(), "testAttribute", (Object)"test-string"));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)("DB entity creation should've succeeded, e.getMessage() => " + e.getMessage()));
        }
    }

    @Test(dependsOnMethods={"testCreate"})
    public void associateMultipleTagsToOneEntity() throws AtlasBaseException {
        String TAG_NAME = "tag_xy";
        String TAG_NAME_2 = "tag_xy_2";
        String TAG_ATTRIBUTE_NAME = "testAttribute";
        String TAG_ATTRIBUTE_VALUE = "test-string";
        String TAG_ATTRIBUTE_VALUE_2 = "test-string-2";
        this.createTag("tag_xy", "string");
        this.createTag("tag_xy_2", "string");
        ArrayList<AtlasClassification> addedClassifications = new ArrayList<AtlasClassification>();
        addedClassifications.add(new AtlasClassification("tag_xy", "testAttribute", (Object)"test-string"));
        addedClassifications.add(new AtlasClassification("tag_xy_2", "testAttribute", (Object)"test-string-2"));
        this.entityStore.addClassifications(this.dbEntityGuid, addedClassifications);
        AtlasEntity dbEntityFromDb = this.getEntityFromStore(this.dbEntityGuid);
        List actualClassifications = (List)CollectionUtils.collect((Collection)dbEntityFromDb.getClassifications(), o -> ((AtlasClassification)o).getTypeName());
        HashSet classificationSet = new HashSet(actualClassifications);
        Assert.assertTrue((boolean)classificationSet.contains("tag_xy"));
        Assert.assertTrue((boolean)classificationSet.contains("tag_xy_2"));
        for (String actualClassificationName : actualClassifications) {
            this.entityStore.deleteClassification(this.dbEntityGuid, actualClassificationName);
        }
    }

    @Test
    public void testCreateWithDuplicateGuids() throws Exception {
        this.init();
        AtlasEntity.AtlasEntityWithExtInfo tblEntity2 = TestUtilsV2.createTableEntityDuplicatesV2((AtlasEntity)this.dbEntity.getEntity());
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity2), false);
        List createdEntities = response.getCreatedEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)createdEntities));
        Assert.assertEquals((int)createdEntities.size(), (int)2);
        String tableGuid = ((AtlasEntityHeader)createdEntities.get(0)).getGuid();
        AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.entityStore.getById(tableGuid);
        Assert.assertEquals((int)tableEntity.getReferredEntities().size(), (int)1);
        List columns = (List)tableEntity.getEntity().getAttribute("columns");
        Assert.assertEquals((int)columns.size(), (int)1);
        HashSet uniqueColumns = new HashSet(columns);
        Assert.assertTrue((uniqueColumns.size() == 1 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"testCreate"})
    public void associateSameTagToMultipleEntities() throws AtlasBaseException {
        String TAG_NAME = "tagx";
        String TAG_ATTRIBUTE_NAME = "testAttribute";
        String TAG_ATTRIBUTE_VALUE = "test-string";
        this.createTag("tagx", "string");
        ArrayList<AtlasClassification> addedClassifications = new ArrayList<AtlasClassification>();
        addedClassifications.add(new AtlasClassification("tagx", "testAttribute", (Object)"test-string"));
        this.entityStore.addClassifications(this.dbEntityGuid, addedClassifications);
        this.entityStore.addClassifications(this.tblEntityGuid, addedClassifications);
        AtlasEntity dbEntityFromDb = this.getEntityFromStore(this.dbEntityGuid);
        AtlasEntity tblEntityFromDb = this.getEntityFromStore(this.tblEntityGuid);
        HashSet actualDBClassifications = new HashSet(CollectionUtils.collect((Collection)dbEntityFromDb.getClassifications(), o -> ((AtlasClassification)o).getTypeName()));
        HashSet actualTblClassifications = new HashSet(CollectionUtils.collect((Collection)tblEntityFromDb.getClassifications(), o -> ((AtlasClassification)o).getTypeName()));
        Assert.assertTrue((boolean)actualDBClassifications.contains("tagx"));
        Assert.assertTrue((boolean)actualTblClassifications.contains("tagx"));
        HashSet actualDBAssociatedEntityGuid = new HashSet(CollectionUtils.collect((Collection)dbEntityFromDb.getClassifications(), o -> ((AtlasClassification)o).getEntityGuid()));
        HashSet actualTblAssociatedEntityGuid = new HashSet(CollectionUtils.collect((Collection)tblEntityFromDb.getClassifications(), o -> ((AtlasClassification)o).getEntityGuid()));
        Assert.assertTrue((boolean)actualDBAssociatedEntityGuid.contains(this.dbEntityGuid));
        Assert.assertTrue((boolean)actualTblAssociatedEntityGuid.contains(this.tblEntityGuid));
        this.entityStore.deleteClassification(this.dbEntityGuid, "tagx");
        this.entityStore.deleteClassification(this.tblEntityGuid, "tagx");
    }

    @Test(dependsOnMethods={"testCreate"})
    public void addCustomAttributesToEntity() throws Exception {
        ApplicationProperties.get().setProperty(AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getPropertyName(), (Object)true);
        this.init();
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        customAttributes.put("key1", "val1");
        customAttributes.put("key2", "val2");
        customAttributes.put("key3", "val3");
        customAttributes.put("key4", "val4");
        customAttributes.put("key5", "val5");
        tblEntity.setCustomAttributes(customAttributes);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        Assert.assertEquals((int)RequestContext.get().getDifferentialEntities().size(), (int)1);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(customAttributes, (Map)tblEntity.getCustomAttributes());
        ApplicationProperties.get().setProperty(AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getPropertyName(), (Object)false);
    }

    @Test(dependsOnMethods={"addCustomAttributesToEntity"})
    public void updateCustomAttributesToEntity() throws AtlasBaseException {
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        customAttributes.put("key1", "val1");
        customAttributes.put("key2", "val2");
        tblEntity.setCustomAttributes(customAttributes);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(customAttributes, (Map)tblEntity.getCustomAttributes());
    }

    @Test(dependsOnMethods={"updateCustomAttributesToEntity"})
    public void deleteCustomAttributesToEntity() throws AtlasBaseException {
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap emptyCustomAttributes = new HashMap();
        tblEntity.setCustomAttributes(emptyCustomAttributes);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(emptyCustomAttributes, (Map)tblEntity.getCustomAttributes());
    }

    @Test(dependsOnMethods={"deleteCustomAttributesToEntity"})
    public void nullCustomAttributesToEntity() throws AtlasBaseException {
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        customAttributes.put("key1", "val1");
        customAttributes.put("key2", "val2");
        tblEntity.setCustomAttributes(customAttributes);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        tblEntity.setCustomAttributes(null);
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(customAttributes, (Map)tblEntity.getCustomAttributes());
    }

    @Test(dependsOnMethods={"nullCustomAttributesToEntity"})
    public void addInvalidKeysToEntityCustomAttributes() throws AtlasBaseException {
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap<String, String> invalidCustomAttributes = new HashMap<String, String>();
        invalidCustomAttributes.put("key0_65765-6565", "val0");
        invalidCustomAttributes.put("key1-aaa_bbb-ccc", "val1");
        invalidCustomAttributes.put("key2!@#$%&*()", "val2");
        tblEntity.setCustomAttributes(invalidCustomAttributes);
        try {
            this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_KEY_CHARACTERS);
        }
        invalidCustomAttributes = new HashMap();
        invalidCustomAttributes.put("bigValue_lengthEquals_50", RandomStringUtils.randomAlphanumeric((int)50));
        invalidCustomAttributes.put("bigValue_lengthEquals_51", RandomStringUtils.randomAlphanumeric((int)51));
        tblEntity.setCustomAttributes(invalidCustomAttributes);
        try {
            this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_KEY_LENGTH);
        }
    }

    @Test(dependsOnMethods={"addInvalidKeysToEntityCustomAttributes"})
    public void addInvalidValuesToEntityCustomAttributes() throws AtlasBaseException {
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        HashMap<String, String> invalidCustomAttributes = new HashMap<String, String>();
        invalidCustomAttributes.put("key1", RandomStringUtils.randomAlphanumeric((int)500));
        invalidCustomAttributes.put("key2", RandomStringUtils.randomAlphanumeric((int)501));
        tblEntity.setCustomAttributes(invalidCustomAttributes);
        try {
            this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(tblEntity), false);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_CUSTOM_ATTRIBUTE_VALUE);
        }
    }

    @Test(dependsOnMethods={"testCreate"})
    public void addLabelsToEntity() throws AtlasBaseException {
        HashSet<String> labels = new HashSet<String>();
        labels.add("label_1");
        labels.add("label_2");
        labels.add("label_3");
        labels.add("label_4");
        labels.add("label_5");
        this.entityStore.setLabels(this.tblEntityGuid, labels);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(labels, (Set)tblEntity.getLabels());
    }

    @Test(dependsOnMethods={"addLabelsToEntity"})
    public void updateLabelsToEntity() throws AtlasBaseException {
        HashSet<String> labels = new HashSet<String>();
        labels.add("label_1_update");
        labels.add("label_2_update");
        labels.add("label_3_update");
        this.entityStore.setLabels(this.tblEntityGuid, labels);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertEquals(labels, (Set)tblEntity.getLabels());
    }

    @Test(dependsOnMethods={"updateLabelsToEntity"})
    public void clearLabelsToEntity() throws AtlasBaseException {
        HashSet emptyLabels = new HashSet();
        this.entityStore.setLabels(this.tblEntityGuid, emptyLabels);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertTrue((boolean)tblEntity.getLabels().isEmpty());
    }

    @Test(dependsOnMethods={"clearLabelsToEntity"})
    public void emptyLabelsToEntity() throws AtlasBaseException {
        this.entityStore.setLabels(this.tblEntityGuid, null);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertTrue((boolean)tblEntity.getLabels().isEmpty());
    }

    @Test(dependsOnMethods={"emptyLabelsToEntity"})
    public void invalidLabelLengthToEntity() throws AtlasBaseException {
        HashSet<String> labels = new HashSet<String>();
        labels.add(RandomStringUtils.randomAlphanumeric((int)50));
        labels.add(RandomStringUtils.randomAlphanumeric((int)51));
        try {
            this.entityStore.setLabels(this.tblEntityGuid, labels);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_LABEL_LENGTH);
        }
    }

    @Test(dependsOnMethods={"invalidLabelLengthToEntity"})
    public void invalidLabelCharactersToEntity() {
        HashSet<String> labels = new HashSet<String>();
        labels.add("label-1_100_45");
        labels.add("LABEL-1_200-55");
        labels.add("LaBeL-1-)(*U&%^%#$@!~");
        try {
            this.entityStore.setLabels(this.tblEntityGuid, labels);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_LABEL_CHARACTERS);
        }
    }

    @Test(dependsOnMethods={"invalidLabelCharactersToEntity"})
    public void addMoreLabelsToEntity() throws AtlasBaseException {
        HashSet<String> labels = new HashSet<String>();
        labels.add("label_1_add");
        labels.add("label_2_add");
        labels.add("label_3_add");
        this.entityStore.addLabels(this.tblEntityGuid, labels);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertTrue((boolean)tblEntity.getLabels().containsAll(labels));
        tblEntity.setAttribute("description", (Object)"tbl for labels");
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(tblEntity);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), true);
        this.validateMutationResponse(response, EntityMutations.EntityOperation.PARTIAL_UPDATE, 1);
        tblEntity = this.getEntityFromStore(response.getFirstEntityPartialUpdated());
        Assert.assertEquals((Set)tblEntity.getLabels(), labels);
    }

    @Test(dependsOnMethods={"addMoreLabelsToEntity"})
    public void deleteLabelsToEntity() throws AtlasBaseException {
        HashSet<String> labels = new HashSet<String>();
        labels.add("label_1_add");
        labels.add("label_2_add");
        this.entityStore.removeLabels(this.tblEntityGuid, labels);
        AtlasEntity tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertNotNull((Object)tblEntity.getLabels());
        Assert.assertEquals((int)tblEntity.getLabels().size(), (int)1);
        labels.clear();
        labels.add("label_4_add");
        this.entityStore.removeLabels(this.tblEntityGuid, labels);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertNotNull((Object)tblEntity.getLabels());
        Assert.assertEquals((int)tblEntity.getLabels().size(), (int)1);
        labels.clear();
        labels.add("label_3_add");
        this.entityStore.removeLabels(this.tblEntityGuid, labels);
        tblEntity = this.getEntityFromStore(this.tblEntityGuid);
        Assert.assertTrue((boolean)tblEntity.getLabels().isEmpty());
    }

    @Test
    public void testAddBusinessAttributesStringMaxLengthCheck() throws Exception {
        HashMap bmMapReq = new HashMap();
        HashMap<String, String> bmAttrMapReq = new HashMap<String, String>();
        bmAttrMapReq.put("attr8", "01234567890123456789");
        bmMapReq.put("bmWithAllTypes", bmAttrMapReq);
        this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmMapReq, false);
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getById(this.dbEntity.getEntity().getGuid());
        Map bmMapRes = entity.getEntity().getBusinessAttributes();
        Assert.assertEquals(bmMapReq, (Map)bmMapRes);
    }

    @Test
    public void testAddBusinessAttributesStringMaxLengthCheck_2() throws Exception {
        HashMap bmMapReq = new HashMap();
        HashMap<String, String> bmAttrMapReq = new HashMap<String, String>();
        bmAttrMapReq.put("attr8", "012345678901234567890");
        bmMapReq.put("bmWithAllTypes", bmAttrMapReq);
        try {
            this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmMapReq, false);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, (Object)e.getAtlasErrorCode());
            return;
        }
        Assert.fail();
    }

    @Test(dependsOnMethods={"testAddBusinessAttributesStringMaxLengthCheck"})
    public void testUpdateBusinessAttributesStringMaxLengthCheck() throws Exception {
        HashMap bmMapReq = new HashMap();
        HashMap<String, String> bmAttrMapReq = new HashMap<String, String>();
        bmAttrMapReq.put("attr8", "0123456789");
        bmMapReq.put("bmWithAllTypes", bmAttrMapReq);
        this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmMapReq, true);
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getById(this.dbEntity.getEntity().getGuid());
        Map bmMapRes = entity.getEntity().getBusinessAttributes();
        Assert.assertEquals(bmMapReq, (Map)bmMapRes);
    }

    @Test(dependsOnMethods={"testAddBusinessAttributesStringMaxLengthCheck"})
    public void testUpdateBusinessAttributesStringMaxLengthCheck_2() throws Exception {
        HashMap bmMapReq = new HashMap();
        HashMap<String, String> bmAttrMapReq = new HashMap<String, String>();
        bmAttrMapReq.put("attr8", "012345678901234567890");
        bmMapReq.put("bmWithAllTypes", bmAttrMapReq);
        try {
            this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmMapReq, true);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, (Object)e.getAtlasErrorCode());
            return;
        }
        Assert.fail();
    }

    @Test(dependsOnMethods={"testAddBusinessAttributesStringMaxLengthCheck"})
    public void testUpdateBusinessAttributesStringMaxLengthCheck_3() throws Exception {
        HashMap bmAttrMapReq = new HashMap();
        HashMap attrValueMapReq = new HashMap();
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("0123456789");
        stringList.add("0123456789");
        attrValueMapReq.put("attr18", stringList);
        bmAttrMapReq.put("bmWithAllTypesMV", attrValueMapReq);
        this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmAttrMapReq, true);
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getById(this.dbEntity.getEntity().getGuid());
        Map bmAttrMapRes = entity.getEntity().getBusinessAttributes();
        Assert.assertEquals(bmAttrMapReq, (Map)bmAttrMapRes);
    }

    @Test(dependsOnMethods={"testAddBusinessAttributesStringMaxLengthCheck"})
    public void testUpdateBusinessAttributesStringMaxLengthCheck_4() throws Exception {
        HashMap bmAttrMapReq = new HashMap();
        HashMap attrValueMapReq = new HashMap();
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("0123456789");
        stringList.add("012345678901234567890");
        attrValueMapReq.put("attr18", stringList);
        bmAttrMapReq.put("bmWithAllTypesMV", attrValueMapReq);
        try {
            this.entityStore.addOrUpdateBusinessAttributes(this.dbEntity.getEntity().getGuid(), bmAttrMapReq, true);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, (Object)e.getAtlasErrorCode());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testGetTemplate() {
        try {
            String bMHeaderListAsString = FileUtils.getBusinessMetadataHeaders();
            Assert.assertNotNull((Object)bMHeaderListAsString);
            Assert.assertEquals((String)bMHeaderListAsString, (String)"EntityType,EntityUniqueAttributeValue,BusinessAttributeName,BusinessAttributeValue,EntityUniqueAttributeName[optional]");
        }
        catch (Exception e) {
            Assert.fail((String)"The Template for BussinessMetadata Attributes should've been a success : ", (Throwable)e);
        }
    }

    @Test
    public void testEmptyFileException() {
        InputStream inputStream = TestUtilsV2.getFile((String)CSV_FILES, (String)"empty.csv");
        try {
            this.entityStore.bulkCreateOrUpdateBusinessAttributes(inputStream, "empty.csv");
            Assert.fail((String)"Error occurred : Failed to recognize the empty file.");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"No data found in the uploaded file");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testBulkAddOrUpdateBusinessAttributes() {
        try {
            AtlasEntity hive_db_1 = this.getEntityFromStore(this.dbEntityGuid);
            String dbName = (String)hive_db_1.getAttribute("name");
            String data = TestUtilsV2.getFileData((String)CSV_FILES, (String)"template_2.csv");
            data = data.replaceAll("hive_db_1", dbName);
            ByteArrayInputStream inputStream1 = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            BulkImportResponse bulkImportResponse = this.entityStore.bulkCreateOrUpdateBusinessAttributes((InputStream)inputStream1, "template_2.csv");
            Assert.assertEquals((boolean)CollectionUtils.isEmpty((Collection)bulkImportResponse.getSuccessImportInfoList()), (boolean)false);
            Assert.assertEquals((boolean)CollectionUtils.isEmpty((Collection)bulkImportResponse.getFailedImportInfoList()), (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)("The BusinessMetadata Attribute should have been assigned " + e));
        }
    }
}

