/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.repository.store.graph.v2.AtlasClassificationDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasClassificationDefStoreV2Test {
    private AtlasClassificationDefStoreV2 classificationDefStore;
    @Inject
    AtlasTypeRegistry atlasTypeRegistry;
    @Inject
    AtlasTypeDefGraphStoreV2 typeDefStore;

    @BeforeClass
    public void setUp() {
        this.classificationDefStore = new AtlasClassificationDefStoreV2(this.typeDefStore, this.atlasTypeRegistry);
    }

    @DataProvider
    public Object[][] traitRegexString() {
        return new Object[][]{{"test1", true}, {"\u597d", true}, {"\u597d\u597d", true}, {"\u597d \u597d", true}, {"\u597d_\u597d", true}, {"\u597d.\u597d", true}, {"class1.attr1", true}, {"1test", false}, {"_test1", false}};
    }

    @Test(dataProvider="traitRegexString")
    public void testIsValidName(String data, boolean expected) {
        Assert.assertEquals((boolean)this.classificationDefStore.isValidName(data), (boolean)expected);
    }
}

