/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasBusinessMetadataDefStoreV2Test {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefGraphStoreV2 typeDefStore;
    private AtlasTypesDef typesDefs;
    private static int randomCount;
    private static final String TEST_BUSINESS_METADATA = "test_businessMetadata";
    private String businessMetadataName;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        TestLoadModelUtils.loadBaseModel((AtlasTypeDefStore)this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadFsModel((AtlasTypeDefStore)this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadHiveModel((AtlasTypeDefStore)this.typeDefStore, this.typeRegistry);
        this.typesDefs = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.businessMetadataName = TEST_BUSINESS_METADATA;
        randomCount = 1;
    }

    @BeforeMethod
    public void setTypeDefs() {
        this.typesDefs = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.businessMetadataName = TEST_BUSINESS_METADATA + ++randomCount;
    }

    @Test(priority=-1)
    public void createBusinessMetadataDef() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        Assert.assertEquals((int)this.typeRegistry.getAllBusinessMetadataDefs().size(), (int)1);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName("hive_table");
        Map m1 = entityType.getBusinessAttributes();
        Assert.assertEquals((int)((Map)m1.get(this.businessMetadataName)).size(), (int)2);
    }

    @Test
    public void createBusinessMetadataDefWithoutAttributes() throws AtlasBaseException {
        this.createBusinessMetadataTypesWithoutAttributes(this.businessMetadataName);
        AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(this.businessMetadataName);
        Assert.assertTrue((boolean)(businessMetadataType.getAllAttributes() == null ? true : businessMetadataType.getAllAttributes().isEmpty()));
    }

    private void createBusinessMetadataTypesWithoutAttributes(String businessMetadataName) throws AtlasBaseException {
        ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>(this.typesDefs.getBusinessMetadataDefs());
        businessMetadataDefs.add(this.createBusinessMetadataDefWithoutAttributes(businessMetadataName));
        this.typesDefs.setBusinessMetadataDefs(businessMetadataDefs);
        this.typeDefStore.createTypesDef(this.typesDefs);
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDefWithoutAttributes(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        return businessMetadataDef;
    }

    @Test
    public void createBusinessMetadataDefIsOptionalIsUnique() throws AtlasBaseException {
        this.createBusinessMetadataTypesIsOptionalIsUnique(this.businessMetadataName);
        AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(this.businessMetadataName);
        AtlasStructType.AtlasAttribute atlasAttribute = businessMetadataType.getAttribute("test_business_attribute1");
        AtlasStructDef.AtlasAttributeDef atlasAttributeDef = atlasAttribute.getAttributeDef();
        Assert.assertFalse((boolean)atlasAttributeDef.getIsOptional());
        Assert.assertTrue((boolean)atlasAttributeDef.getIsUnique());
    }

    private void createBusinessMetadataTypesIsOptionalIsUnique(String businessMetadataName) throws AtlasBaseException {
        ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>(this.typesDefs.getBusinessMetadataDefs());
        businessMetadataDefs.add(this.createBusinessMetadataDefIsOptionalIsUnique(businessMetadataName));
        this.typesDefs.setBusinessMetadataDefs(businessMetadataDefs);
        this.typeDefStore.createTypesDef(this.typesDefs);
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDefIsOptionalIsUnique(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute1", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, false, true);
        return businessMetadataDef;
    }

    private void addBusinessAttribute(AtlasBusinessMetadataDef businessMetadataDef, String name, Set<String> applicableEntityTypes, String typeName, AtlasStructDef.AtlasAttributeDef.Cardinality cardinality, boolean isOptional, boolean isUnique) {
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef(name, typeName);
        attributeDef.setCardinality(cardinality);
        attributeDef.setOption("applicableEntityTypes", AtlasType.toJson(applicableEntityTypes));
        attributeDef.setIsOptional(isOptional);
        attributeDef.setIsUnique(isUnique);
        businessMetadataDef.addAttribute(attributeDef);
    }

    @Test
    public void createBusinessMetadataDefParentApplicableType() throws AtlasBaseException {
        this.createBusinessMetadataTypesParentApplicableType(this.businessMetadataName);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName("hive_table");
        AtlasBusinessMetadataType.AtlasBusinessAttribute businessAttribute = entityType.getBusinessAttribute(this.businessMetadataName, "test_business_attribute_asset_type");
        AtlasStructDef.AtlasAttributeDef attributeDef = businessAttribute.getAttributeDef();
        String applicableType = attributeDef.getOption("applicableEntityTypes");
        Assert.assertEquals((String)applicableType, (String)"[\"Asset\"]");
    }

    private void createBusinessMetadataTypesParentApplicableType(String businessMetadataName) throws AtlasBaseException {
        ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>(this.typesDefs.getBusinessMetadataDefs());
        businessMetadataDefs.add(this.createBusinessMetadataDefParentApplicableType(businessMetadataName));
        this.typesDefs.setBusinessMetadataDefs(businessMetadataDefs);
        this.typeDefStore.createTypesDef(this.typesDefs);
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDefParentApplicableType(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute_asset_type", new HashSet<String>(Arrays.asList("Asset")), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        return businessMetadataDef;
    }

    private void createEnumTypes() throws AtlasBaseException {
        ArrayList<AtlasEnumDef> atlasEnumDefs = new ArrayList<AtlasEnumDef>(this.typesDefs.getEnumDefs());
        String _description = "_description";
        AtlasEnumDef myEnum = new AtlasEnumDef("ENUM_1", "ENUM_1" + _description, "1.0", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("USER", "Element" + _description, Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("ROLE", "Element" + _description, Integer.valueOf(2)), new AtlasEnumDef.AtlasEnumElementDef("GROUP", "Element" + _description, Integer.valueOf(3))));
        atlasEnumDefs.add(myEnum);
        this.typesDefs.setEnumDefs(atlasEnumDefs);
    }

    @Test
    public void createBusinessMetadataDefMultivaluedAttributes() throws AtlasBaseException {
        this.createEnumTypes();
        this.createBusinessMetadataTypesMultivaluedAttributes(this.businessMetadataName);
        AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(this.businessMetadataName);
        Assert.assertEquals((int)businessMetadataType.getAllAttributes().size(), (int)10);
        Map attributeMap = businessMetadataType.getAllAttributes();
        for (Map.Entry e : attributeMap.entrySet()) {
            AtlasStructType.AtlasAttribute atlasAttribute = (AtlasStructType.AtlasAttribute)e.getValue();
            AtlasStructDef.AtlasAttributeDef atlasAttributeDef = atlasAttribute.getAttributeDef();
            Assert.assertTrue((boolean)atlasAttributeDef.getTypeName().startsWith("array<"));
        }
    }

    private void createBusinessMetadataTypesMultivaluedAttributes(String businessMetadataName) throws AtlasBaseException {
        ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>(this.typesDefs.getBusinessMetadataDefs());
        businessMetadataDefs.add(this.createBusinessMetadataDefMultivaluedAttributes(businessMetadataName));
        this.typesDefs.setBusinessMetadataDefs(businessMetadataDefs);
        this.typeDefStore.createTypesDef(this.typesDefs);
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDefMultivaluedAttributes(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute1", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<boolean>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute2", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<byte>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute3", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<short>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute4", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<int>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute5", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<long>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute6", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<float>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute7", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<double>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute8", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<string>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute9", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<date>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef, "test_business_attribute10", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "array<ENUM_1>", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        return businessMetadataDef;
    }

    @Test
    public void deleteBusinessMetadataDefs() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        for (AtlasBusinessMetadataDef atlasBusinessMetaDataDef : this.typesDefs.getBusinessMetadataDefs()) {
            if (!atlasBusinessMetaDataDef.getName().equals(this.businessMetadataName)) continue;
            this.typesDefs = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            this.typesDefs.setBusinessMetadataDefs(Arrays.asList(atlasBusinessMetaDataDef));
            this.typeDefStore.deleteTypesDef(this.typesDefs);
        }
        for (AtlasBusinessMetadataDef businessMetadataDef : this.typeRegistry.getAllBusinessMetadataDefs()) {
            Assert.assertNotEquals((Object)businessMetadataDef.getName(), (Object)this.businessMetadataName);
        }
    }

    @Test
    public void updateBusinessMetadataDefs() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        AtlasBusinessMetadataDef businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        Assert.assertNotNull((Object)businessMetadataDef);
        this.addBusinessAttribute(businessMetadataDef, "test_businessMetadata_attribute3", Collections.singleton("hive_table"), String.format("array<%s>", "string"), AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
        this.updateBusinessMetadataDefs(businessMetadataDef);
        this.typeDefStore.updateTypesDef(this.typesDefs);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName("hive_table");
        Map m1 = entityType.getBusinessAttributes();
        Assert.assertEquals((int)((Map)m1.get(this.businessMetadataName)).size(), (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateTypeDefsWithoutApplicableEntityTypes() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        AtlasBusinessMetadataDef businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        Assert.assertNotNull((Object)businessMetadataDef);
        AtlasStructDef.AtlasAttributeDef businessAttributeDef = (AtlasStructDef.AtlasAttributeDef)businessMetadataDef.getAttributeDefs().iterator().next();
        businessMetadataDef.setAttributeDefs(Arrays.asList(businessAttributeDef));
        AtlasTypesDef existingTypeDefs = this.typesDefs;
        try {
            this.typesDefs.setBusinessMetadataDefs(Arrays.asList(businessMetadataDef));
            this.typeDefStore.updateTypesDef(this.typesDefs);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.ATTRIBUTE_DELETION_NOT_SUPPORTED);
        }
        finally {
            this.typesDefs = existingTypeDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateTypeDefsDeleteApplicableEntityTypes() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        AtlasBusinessMetadataDef businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        Assert.assertNotNull((Object)businessMetadataDef);
        Iterator it = businessMetadataDef.getAttributeDefs().iterator();
        AtlasStructDef.AtlasAttributeDef businessAttributeDef = (AtlasStructDef.AtlasAttributeDef)it.next();
        AtlasStructDef.AtlasAttributeDef businessAttributeDef2 = (AtlasStructDef.AtlasAttributeDef)it.next();
        businessAttributeDef.setOption("applicableEntityTypes", AtlasType.toJson(Collections.emptySet()));
        businessMetadataDef.setAttributeDefs(Arrays.asList(businessAttributeDef, businessAttributeDef2));
        AtlasTypesDef existingTypeDefs = this.typesDefs;
        try {
            this.typesDefs.setBusinessMetadataDefs(Arrays.asList(businessMetadataDef));
            this.typeDefStore.updateTypesDef(this.typesDefs);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.APPLICABLE_ENTITY_TYPES_DELETION_NOT_SUPPORTED);
        }
        finally {
            this.typesDefs = existingTypeDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateNsAttrDefDeleteApplicableEntityTypes() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        AtlasBusinessMetadataDef businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        Assert.assertNotNull((Object)businessMetadataDef);
        Iterator it = businessMetadataDef.getAttributeDefs().iterator();
        AtlasStructDef.AtlasAttributeDef businessAttributeDef = (AtlasStructDef.AtlasAttributeDef)it.next();
        AtlasStructDef.AtlasAttributeDef businessAttributeDef2 = (AtlasStructDef.AtlasAttributeDef)it.next();
        businessAttributeDef.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton("hive_table")));
        businessMetadataDef.setAttributeDefs(Arrays.asList(businessAttributeDef, businessAttributeDef2));
        AtlasTypesDef existingTypeDefs = this.typesDefs;
        try {
            this.typesDefs.setBusinessMetadataDefs(Arrays.asList(businessMetadataDef));
            this.typeDefStore.updateTypesDef(this.typesDefs);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.APPLICABLE_ENTITY_TYPES_DELETION_NOT_SUPPORTED);
        }
        finally {
            this.typesDefs = existingTypeDefs;
        }
    }

    @Test
    public void updateNsAttrDefAddApplicableEntityTypes() throws AtlasBaseException {
        this.createBusinessMetadataTypes(this.businessMetadataName);
        AtlasBusinessMetadataDef businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        AtlasStructDef.AtlasAttributeDef businessAttributeDef1 = (AtlasStructDef.AtlasAttributeDef)businessMetadataDef.getAttributeDefs().get(0);
        AtlasStructDef.AtlasAttributeDef businessAttributeDef2 = (AtlasStructDef.AtlasAttributeDef)businessMetadataDef.getAttributeDefs().get(1);
        Set applicableEntityTypes = (HashSet<String>)AtlasType.fromJson((String)businessAttributeDef1.getOption("applicableEntityTypes"), Set.class);
        if (applicableEntityTypes == null) {
            applicableEntityTypes = new HashSet<String>();
        }
        applicableEntityTypes.add("hive_column");
        businessAttributeDef1.setOption("applicableEntityTypes", AtlasType.toJson(applicableEntityTypes));
        businessMetadataDef.setAttributeDefs(Arrays.asList(businessAttributeDef1, businessAttributeDef2));
        this.updateBusinessMetadataDefs(businessMetadataDef);
        this.typeDefStore.updateTypesDef(this.typesDefs);
        businessMetadataDef = this.findBusinessMetadataDef(this.businessMetadataName);
        businessAttributeDef1 = (AtlasStructDef.AtlasAttributeDef)businessMetadataDef.getAttributeDefs().get(0);
        applicableEntityTypes = (Set)AtlasType.fromJson((String)businessAttributeDef1.getOption("applicableEntityTypes"), Set.class);
        Assert.assertEquals((int)(applicableEntityTypes == null ? 0 : applicableEntityTypes.size()), (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void validateMaxStringLengthForStringTypes() throws AtlasBaseException {
        AtlasTypesDef existingTypeDefs = this.typesDefs;
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef(this.businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef1, "test_businessMetadata_attribute1", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "string", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.typesDefs.setBusinessMetadataDefs(Arrays.asList(businessMetadataDef1));
        try {
            this.typeDefStore.createTypesDef(this.typesDefs);
        }
        catch (AtlasBaseException exception) {
            Assert.assertEquals((Object)exception.getAtlasErrorCode(), (Object)AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE);
        }
        finally {
            this.typesDefs = existingTypeDefs;
        }
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDef(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef1, "test_businessMetadata_attribute1", new HashSet<String>(Arrays.asList("hive_table", "fs_path")), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef1, "test_businessMetadata_attribute2", Collections.singleton("hive_table"), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)businessMetadataDef1);
        return businessMetadataDef1;
    }

    private AtlasBusinessMetadataDef createBusinessMetadataDef2(String businessMetadataName) {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef(businessMetadataName, "test_description", null);
        this.addBusinessAttribute(businessMetadataDef1, "test_businessMetadata_attribute1", Collections.emptySet(), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        this.addBusinessAttribute(businessMetadataDef1, "test_businessMetadata_attribute2", Collections.singleton("hive_table"), "int", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        return businessMetadataDef1;
    }

    private void createBusinessMetadataTypes(String businessMetadataName) throws AtlasBaseException {
        ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>(this.typesDefs.getBusinessMetadataDefs());
        businessMetadataDefs.add(this.createBusinessMetadataDef(businessMetadataName));
        this.typesDefs.setBusinessMetadataDefs(businessMetadataDefs);
        AtlasTypesDef createdTypesDef = this.typeDefStore.createTypesDef(this.typesDefs);
        Assert.assertEquals((Collection)createdTypesDef.getBusinessMetadataDefs(), businessMetadataDefs, (String)"Data integrity issue while persisting");
    }

    private void addBusinessAttribute(AtlasBusinessMetadataDef businessMetadataDef, String name, Set<String> applicableEntityTypes, String typeName, AtlasStructDef.AtlasAttributeDef.Cardinality cardinality) {
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef(name, typeName);
        attributeDef.setCardinality(cardinality);
        attributeDef.setOption("applicableEntityTypes", AtlasType.toJson(applicableEntityTypes));
        if (typeName.contains("string")) {
            attributeDef.setOption("maxStrLength", "20");
        }
        attributeDef.setIsOptional(true);
        attributeDef.setValuesMinCount(0);
        attributeDef.setValuesMaxCount(1);
        attributeDef.setIsUnique(false);
        attributeDef.setDisplayName(name);
        businessMetadataDef.addAttribute(attributeDef);
    }

    private AtlasBusinessMetadataDef findBusinessMetadataDef(String businessMetadataName) {
        for (AtlasBusinessMetadataDef atlasBusinessMetaDataDef : this.typesDefs.getBusinessMetadataDefs()) {
            if (!atlasBusinessMetaDataDef.getName().equals(businessMetadataName)) continue;
            return atlasBusinessMetaDataDef;
        }
        return null;
    }

    private void updateBusinessMetadataDefs(AtlasBusinessMetadataDef atlasBusinessMetaDataDef) {
        for (int i = 0; i < this.typesDefs.getBusinessMetadataDefs().size(); ++i) {
            if (!((AtlasBusinessMetadataDef)this.typesDefs.getBusinessMetadataDefs().get(i)).getName().equals(this.businessMetadataName)) continue;
            this.typesDefs.getBusinessMetadataDefs().set(i, atlasBusinessMetaDataDef);
        }
    }
}

