/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasTypeDefGraphStoreTest
extends AtlasTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTypeDefGraphStoreTest.class);
    @Inject
    private AtlasTypeDefStore typeDefStore;

    @BeforeTest
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @Override
    @AfterClass
    public void cleanup() throws Exception {
        super.cleanup();
    }

    @Test
    public void testGet() {
        try {
            AtlasTypesDef typesDef = this.typeDefStore.searchTypesDef(new SearchFilter());
            Assert.assertNotNull((Object)typesDef.getEnumDefs());
            Assert.assertEquals((int)typesDef.getStructDefs().size(), (int)0);
            Assert.assertNotNull((Object)typesDef.getStructDefs());
            Assert.assertEquals((int)typesDef.getClassificationDefs().size(), (int)0);
            Assert.assertNotNull((Object)typesDef.getClassificationDefs());
            Assert.assertEquals((int)typesDef.getEntityDefs().size(), (int)0);
            Assert.assertNotNull((Object)typesDef.getEntityDefs());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Search of types shouldn't have failed");
        }
    }

    @Test(dataProvider="invalidGetProvider", dependsOnMethods={"testGet"})
    public void testInvalidGet(String name, String guid) {
        try {
            Assert.assertNull((Object)this.typeDefStore.getEnumDefByName(name));
            Assert.fail((String)"Exception expected for invalid name");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getEnumDefByGuid(guid));
            Assert.fail((String)"Exception expected for invalid guid");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getStructDefByName(name));
            Assert.fail((String)"Exception expected for invalid name");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getStructDefByGuid(guid));
            Assert.fail((String)"Exception expected for invalid guid");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getClassificationDefByName(name));
            Assert.fail((String)"Exception expected for invalid name");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getClassificationDefByGuid(guid));
            Assert.fail((String)"Exception expected for invalid guid");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getEntityDefByName(name));
            Assert.fail((String)"Exception expected for invalid name");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)this.typeDefStore.getEntityDefByGuid(guid));
            Assert.fail((String)"Exception expected for invalid guid");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @DataProvider
    public Object[][] invalidGetProvider() {
        return new Object[][]{{"name1", "guid1"}, {"", ""}, {null, null}};
    }

    @DataProvider
    public Object[][] validCreateDeptTypes() {
        return new Object[][]{{TestUtilsV2.defineDeptEmployeeTypes()}};
    }

    @DataProvider
    public Object[][] validUpdateDeptTypes() {
        AtlasTypesDef typesDef = TestUtilsV2.defineValidUpdatedDeptEmployeeTypes();
        return new Object[][]{{typesDef}};
    }

    @DataProvider
    public Object[][] allCreatedTypes() {
        AtlasTypesDef updatedTypeDefs = TestUtilsV2.defineValidUpdatedDeptEmployeeTypes();
        AtlasTypesDef allTypeDefs = new AtlasTypesDef();
        allTypeDefs.getEnumDefs().addAll(updatedTypeDefs.getEnumDefs());
        allTypeDefs.getStructDefs().addAll(updatedTypeDefs.getStructDefs());
        allTypeDefs.getClassificationDefs().addAll(updatedTypeDefs.getClassificationDefs());
        allTypeDefs.getEntityDefs().addAll(updatedTypeDefs.getEntityDefs());
        allTypeDefs.getEntityDefs().addAll(TestUtilsV2.getEntityWithValidSuperType());
        return new Object[][]{{allTypeDefs}};
    }

    @DataProvider
    public Object[][] invalidCreateTypes() {
        return new Object[0][];
    }

    @DataProvider
    public Object[][] invalidUpdateTypes() {
        return new Object[][]{{TestUtilsV2.defineInvalidUpdatedDeptEmployeeTypes()}};
    }

    @Test(dependsOnMethods={"testGet"}, dataProvider="validCreateDeptTypes")
    public void testCreateDept(AtlasTypesDef atlasTypesDef) {
        AtlasTypesDef existingTypesDef = null;
        try {
            existingTypesDef = this.typeDefStore.searchTypesDef(new SearchFilter());
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        Assert.assertNotEquals((Object)atlasTypesDef, existingTypesDef, (String)"Types to be created already exist in the system");
        AtlasTypesDef createdTypesDef = null;
        try {
            createdTypesDef = this.typeDefStore.createTypesDef(atlasTypesDef);
            Assert.assertNotNull((Object)createdTypesDef);
            Assert.assertTrue((boolean)createdTypesDef.getEnumDefs().containsAll(atlasTypesDef.getEnumDefs()), (String)"EnumDefs create failed");
            Assert.assertTrue((boolean)createdTypesDef.getClassificationDefs().containsAll(atlasTypesDef.getClassificationDefs()), (String)"ClassificationDef create failed");
            Assert.assertTrue((boolean)createdTypesDef.getStructDefs().containsAll(atlasTypesDef.getStructDefs()), (String)"StructDef creation failed");
            Assert.assertEquals((Collection)createdTypesDef.getEntityDefs(), (Collection)atlasTypesDef.getEntityDefs());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Creation of Types should've been a success", (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testCreateDept"}, dataProvider="validUpdateDeptTypes")
    public void testUpdate(AtlasTypesDef atlasTypesDef) {
        try {
            AtlasEnumDef updated;
            AtlasTypesDef updatedTypesDef = this.typeDefStore.updateTypesDef(atlasTypesDef);
            Assert.assertNotNull((Object)updatedTypesDef);
            Assert.assertEquals((int)updatedTypesDef.getEnumDefs().size(), (int)atlasTypesDef.getEnumDefs().size(), (String)"EnumDefs update failed");
            Assert.assertEquals((int)updatedTypesDef.getClassificationDefs().size(), (int)atlasTypesDef.getClassificationDefs().size(), (String)"ClassificationDef update failed");
            Assert.assertEquals((int)updatedTypesDef.getStructDefs().size(), (int)atlasTypesDef.getStructDefs().size(), (String)"StructDef update failed");
            Assert.assertEquals((int)updatedTypesDef.getEntityDefs().size(), (int)atlasTypesDef.getEntityDefs().size(), (String)"EntityDef update failed");
            for (AtlasEnumDef enumDef : updatedTypesDef.getEnumDefs()) {
                updated = this.typeDefStore.updateEnumDefByGuid(enumDef.getGuid(), enumDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasEnumDef enumDef : atlasTypesDef.getEnumDefs()) {
                updated = this.typeDefStore.updateEnumDefByName(enumDef.getName(), enumDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasClassificationDef classificationDef : updatedTypesDef.getClassificationDefs()) {
                updated = this.typeDefStore.updateClassificationDefByGuid(classificationDef.getGuid(), classificationDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasClassificationDef classificationDef : atlasTypesDef.getClassificationDefs()) {
                updated = this.typeDefStore.updateClassificationDefByName(classificationDef.getName(), classificationDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasStructDef structDef : updatedTypesDef.getStructDefs()) {
                updated = this.typeDefStore.updateStructDefByGuid(structDef.getGuid(), structDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasStructDef structDef : atlasTypesDef.getStructDefs()) {
                updated = this.typeDefStore.updateStructDefByName(structDef.getName(), structDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasEntityDef entityDef : updatedTypesDef.getEntityDefs()) {
                updated = this.typeDefStore.updateEntityDefByGuid(entityDef.getGuid(), entityDef);
                Assert.assertNotNull((Object)updated);
            }
            for (AtlasEntityDef entityDef : atlasTypesDef.getEntityDefs()) {
                updated = this.typeDefStore.updateEntityDefByName(entityDef.getName(), entityDef);
                Assert.assertNotNull((Object)updated);
            }
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"TypeDef updates should've succeeded");
        }
    }

    @Test(enabled=false, dependsOnMethods={"testCreateDept"})
    public void testUpdateWithMandatoryFields() {
        AtlasTypesDef updated2;
        AtlasTypesDef atlasTypesDef = TestUtilsV2.defineInvalidUpdatedDeptEmployeeTypes();
        List enumDefsToUpdate = atlasTypesDef.getEnumDefs();
        List classificationDefsToUpdate = atlasTypesDef.getClassificationDefs();
        List structDefsToUpdate = atlasTypesDef.getStructDefs();
        List entityDefsToUpdate = atlasTypesDef.getEntityDefs();
        AtlasTypesDef onlyEnums = new AtlasTypesDef(enumDefsToUpdate, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        AtlasTypesDef onlyStructs = new AtlasTypesDef(Collections.EMPTY_LIST, structDefsToUpdate, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        AtlasTypesDef onlyClassification = new AtlasTypesDef(Collections.EMPTY_LIST, Collections.EMPTY_LIST, classificationDefsToUpdate, Collections.EMPTY_LIST);
        AtlasTypesDef onlyEntities = new AtlasTypesDef(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, entityDefsToUpdate);
        try {
            updated2 = this.typeDefStore.updateTypesDef(onlyEnums);
            Assert.assertNotNull((Object)updated2);
        }
        catch (AtlasBaseException updated2) {
            // empty catch block
        }
        try {
            updated2 = this.typeDefStore.updateTypesDef(onlyClassification);
            Assert.assertNotNull((Object)updated2);
            Assert.assertEquals((int)updated2.getClassificationDefs().size(), (int)0, (String)"Updates should've failed");
        }
        catch (AtlasBaseException updated3) {
            // empty catch block
        }
        try {
            updated2 = this.typeDefStore.updateTypesDef(onlyStructs);
            Assert.assertNotNull((Object)updated2);
            Assert.assertEquals((int)updated2.getStructDefs().size(), (int)0, (String)"Updates should've failed");
        }
        catch (AtlasBaseException updated4) {
            // empty catch block
        }
        try {
            updated2 = this.typeDefStore.updateTypesDef(onlyEntities);
            Assert.assertNotNull((Object)updated2);
            Assert.assertEquals((int)updated2.getEntityDefs().size(), (int)0, (String)"Updates should've failed");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testUpdate"}, dataProvider="allCreatedTypes")
    public void testDelete(AtlasTypesDef atlasTypesDef) {
        try {
            this.typeDefStore.deleteTypesDef(atlasTypesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Deletion should've succeeded");
        }
    }

    @Test
    public void deleteTypeByName() throws IOException {
        try {
            String HIVEDB_v2_JSON = "hiveDBv2";
            String hiveDB2 = "hive_db_v2";
            String relationshipDefName = "cluster_hosts_relationship";
            String hostEntityDef = "host";
            String clusterEntityDef = "cluster";
            AtlasTypesDef typesDef = TestResourceFileUtils.readObjectFromJson(".", "hiveDBv2", AtlasTypesDef.class);
            this.typeDefStore.createTypesDef(typesDef);
            this.typeDefStore.deleteTypeByName("hive_db_v2");
            this.typeDefStore.deleteTypeByName("cluster_hosts_relationship");
            this.typeDefStore.deleteTypeByName("host");
            this.typeDefStore.deleteTypeByName("cluster");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Deletion should've succeeded");
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithValidAttributes() {
        AtlasTypesDef hiveTypes = TestUtilsV2.defineHiveTypes();
        try {
            AtlasTypesDef createdTypes = this.typeDefStore.createTypesDef(hiveTypes);
            Assert.assertEquals((Collection)hiveTypes.getEnumDefs(), (Collection)createdTypes.getEnumDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)hiveTypes.getStructDefs(), (Collection)createdTypes.getStructDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)hiveTypes.getClassificationDefs(), (Collection)createdTypes.getClassificationDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)hiveTypes.getEntityDefs(), (Collection)createdTypes.getEntityDefs(), (String)"Data integrity issue while persisting");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Hive Type creation should've succeeded");
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithNestedContainerAttributes() {
        AtlasTypesDef typesDef = TestUtilsV2.defineTypeWithNestedCollectionAttributes();
        try {
            AtlasTypesDef createdTypes = this.typeDefStore.createTypesDef(typesDef);
            Assert.assertEquals((Collection)typesDef.getEnumDefs(), (Collection)createdTypes.getEnumDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)typesDef.getStructDefs(), (Collection)createdTypes.getStructDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)typesDef.getClassificationDefs(), (Collection)createdTypes.getClassificationDefs(), (String)"Data integrity issue while persisting");
            Assert.assertEquals((Collection)typesDef.getEntityDefs(), (Collection)createdTypes.getEntityDefs(), (String)"Data integrity issue while persisting");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"creation of type with nested-container attributes should've succeeded");
        }
    }

    @Test(enabled=false)
    public void testCreateWithInvalidAttributes() {
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithValidSuperTypes() {
        List classificationDefs = TestUtilsV2.getClassificationWithValidSuperType();
        AtlasTypesDef toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, Collections.emptyList());
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.assertEquals((Collection)created.getClassificationDefs(), (Collection)toCreate.getClassificationDefs(), (String)"Classification creation with valid supertype should've succeeded");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Classification creation with valid supertype should've succeeded");
        }
        List entityDefs = TestUtilsV2.getEntityWithValidSuperType();
        toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), entityDefs);
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.assertEquals((Collection)created.getEntityDefs(), (Collection)toCreate.getEntityDefs(), (String)"Entity creation with valid supertype should've succeeded");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Entity creation with valid supertype should've succeeded");
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithInvalidSuperTypes() {
        AtlasClassificationDef classificationDef = TestUtilsV2.getClassificationWithInvalidSuperType();
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getClassificationDefs().add(classificationDef);
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(typesDef);
            Assert.fail((String)"Classification creation with invalid supertype should've failed");
        }
        catch (AtlasBaseException e) {
            typesDef = null;
        }
        AtlasEntityDef entityDef = TestUtilsV2.getEntityWithInvalidSuperType();
        typesDef = new AtlasTypesDef();
        typesDef.getEntityDefs().add(entityDef);
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(typesDef);
            Assert.fail((String)"Entity creation with invalid supertype should've failed");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateClassificationDefWithValidEntityType() {
        String entityTypeName = "testCreateClassificationDefWithValidEntityTypeEntity1";
        String classificationTypeName = "testCreateClassificationDefWithValidEntityTypeClassification1";
        List entityDefs = TestUtilsV2.getEntityWithName((String)"testCreateClassificationDefWithValidEntityTypeEntity1");
        List classificationDefs = TestUtilsV2.getClassificationWithName((String)"testCreateClassificationDefWithValidEntityTypeClassification1");
        HashSet<String> entityTypeNames = new HashSet<String>();
        entityTypeNames.add("testCreateClassificationDefWithValidEntityTypeEntity1");
        ((AtlasClassificationDef)classificationDefs.get(0)).setEntityTypes(entityTypeNames);
        AtlasTypesDef toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, entityDefs);
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.assertEquals((Collection)created.getClassificationDefs(), (Collection)toCreate.getClassificationDefs(), (String)"Classification creation with valid entitytype should've succeeded");
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)("Classification creation with valid entitytype should've succeeded. Failed with " + e.getMessage()));
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithInvalidEntityType() {
        String classificationTypeName = "testCreateClassificationDefWithInvalidEntityTypeClassification1";
        List classificationDefs = TestUtilsV2.getClassificationWithName((String)"testCreateClassificationDefWithInvalidEntityTypeClassification1");
        HashSet<String> entityTypeNames = new HashSet<String>();
        entityTypeNames.add("cccc");
        ((AtlasClassificationDef)classificationDefs.get(0)).setEntityTypes(entityTypeNames);
        AtlasTypesDef toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, Collections.emptyList());
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.fail((String)"Classification creation with invalid entitytype should've failed");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithInvalidEntityType2() {
        String classificationTypeName1 = "testCreateClassificationDefWithInvalidEntityType2Classification1";
        String classificationTypeName2 = "testCreateClassificationDefWithInvalidEntityType2Classification2";
        String entityTypeName1 = "testCreateClassificationDefWithInvalidEntityType2Entity1";
        AtlasClassificationDef classificationDef1 = TestUtilsV2.getSingleClassificationWithName((String)"testCreateClassificationDefWithInvalidEntityType2Classification1");
        AtlasClassificationDef classificationDef2 = TestUtilsV2.getSingleClassificationWithName((String)"testCreateClassificationDefWithInvalidEntityType2Classification2");
        List entityDefs = TestUtilsV2.getEntityWithName((String)"testCreateClassificationDefWithInvalidEntityType2Entity1");
        HashSet<String> entityTypeNames = new HashSet<String>();
        entityTypeNames.add("testCreateClassificationDefWithInvalidEntityType2Entity1");
        HashSet<String> superTypes = new HashSet<String>();
        superTypes.add("testCreateClassificationDefWithInvalidEntityType2Classification1");
        classificationDef2.setSuperTypes(superTypes);
        classificationDef1.setEntityTypes(entityTypeNames);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)classificationDef1);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)classificationDef2);
        List<AtlasClassificationDef> classificationDefs = Arrays.asList(classificationDef1, classificationDef2);
        AtlasTypesDef toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, Collections.emptyList());
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.fail((String)"Classification creation with invalid entitytype should've failed");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testCreateWithInvalidEntityType3() {
        String classificationTypeName1 = "testCreateClassificationDefWithInvalidEntityType3Classification1";
        String classificationTypeName2 = "testCreateClassificationDefWithInvalidEntityType3Classification2";
        String entityTypeName1 = "testCreateClassificationDefWithInvalidEntityType3Entity1";
        String entityTypeName2 = "testCreateClassificationDefWithInvalidEntityType3Entity2";
        AtlasClassificationDef classificationDef1 = TestUtilsV2.getSingleClassificationWithName((String)"testCreateClassificationDefWithInvalidEntityType3Classification1");
        AtlasClassificationDef classificationDef2 = TestUtilsV2.getSingleClassificationWithName((String)"testCreateClassificationDefWithInvalidEntityType3Classification2");
        AtlasEntityDef entityDef1 = TestUtilsV2.getSingleEntityWithName((String)"testCreateClassificationDefWithInvalidEntityType3Entity1");
        AtlasEntityDef entityDef2 = TestUtilsV2.getSingleEntityWithName((String)"testCreateClassificationDefWithInvalidEntityType3Entity2");
        HashSet<String> entityTypeNames1 = new HashSet<String>();
        entityTypeNames1.add("testCreateClassificationDefWithInvalidEntityType3Entity1");
        HashSet<String> entityTypeNames2 = new HashSet<String>();
        entityTypeNames2.add("testCreateClassificationDefWithInvalidEntityType3Entity2");
        HashSet<String> superTypes = new HashSet<String>();
        superTypes.add("testCreateClassificationDefWithInvalidEntityType3Classification1");
        classificationDef1.setEntityTypes(entityTypeNames1);
        classificationDef2.setSuperTypes(superTypes);
        classificationDef2.setEntityTypes(entityTypeNames2);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)classificationDef1);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)classificationDef2);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)entityDef1);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)entityDef2);
        List<AtlasClassificationDef> classificationDefs = Arrays.asList(classificationDef1, classificationDef2);
        List<AtlasEntityDef> entityDefs = Arrays.asList(entityDef1, entityDef2);
        AtlasTypesDef toCreate = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), classificationDefs, entityDefs);
        try {
            AtlasTypesDef created = this.typeDefStore.createTypesDef(toCreate);
            Assert.fail((String)"Classification creation with invalid entitytype should've failed");
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testSearchFunctionality() {
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setParam("supertype", "Person");
        try {
            AtlasTypesDef typesDef = this.typeDefStore.searchTypesDef(searchFilter);
            Assert.assertNotNull((Object)typesDef);
            Assert.assertNotNull((Object)typesDef.getEntityDefs());
            Assert.assertEquals((int)typesDef.getEntityDefs().size(), (int)3);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Search should've succeeded", (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testTypeDeletionAndRecreate() {
        AtlasClassificationDef aTag = new AtlasClassificationDef("testTag");
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef("testAttribute", "string", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, true, false, Collections.emptyList());
        aTag.addAttribute(attributeDef);
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.setClassificationDefs(Arrays.asList(aTag));
        try {
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag creation should've succeeded");
        }
        try {
            this.typeDefStore.deleteTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag deletion should've succeeded");
        }
        aTag = new AtlasClassificationDef("testTag");
        attributeDef = new AtlasStructDef.AtlasAttributeDef("testAttribute", "int", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, true, false, Collections.emptyList());
        aTag.addAttribute(attributeDef);
        typesDef.setClassificationDefs(Arrays.asList(aTag));
        try {
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Tag re-creation should've succeeded");
        }
    }

    @Test(dependsOnMethods={"testGet"})
    public void testTypeRegistryIsUpdatedAfterGraphStorage() throws AtlasBaseException {
        String classificationDef = "{\"name\":\"test_classification_11\",\"description\":\"\",\"createdBy\":\"admin\",\"superTypes\":[],\"attributeDefs\":[{\"name\":\"test_class_11\",\"typeName\":\"string\",\"isOptional\":true,\"isUnique\":true,\"isIndexable\":true,\"cardinality\":\"SINGLE\",\"valuesMinCount\":0,\"valuesMaxCount\":1}]}";
        String jsonStr = "{\"classificationDefs\":[" + classificationDef + "],\"entityDefs\":[],\"enumDefs\":[],\"structDefs\":[]}";
        AtlasTypesDef testTypesDefFromJson = (AtlasTypesDef)AtlasType.fromJson((String)jsonStr, AtlasTypesDef.class);
        AtlasTypesDef createdTypesDef = this.typeDefStore.createTypesDef(testTypesDefFromJson);
        Assert.assertEquals((String)"test_classification_11", (String)((AtlasClassificationDef)createdTypesDef.getClassificationDefs().get(0)).getName());
        Assert.assertTrue((boolean)((AtlasStructDef.AtlasAttributeDef)((AtlasClassificationDef)createdTypesDef.getClassificationDefs().get(0)).getAttributeDefs().get(0)).getIsIndexable());
        String guid = ((AtlasClassificationDef)createdTypesDef.getClassificationDefs().get(0)).getGuid();
        Date createdTime = ((AtlasClassificationDef)createdTypesDef.getClassificationDefs().get(0)).getCreateTime();
        AtlasClassificationDef getBackFromCache = this.typeDefStore.getClassificationDefByName("test_classification_11");
        Assert.assertEquals((String)"test_classification_11", (String)getBackFromCache.getName());
        Assert.assertTrue((boolean)((AtlasStructDef.AtlasAttributeDef)getBackFromCache.getAttributeDefs().get(0)).getIsIndexable());
        Assert.assertEquals((String)guid, (String)getBackFromCache.getGuid());
        Assert.assertNotNull((Object)getBackFromCache.getCreatedBy());
        Assert.assertEquals((Object)createdTime, (Object)getBackFromCache.getCreateTime());
        testTypesDefFromJson = (AtlasTypesDef)AtlasType.fromJson((String)jsonStr, AtlasTypesDef.class);
        ((AtlasStructDef.AtlasAttributeDef)((AtlasClassificationDef)testTypesDefFromJson.getClassificationDefs().get(0)).getAttributeDefs().get(0)).setIsIndexable(false);
        AtlasTypesDef updatedTypesDef = this.typeDefStore.updateTypesDef(testTypesDefFromJson);
        Assert.assertEquals((String)"test_classification_11", (String)((AtlasClassificationDef)updatedTypesDef.getClassificationDefs().get(0)).getName());
        Assert.assertFalse((boolean)((AtlasStructDef.AtlasAttributeDef)((AtlasClassificationDef)updatedTypesDef.getClassificationDefs().get(0)).getAttributeDefs().get(0)).getIsIndexable());
        Assert.assertEquals((String)guid, (String)((AtlasClassificationDef)updatedTypesDef.getClassificationDefs().get(0)).getGuid());
        Assert.assertEquals((Object)createdTime, (Object)((AtlasClassificationDef)updatedTypesDef.getClassificationDefs().get(0)).getCreateTime());
        getBackFromCache = this.typeDefStore.getClassificationDefByName("test_classification_11");
        Assert.assertEquals((String)"test_classification_11", (String)getBackFromCache.getName());
        Assert.assertFalse((boolean)((AtlasStructDef.AtlasAttributeDef)getBackFromCache.getAttributeDefs().get(0)).getIsIndexable());
        Assert.assertEquals((String)guid, (String)getBackFromCache.getGuid());
        Assert.assertEquals((Object)createdTime, (Object)getBackFromCache.getCreateTime());
        getBackFromCache = this.typeDefStore.getClassificationDefByGuid(guid);
        Assert.assertEquals((String)"test_classification_11", (String)getBackFromCache.getName());
        Assert.assertFalse((boolean)((AtlasStructDef.AtlasAttributeDef)getBackFromCache.getAttributeDefs().get(0)).getIsIndexable());
        Assert.assertEquals((String)guid, (String)getBackFromCache.getGuid());
        Assert.assertEquals((Object)createdTime, (Object)getBackFromCache.getCreateTime());
    }

    @Test
    public void testGetOnAllEntityTypes() throws AtlasBaseException {
        AtlasEntityDef entityDefByName = this.typeDefStore.getEntityDefByName("_ALL_ENTITY_TYPES");
        Assert.assertNotNull((Object)entityDefByName);
        Assert.assertEquals((Object)entityDefByName, (Object)AtlasEntityType.getEntityRoot().getEntityDef());
    }

    @Test
    public void testGetOnAllClassificationTypes() throws AtlasBaseException {
        AtlasClassificationDef classificationTypeDef = this.typeDefStore.getClassificationDefByName("_ALL_CLASSIFICATION_TYPES");
        Assert.assertNotNull((Object)classificationTypeDef);
        Assert.assertEquals((Object)classificationTypeDef, (Object)AtlasClassificationType.getClassificationRoot().getClassificationDef());
    }
}

