/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.graphdb.janus.migration.TypesWithCollectionsFinder;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TypesWithCollectionsFinderTest
extends MigrationBaseAsserts {
    @Inject
    protected TypesWithCollectionsFinderTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.loadTypesFromJson();
        this.typeDefStore.createTypesDef(TestResourceFileUtils.readObjectFromJson(".", "typesDef-classification-with-map", AtlasTypesDef.class));
    }

    @Test
    public void fetchAll() {
        Map typeAttrMap = TypesWithCollectionsFinder.getVertexPropertiesForCollectionAttributes((AtlasTypeRegistry)this.typeRegistry);
        Assert.assertTrue((typeAttrMap.size() >= 19 ? 1 : 0) != 0);
        this.assertProperties(typeAttrMap, "__AtlasUserProfile", "ARRAY", "__AtlasUserProfile.savedSearches");
        this.assertProperties(typeAttrMap, "Process", "ARRAY", "Process.inputs");
        this.assertProperties(typeAttrMap, "Process", "ARRAY", "Process.outputs");
        this.assertProperties(typeAttrMap, "hdfs_path", "MAP_PRIMITIVE", "hdfs_path.extendedAttributes");
        this.assertProperties(typeAttrMap, "hive_column_lineage", "ARRAY", "Process.inputs");
        this.assertProperties(typeAttrMap, "hive_column_lineage", "ARRAY", "Process.outputs");
        this.assertProperties(typeAttrMap, "hive_db", "MAP_PRIMITIVE", "hive_db.parameters");
        this.assertProperties(typeAttrMap, "hive_process", "ARRAY", "Process.inputs");
        this.assertProperties(typeAttrMap, "hive_process", "ARRAY", "Process.outputs");
        this.assertProperties(typeAttrMap, "hive_storagedesc", "ARRAY", "hive_storagedesc.sortCols");
        this.assertProperties(typeAttrMap, "hive_serde", "MAP_PRIMITIVE", "hive_serde.parameters");
        this.assertProperties(typeAttrMap, "hive_table", "ARRAY", "hive_table.partitionKeys");
        this.assertProperties(typeAttrMap, "hive_table", "ARRAY", "hive_table.columns");
        this.assertProperties(typeAttrMap, "hive_table", "MAP_PRIMITIVE", "hive_table.parameters");
        this.assertProperties(typeAttrMap, "tag_with_map_of_map", "MAP_PRIMITIVE", "tag_with_map_of_map.tag_with_map_of_map");
    }

    private void assertProperties(Map<String, Map<String, List<String>>> typeAttrMap, String typeName, String typeCategory, String propertyName) {
        List<String> actualProperties = typeAttrMap.get(typeName).get(typeCategory);
        Assert.assertTrue((boolean)actualProperties.contains(propertyName));
    }
}

