/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TypesWithClassificationTest
extends MigrationBaseAsserts {
    @Inject
    public TypesWithClassificationTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @Test
    public void verify() throws IOException, AtlasBaseException {
        int EXPECTED_TOTAL_COUNT = 62;
        String ENTITY_TYPE = "ComplexTraitType";
        String LEGACY_TYPE_TRAIT = "legacy_traitprayivofx4";
        String LEGACY_TYPE_VENDOR_PII = "legacy_VENDOR_PII";
        String LEGACY_TYPE_FINANCE = "legacy_FINANCE";
        this.runFileImporter("classification_defs");
        this.assertTypeCountNameGuid(ENTITY_TYPE, 1, "", "");
        this.assertTypeCountNameGuid(LEGACY_TYPE_TRAIT, 1, "", "");
        this.assertTypeCountNameGuid(LEGACY_TYPE_VENDOR_PII, 3, "", "");
        this.assertTypeCountNameGuid(LEGACY_TYPE_FINANCE, 2, "", "");
        this.assertEdgesWithLabel(this.getVertex(ENTITY_TYPE, "").getEdges(AtlasEdgeDirection.OUT).iterator(), 1, "__ComplexTraitType.vendors");
        this.assertEdgesWithLabel(this.getVertex(ENTITY_TYPE, "").getEdges(AtlasEdgeDirection.OUT).iterator(), 4, "__ComplexTraitType.finance");
        this.assertEdgesWithLabel(this.getVertex(ENTITY_TYPE, "").getEdges(AtlasEdgeDirection.OUT).iterator(), 6, "__ComplexTraitType.complexTrait");
        this.assertMigrationStatus(EXPECTED_TOTAL_COUNT);
    }
}

