/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.janus.migration.TypesDefScrubber;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.io.FileUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TypesDefScrubberTest {
    private static final String resourcesDirRelativePath = "/src/test/resources/";
    private final String LEGACY_TYPESDEF_JSON = "legacy-typesdef.json";
    private String resourceDir;

    @BeforeClass
    public void setup() {
        this.resourceDir = System.getProperty("user.dir") + resourcesDirRelativePath;
    }

    protected AtlasTypesDef getTypesDefFromFile(String s) {
        File f = new File(this.getFilePath(s));
        try {
            return (AtlasTypesDef)AtlasType.fromJson((String)FileUtils.readFileToString((File)f), AtlasTypesDef.class);
        }
        catch (IOException e) {
            throw new SkipException("getTypesDefFromFile: " + s, (Throwable)e);
        }
    }

    protected String getFilePath(String fileName) {
        return Paths.get(this.resourceDir, fileName).toString();
    }

    @Test
    public void performScrub() {
        TypesDefScrubber typesDefScrubber = new TypesDefScrubber();
        AtlasTypesDef td = this.getTypesDefFromFile("legacy-typesdef.json");
        int traitPrayIndex = 1;
        int vendorPIIIndex = 2;
        int financeIndex = 3;
        int classificationTraitPrayIndex = 0;
        int classificationVendorPiiIndex = 2;
        int classificationFinancendex = 3;
        String expectedTraitPrayStructName = TypesDefScrubber.getLegacyTypeNameForStructDef((String)((AtlasClassificationDef)td.getClassificationDefs().get(classificationTraitPrayIndex)).getName());
        String expectedVendorPIIStructName = TypesDefScrubber.getLegacyTypeNameForStructDef((String)((AtlasClassificationDef)td.getClassificationDefs().get(classificationVendorPiiIndex)).getName());
        String expectedFinanceStructName = TypesDefScrubber.getLegacyTypeNameForStructDef((String)((AtlasClassificationDef)td.getClassificationDefs().get(classificationFinancendex)).getName());
        this.assertNewTypesDef(typesDefScrubber.scrub(td), traitPrayIndex, vendorPIIIndex, financeIndex, expectedTraitPrayStructName, expectedVendorPIIStructName, expectedFinanceStructName);
        this.assertTraitMap(typesDefScrubber, td, classificationTraitPrayIndex, expectedTraitPrayStructName, 0);
        this.assertTraitMap(typesDefScrubber, td, classificationVendorPiiIndex, expectedVendorPIIStructName, 1);
        this.assertTraitMap(typesDefScrubber, td, classificationFinancendex, expectedFinanceStructName, 2);
    }

    private void assertTraitMap(TypesDefScrubber typesDefScrubber, AtlasTypesDef td, int classificationIndex, String expectedStructName, int attrIndex) {
        String label = TypesDefScrubber.getEdgeLabel((String)((AtlasEntityDef)td.getEntityDefs().get(0)).getName(), (String)((AtlasStructDef.AtlasAttributeDef)((AtlasEntityDef)td.getEntityDefs().get(0)).getAttributeDefs().get(attrIndex)).getName());
        Assert.assertTrue((boolean)typesDefScrubber.getTraitToTypeMap().containsKey(label));
        Assert.assertEquals((String)((TypesDefScrubber.ClassificationToStructDefName)typesDefScrubber.getTraitToTypeMap().get(label)).getTypeName(), (String)((AtlasClassificationDef)td.getClassificationDefs().get(classificationIndex)).getName());
        Assert.assertEquals((String)((TypesDefScrubber.ClassificationToStructDefName)typesDefScrubber.getTraitToTypeMap().get(label)).getLegacyTypeName(), (String)expectedStructName);
    }

    private void assertTraitMap(Map<String, TypesDefScrubber.ClassificationToStructDefName> traitToTypeMap, AtlasTypesDef td) {
    }

    private void assertNewTypesDef(AtlasTypesDef newTypes, int traitPrayIndex, int vendorPIIIndex, int financeIndex, String expectedTraitPrayStructName, String expectedVendorPIIStructName, String expectedFinanceStructName) {
        Assert.assertNotNull((Object)newTypes);
        Assert.assertEquals((int)newTypes.getStructDefs().size(), (int)4);
        Assert.assertTrue((boolean)((AtlasStructDef)newTypes.getStructDefs().get(traitPrayIndex)).getName().contains("legacy"));
        Assert.assertTrue((boolean)((AtlasStructDef)newTypes.getStructDefs().get(vendorPIIIndex)).getName().contains("legacy"));
        Assert.assertTrue((boolean)((AtlasStructDef)newTypes.getStructDefs().get(financeIndex)).getName().contains("legacy"));
        Assert.assertEquals((String)((AtlasStructDef)newTypes.getStructDefs().get(traitPrayIndex)).getName(), (String)expectedTraitPrayStructName);
        Assert.assertEquals((String)((AtlasStructDef)newTypes.getStructDefs().get(vendorPIIIndex)).getName(), (String)expectedVendorPIIStructName);
        Assert.assertEquals((String)((AtlasStructDef)newTypes.getStructDefs().get(financeIndex)).getName(), (String)expectedFinanceStructName);
        Assert.assertEquals((int)((AtlasStructDef)newTypes.getStructDefs().get(1)).getAttributeDefs().size(), (int)1);
        Assert.assertEquals((String)((AtlasStructDef.AtlasAttributeDef)((AtlasEntityDef)newTypes.getEntityDefs().get(0)).getAttributeDefs().get(0)).getTypeName(), (String)expectedTraitPrayStructName);
        Assert.assertEquals((String)((AtlasStructDef.AtlasAttributeDef)((AtlasEntityDef)newTypes.getEntityDefs().get(0)).getAttributeDefs().get(1)).getTypeName(), (String)String.format("array<%s>", expectedVendorPIIStructName));
        Assert.assertEquals((String)((AtlasStructDef.AtlasAttributeDef)((AtlasEntityDef)newTypes.getEntityDefs().get(0)).getAttributeDefs().get(2)).getTypeName(), (String)String.format("map<String,%s>", expectedFinanceStructName));
    }
}

