/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class HiveParititionTest
extends MigrationBaseAsserts {
    @Inject
    public HiveParititionTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @Test
    public void fileImporterTest() throws IOException, AtlasBaseException {
        int EXPECTED_TOTAL_COUNT = 144;
        boolean EXPECTED_DB_COUNT = true;
        int EXPECTED_TABLE_COUNT = 2;
        int EXPECTED_COLUMN_COUNT = 7;
        this.runFileImporter("parts_db");
        this.assertHiveVertices(1, 2, 7);
        this.assertTypeCountNameGuid("hive_db", 1, "parts_db", "ae30d78b-51b4-42ab-9436-8d60c8f68b95");
        this.assertTypeCountNameGuid("hive_process", 1, "", "");
        this.assertEdges("hive_db", "parts_db", AtlasEdgeDirection.IN, 1, "");
        this.assertEdges("hive_table", "t1", AtlasEdgeDirection.OUT, 1, "hive_table_db");
        this.assertEdges("hive_table", "tv1", AtlasEdgeDirection.OUT, 1, "hive_table_db");
        this.assertMigrationStatus(144);
    }
}

