/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ComplexAttributesTest
extends MigrationBaseAsserts {
    @Inject
    public ComplexAttributesTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @Test
    public void verify() throws IOException, AtlasBaseException {
        String STRUCT_TYPE = "struct_type";
        String ENTITY_TYPE = "entity_type";
        String ENTITY_WITH_COMPLEX_COLL_TYPE = "entity_with_complex_collection_attr";
        int EXPECTED_TOTAL_COUNT = 217;
        int EXPECTED_ENTITY_TYPE_COUNT = 16;
        int EXPECTED_STRUCT_TYPE_COUNT = 3;
        boolean EXPECTED_ENTITY_WITH_COMPLEX_COLL_TYPE_COUNT = true;
        this.runFileImporter("complex-attr_db");
        this.assertTypeCountNameGuid(STRUCT_TYPE, 3, "", "");
        this.assertTypeCountNameGuid(ENTITY_TYPE, 16, "", "");
        this.assertTypeCountNameGuid(ENTITY_WITH_COMPLEX_COLL_TYPE, 1, "", "");
        this.assertEdgesWithLabel(this.getVertex(ENTITY_WITH_COMPLEX_COLL_TYPE, "").getEdges(AtlasEdgeDirection.OUT).iterator(), 1, "__entity_with_complex_collection_attr.listOfEntities");
        this.assertEdgesWithLabel(this.getVertex(ENTITY_WITH_COMPLEX_COLL_TYPE, "").getEdges(AtlasEdgeDirection.OUT).iterator(), 9, "__entity_with_complex_collection_attr.mapOfStructs");
        this.assertMigrationStatus(217);
    }
}

