/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSource;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ZipSourceTest {
    @DataProvider(name="zipFileStocks")
    public static Object[][] getDataFromZipFile() throws IOException, AtlasBaseException {
        FileInputStream fs = ZipFileResourceTestUtils.getFileInputStream("stocks.zip");
        return new Object[][]{{new ZipSource((InputStream)fs)}};
    }

    @DataProvider(name="zipFileStocksFloat")
    public static Object[][] getDataFromZipFileWithLongFloats() throws IOException, AtlasBaseException {
        FileInputStream fs = ZipFileResourceTestUtils.getFileInputStream("stocks-float.zip");
        return new Object[][]{{new ZipSource((InputStream)fs)}};
    }

    @DataProvider(name="sales")
    public static Object[][] getDataFromQuickStart_v1_Sales(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("sales-v1-full.zip");
    }

    @Test(expectedExceptions={AtlasBaseException.class})
    public void improperInit_ReturnsNullCreationOrder() throws IOException, AtlasBaseException {
        byte[] bytes = new byte[10];
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ZipSource zs = new ZipSource((InputStream)bais);
        List s = zs.getCreationOrder();
        Assert.assertNull((Object)s);
    }

    @Test(dataProvider="zipFileStocks")
    public void examineContents_BehavesAsExpected(ZipSource zipSource) throws AtlasBaseException {
        List creationOrder = zipSource.getCreationOrder();
        Assert.assertNotNull((Object)creationOrder);
        Assert.assertEquals((int)creationOrder.size(), (int)4);
        AtlasTypesDef typesDef = zipSource.getTypesDef();
        Assert.assertNotNull((Object)typesDef);
        Assert.assertEquals((int)typesDef.getEntityDefs().size(), (int)6);
        this.useCreationOrderToFetchEntitiesWithExtInfo(zipSource, creationOrder);
        this.useCreationOrderToFetchEntities(zipSource, creationOrder);
        this.attemptToFetchNonExistentGuid_ReturnsNull(zipSource, "non-existent-guid");
        this.verifyGuidRemovalOnImportComplete(zipSource, (String)creationOrder.get(0));
    }

    private void useCreationOrderToFetchEntities(ZipSource zipSource, List<String> creationOrder) {
        for (String guid : creationOrder) {
            AtlasEntity e = zipSource.getByGuid(guid);
            Assert.assertNotNull((Object)e);
        }
    }

    private void verifyGuidRemovalOnImportComplete(ZipSource zipSource, String guid) {
        AtlasEntity e = zipSource.getByGuid(guid);
        Assert.assertNotNull((Object)e);
        zipSource.onImportComplete(guid);
        e = zipSource.getByGuid(guid);
        Assert.assertNull((Object)e);
    }

    private void attemptToFetchNonExistentGuid_ReturnsNull(ZipSource zipSource, String guid) {
        AtlasEntity e = zipSource.getByGuid(guid);
        Assert.assertNull((Object)e);
    }

    private void useCreationOrderToFetchEntitiesWithExtInfo(ZipSource zipSource, List<String> creationOrder) throws AtlasBaseException {
        for (String guid : creationOrder) {
            AtlasEntity.AtlasEntityWithExtInfo e = zipSource.getEntityWithExtInfo(guid);
            Assert.assertNotNull((Object)e);
        }
    }

    @Test(dataProvider="zipFileStocks")
    public void iteratorBehavor_WorksAsExpected(ZipSource zipSource) throws IOException, AtlasBaseException {
        Assert.assertTrue((boolean)zipSource.hasNext());
        List creationOrder = zipSource.getCreationOrder();
        for (int i = 0; i < creationOrder.size(); ++i) {
            AtlasEntity e = zipSource.next();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((String)e.getGuid(), (String)((String)creationOrder.get(i)));
        }
        Assert.assertFalse((boolean)zipSource.hasNext());
    }

    @Test(dataProvider="sales")
    public void iteratorSetPositionBehavor(InputStream inputStream) throws IOException, AtlasBaseException {
        ZipSource zipSource = new ZipSource(inputStream);
        Assert.assertTrue((boolean)zipSource.hasNext());
        List creationOrder = zipSource.getCreationOrder();
        int moveToPosition_2 = 2;
        zipSource.setPosition(moveToPosition_2);
        Assert.assertEquals((int)zipSource.getPosition(), (int)moveToPosition_2);
        AssertJUnit.assertTrue((zipSource.getPosition() < creationOrder.size() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)zipSource.hasNext());
        for (int i = 1; i < 4; ++i) {
            zipSource.next();
            Assert.assertEquals((int)zipSource.getPosition(), (int)(moveToPosition_2 + i));
        }
        AssertJUnit.assertTrue((boolean)zipSource.hasNext());
    }

    @Test(dataProvider="zipFileStocksFloat")
    public void attemptToSerializeLongFloats(ZipSource zipSource) throws IOException, AtlasBaseException {
        Assert.assertTrue((boolean)zipSource.hasNext());
        AssertJUnit.assertTrue((boolean)zipSource.hasNext());
        AssertJUnit.assertTrue((boolean)zipSource.hasNext());
        AtlasEntity.AtlasEntityWithExtInfo e = zipSource.getNextEntityWithExtInfo();
        Assert.assertNotNull((Object)e);
        AssertJUnit.assertTrue((e.getEntity().getClassifications().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((AtlasClassification)e.getEntity().getClassifications().get(0)).getAttribute("fv"));
        Assert.assertEquals((String)((AtlasClassification)e.getEntity().getClassifications().get(0)).getAttribute("fv").toString(), (String)"3.4028235E+38");
        AssertJUnit.assertTrue((boolean)zipSource.hasNext());
    }

    @Test(dataProvider="zipFileStocks")
    public void applyTransformation(ZipSource zipSource) throws IOException, AtlasBaseException {
        ImportTransforms transforms = this.getTransformForHiveDB();
        zipSource.setImportTransform(transforms);
        Assert.assertTrue((boolean)zipSource.hasNext());
        List creationOrder = zipSource.getCreationOrder();
        for (int i = 0; i < creationOrder.size(); ++i) {
            AtlasEntity e = zipSource.next();
            if (!e.getTypeName().equals("hive_db")) continue;
            Object o = e.getAttribute("qualifiedName");
            String s = (String)o;
            Assert.assertNotNull((Object)e);
            AssertJUnit.assertTrue((boolean)s.contains("@cl2"));
            break;
        }
    }

    private ImportTransforms getTransformForHiveDB() {
        ImportTransforms tr = ImportTransforms.fromJson((String)"{ \"hive_db\": { \"qualifiedName\": [ \"replace:@cl1:@cl2\" ] } }");
        return tr;
    }
}

