/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.impexp.ZipExportFileNames;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ZipSinkTest {
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private ZipSink zipSink;
    private List<String> defaultExportOrder = new ArrayList<String>(Arrays.asList("a", "b", "c", "d"));
    private AtlasExportResult defaultExportResult;
    private String knownEntityGuidFormat = "111-222-333-%s";

    private void initZipSinkWithExportOrder() throws AtlasBaseException {
        this.zipSink = new ZipSink((OutputStream)this.byteArrayOutputStream);
        this.zipSink.setExportOrder(this.defaultExportOrder);
        this.zipSink.close();
    }

    private AtlasExportResult getDefaultExportResult() {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("hive_db", "qualifiedName", (Object)"default"));
        request.setItemsToExport(itemsToExport);
        this.defaultExportResult = new AtlasExportResult(request, "admin", "1.0.0.0", "root", 100L, 0L);
        return this.defaultExportResult;
    }

    private ZipInputStream getZipInputStreamForDefaultExportOrder() throws AtlasBaseException {
        this.initZipSinkWithExportOrder();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
        return new ZipInputStream(bis);
    }

    private String getZipEntryAsStream(ZipInputStream zis) throws IOException {
        byte[] buf = new byte[1024];
        int n = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((n = zis.read(buf, 0, 1024)) > -1) {
            bos.write(buf, 0, n);
        }
        Assert.assertNotNull((Object)bos);
        return bos.toString();
    }

    @Test
    public void correctInit_succeeds() throws AtlasBaseException {
        this.initZipSinkWithExportOrder();
        Assert.assertTrue((boolean)true);
        Assert.assertNotNull((Object)this.zipSink);
    }

    @Test
    public void zipWithExactlyOneEntry_succeeds() {
        try {
            ZipInputStream zis = this.getZipInputStreamForDefaultExportOrder();
            try {
                Assert.assertNotNull((Object)zis.getNextEntry());
                Assert.assertNull((Object)zis.getNextEntry());
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)false);
            }
        }
        catch (AtlasBaseException e) {
            Assert.assertTrue((boolean)false, (String)"No exception should be thrown.");
        }
    }

    @Test
    public void verifyExportOrderEntryName_verifies() throws AtlasBaseException, IOException {
        ZipInputStream zis = this.getZipInputStreamForDefaultExportOrder();
        ZipEntry ze = zis.getNextEntry();
        Assert.assertEquals((String)ze.getName().replace(".json", ""), (String)ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString());
    }

    @Test
    public void zipWithExactlyOneEntry_ContentsVerified() throws AtlasBaseException, IOException {
        ZipInputStream zis = this.getZipInputStreamForDefaultExportOrder();
        zis.getNextEntry();
        Assert.assertEquals((String)this.getZipEntryAsStream(zis).replace("\"", "'"), (String)"['a','b','c','d']");
    }

    @Test
    public void zipWithExactlyTwoEntries_ContentsVerified() throws AtlasBaseException, IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        this.useZipSinkToCreateEntries(byteOutputStream);
        ByteArrayInputStream bis = new ByteArrayInputStream(byteOutputStream.toByteArray());
        ZipInputStream zipStream = new ZipInputStream(bis);
        ZipEntry entry = zipStream.getNextEntry();
        Assert.assertEquals((String)this.getZipEntryAsStream(zipStream), (String)"[\"a\",\"b\",\"c\",\"d\"]");
        Assert.assertEquals((String)entry.getName().replace(".json", ""), (String)ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString());
        entry = zipStream.getNextEntry();
        Assert.assertEquals((String)entry.getName().replace(".json", ""), (String)ZipExportFileNames.ATLAS_EXPORT_INFO_NAME.toString());
        Assert.assertTrue((boolean)this.compareJsonWithObject(this.getZipEntryAsStream(zipStream), this.defaultExportResult));
    }

    @Test
    public void recordsEntityEntries() throws AtlasBaseException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ZipSink zs = new ZipSink((OutputStream)byteOutputStream);
        AtlasEntity entity = new AtlasEntity();
        entity.setGuid(String.format(this.knownEntityGuidFormat, 0));
        zs.add(entity);
        Assert.assertTrue((boolean)zs.hasEntity(String.format(this.knownEntityGuidFormat, 0)));
        zs.close();
    }

    @Test
    public void recordsEntityWithExtInfoEntries() throws AtlasBaseException {
        int max_entries = 3;
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ZipSink zs = new ZipSink((OutputStream)byteOutputStream);
        AtlasEntity entity = new AtlasEntity();
        entity.setGuid(String.format(this.knownEntityGuidFormat, 0));
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo(entity);
        this.addReferredEntities(entityWithExtInfo, 3);
        zs.add(entityWithExtInfo);
        for (int i = 0; i <= 3; ++i) {
            String g = String.format(this.knownEntityGuidFormat, i);
            Assert.assertTrue((boolean)zs.hasEntity(g));
        }
        zs.close();
    }

    private void addReferredEntities(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, int maxEntries) {
        for (int i = 1; i <= maxEntries; ++i) {
            AtlasEntity entity1 = new AtlasEntity();
            entity1.setGuid(String.format(this.knownEntityGuidFormat, i));
            entityWithExtInfo.addReferredEntity(entity1);
        }
    }

    @Test
    public void recordsDoesNotRecordEntityEntries() throws AtlasBaseException {
        this.initZipSinkWithExportOrder();
        Assert.assertNotNull((Object)this.zipSink);
        Assert.assertFalse((boolean)this.zipSink.hasEntity(ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString()));
    }

    private void useZipSinkToCreateEntries(ByteArrayOutputStream byteOutputStream) throws AtlasBaseException {
        ZipSink zs = new ZipSink((OutputStream)byteOutputStream);
        zs.setExportOrder(this.defaultExportOrder);
        zs.setResult(this.getDefaultExportResult());
        zs.close();
    }

    private boolean compareJsonWithObject(String s, AtlasExportResult defaultExportResult) {
        String json = AtlasType.toJson((Object)defaultExportResult);
        return json.equals(s);
    }
}

