/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSourceDirect;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ZipDirectTest {
    @Test(expectedExceptions={AtlasBaseException.class})
    public void loadFileEmpty() throws IOException, AtlasBaseException {
        FileInputStream inputStream = ZipFileResourceTestUtils.getFileInputStream("zip-direct-1.zip");
        new ZipSourceDirect((InputStream)inputStream, 1);
    }

    @Test
    public void loadFile() throws IOException, AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo;
        int EXPECTED_ENTITY_COUNT = 3;
        FileInputStream inputStream = ZipFileResourceTestUtils.getFileInputStream("zip-direct-2.zip");
        ZipSourceDirect zipSourceDirect = new ZipSourceDirect((InputStream)inputStream, 3);
        Assert.assertNotNull((Object)zipSourceDirect);
        Assert.assertNotNull((Object)zipSourceDirect.getTypesDef());
        Assert.assertTrue((zipSourceDirect.getTypesDef().getEntityDefs().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)zipSourceDirect.getExportResult());
        int count = 0;
        while ((entityWithExtInfo = zipSourceDirect.getNextEntityWithExtInfo()) != null) {
            Assert.assertNotNull((Object)entityWithExtInfo);
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void entitiesParserTest() throws IOException {
        String object1 = "{\"type\":\"hdfs_path\"}";
        String object2 = "{\"type\":\"hive_db\"}";
        String entities = "[" + object1 + "," + object2 + ",{}]";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(entities.getBytes());
        ZipSourceDirect.EntitiesArrayParser entitiesArrayParser = new ZipSourceDirect.EntitiesArrayParser((InputStream)inputStream);
        String o = entitiesArrayParser.next();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)o, (Object)object1);
        o = entitiesArrayParser.next();
        Assert.assertEquals((Object)o, (Object)object2);
        o = entitiesArrayParser.next();
        Assert.assertNull((Object)o);
    }
}

