/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import org.apache.atlas.repository.util.UniqueList;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UniqueListTest {
    private final String firstElement = "firstElement";
    private UniqueList<String> uniqueList;

    @BeforeClass
    public void setup() {
        this.uniqueList = new UniqueList();
        this.uniqueList.add((Object)"firstElement");
        this.uniqueList.add((Object)"def");
        this.uniqueList.add((Object)"firstElement");
        this.uniqueList.add((Object)"ghi");
    }

    @Test
    public void add3Elements_ListHas2() {
        Assert.assertEquals((int)3, (int)this.uniqueList.size());
    }

    @Test
    public void addAllList_ListHas2() {
        UniqueList uniqueList2 = new UniqueList();
        uniqueList2.addAll(this.uniqueList);
        Assert.assertEquals((int)3, (int)uniqueList2.size());
    }

    @Test
    public void attemptClear_SizeIsZero() {
        UniqueList uniqueList2 = new UniqueList();
        uniqueList2.addAll(this.uniqueList);
        uniqueList2.clear();
        Assert.assertEquals((int)0, (int)uniqueList2.size());
    }

    @Test
    public void attemptOneRemove_SizeIsReduced() {
        UniqueList uniqueList2 = new UniqueList();
        uniqueList2.addAll(this.uniqueList);
        String removedElement = (String)uniqueList2.remove(0);
        Assert.assertEquals((int)2, (int)uniqueList2.size());
        Assert.assertEquals((String)"firstElement", (String)removedElement);
    }
}

