/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.TypeAttributeDifference;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TypeAttributeDifferenceTest {
    private TypeAttributeDifference typeAttributeDifference;
    @Mock
    AtlasTypeDefStore typeDefStore;
    @Mock
    AtlasTypeRegistry typeRegistry;

    @BeforeClass
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.typeAttributeDifference = new TypeAttributeDifference(this.typeDefStore, this.typeRegistry);
    }

    private List<AtlasEnumDef.AtlasEnumElementDef> getEnumElementDefs(int startIndex, String ... names) {
        int i = startIndex;
        ArrayList<AtlasEnumDef.AtlasEnumElementDef> list = new ArrayList<AtlasEnumDef.AtlasEnumElementDef>();
        for (String s : names) {
            list.add(new AtlasEnumDef.AtlasEnumElementDef(s, s, Integer.valueOf(i++)));
        }
        return list;
    }

    private List<AtlasStructDef.AtlasAttributeDef> getAtlasAttributeDefs(String ... names) {
        ArrayList<AtlasStructDef.AtlasAttributeDef> list = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
        for (String s : names) {
            list.add(new AtlasStructDef.AtlasAttributeDef(s, "string"));
        }
        return list;
    }

    private AtlasEntityDef getAtlasEntityDefWithAttributes(String ... attributeNames) {
        AtlasEntityDef e = new AtlasEntityDef();
        for (AtlasStructDef.AtlasAttributeDef a : this.getAtlasAttributeDefs(attributeNames)) {
            e.addAttribute(a);
        }
        return e;
    }

    @Test
    public void entityDefWithNoAttributes() throws Exception {
        AtlasEntityDef existing = new AtlasEntityDef();
        AtlasEntityDef incoming = new AtlasEntityDef();
        ArrayList expectedAttributes = new ArrayList();
        List<AtlasStructDef.AtlasAttributeDef> actualAttributes = this.invokeGetAttributesAbsentInExisting((AtlasStructDef)existing, (AtlasStructDef)incoming);
        Assert.assertEquals(actualAttributes, expectedAttributes);
    }

    private List<AtlasStructDef.AtlasAttributeDef> invokeGetAttributesAbsentInExisting(AtlasStructDef existing, AtlasStructDef incoming) throws Exception {
        return this.typeAttributeDifference.getElementsAbsentInExisting(existing, incoming);
    }

    private List<AtlasEnumDef.AtlasEnumElementDef> invokeGetAttributesAbsentInExisting(AtlasEnumDef existing, AtlasEnumDef incoming) throws Exception {
        return this.typeAttributeDifference.getElementsAbsentInExisting(existing, incoming);
    }

    private AtlasEnumDef getAtlasEnumWithAttributes(String ... elements) {
        AtlasEnumDef enumDef = new AtlasEnumDef();
        for (AtlasEnumDef.AtlasEnumElementDef ed : this.getEnumElementDefs(0, elements)) {
            enumDef.addElement(ed);
        }
        return enumDef;
    }

    @Test
    public void bothSame_DifferenceIsEmptyList() throws Exception {
        AtlasEntityDef existing = this.getAtlasEntityDefWithAttributes("name", "qualifiedName");
        AtlasEntityDef incoming = this.getAtlasEntityDefWithAttributes("name", "qualifiedName");
        List<AtlasStructDef.AtlasAttributeDef> expectedAttributes = this.getAtlasAttributeDefs(new String[0]);
        List<AtlasStructDef.AtlasAttributeDef> actualAttributes = this.invokeGetAttributesAbsentInExisting((AtlasStructDef)existing, (AtlasStructDef)incoming);
        Assert.assertEquals(actualAttributes, expectedAttributes);
    }

    @Test
    public void different_ReturnsDifference() throws Exception {
        AtlasEntityDef existing = this.getAtlasEntityDefWithAttributes("name");
        AtlasEntityDef incoming = this.getAtlasEntityDefWithAttributes("name", "qualifiedName");
        List<AtlasStructDef.AtlasAttributeDef> expectedAttributes = this.getAtlasAttributeDefs("qualifiedName");
        List<AtlasStructDef.AtlasAttributeDef> actualAttributes = this.invokeGetAttributesAbsentInExisting((AtlasStructDef)existing, (AtlasStructDef)incoming);
        Assert.assertEquals(actualAttributes, expectedAttributes);
    }

    @Test
    public void differentSubset_ReturnsDifference() throws Exception {
        AtlasEntityDef existing = this.getAtlasEntityDefWithAttributes("name", "qualifiedName");
        AtlasEntityDef incoming = this.getAtlasEntityDefWithAttributes("name");
        List<AtlasStructDef.AtlasAttributeDef> actualAttributes = this.invokeGetAttributesAbsentInExisting((AtlasStructDef)existing, (AtlasStructDef)incoming);
        List<AtlasStructDef.AtlasAttributeDef> expectedAttributes = this.getAtlasAttributeDefs(new String[0]);
        Assert.assertEquals(actualAttributes, expectedAttributes);
    }

    @Test
    public void differentEnumDef_ReturnsDifference() throws Exception {
        AtlasEnumDef existing = this.getAtlasEnumWithAttributes("Alpha", "Bravo");
        AtlasEnumDef incoming = this.getAtlasEnumWithAttributes("Alpha", "Bravo", "Delta", "Echo");
        List<AtlasEnumDef.AtlasEnumElementDef> actualAttributes = this.invokeGetAttributesAbsentInExisting(existing, incoming);
        List<AtlasEnumDef.AtlasEnumElementDef> expectedAttributes = this.getEnumElementDefs(2, "Delta", "Echo");
        Assert.assertEquals(actualAttributes, expectedAttributes);
    }

    @Test
    public void differentEnumDefs_ReturnsDifference() throws Exception {
        AtlasEnumDef existing = this.getAtlasEnumWithAttributes("Alpha", "Bravo");
        AtlasEnumDef incoming = this.getAtlasEnumWithAttributes("Alpha", "Bravo", "Delta", "Echo");
        boolean ret = this.invokeUpdate(existing, incoming);
        List<AtlasEnumDef.AtlasEnumElementDef> expectedAttributes = this.getEnumElementDefs(0, "Alpha", "Bravo", "Delta", "Echo");
        Assert.assertTrue((boolean)ret, (String)"Update took place");
        Assert.assertEquals((Collection)existing.getElementDefs(), expectedAttributes);
    }

    private boolean invokeUpdate(AtlasEnumDef existing, AtlasEnumDef incoming) throws Exception {
        return this.typeAttributeDifference.addElements(existing, incoming);
    }

    @Test
    public void t1() throws IOException, AtlasBaseException {
        AtlasTypesDef typesDef = TestResourceFileUtils.readObjectFromJson(".", "typesDef-bm", AtlasTypesDef.class);
        AtlasImportResult result = new AtlasImportResult();
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)typesDef, (AtlasTypeRegistry)this.typeRegistry);
        this.typeDefStore.createTypesDef(typesToCreate);
        this.typeAttributeDifference.updateTypes(typesDef, result);
        Assert.assertNotNull((Object)typesDef);
    }
}

