/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.StartEntityFetchByExportRequest;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasGremlin3QueryProvider;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class StartEntityFetchByExportRequestTest
extends AtlasTestBase {
    @Inject
    private AtlasGraph atlasGraph;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    private AtlasGremlin3QueryProvider atlasGremlin3QueryProvider;
    private StartEntityFetchByExportRequestSpy startEntityFetchByExportRequestSpy;

    @BeforeClass
    void setup() throws IOException, AtlasBaseException {
        super.basicSetup(this.typeDefStore, this.typeRegistry);
        this.atlasGremlin3QueryProvider = new AtlasGremlin3QueryProvider();
        this.startEntityFetchByExportRequestSpy = new StartEntityFetchByExportRequestSpy(this.atlasGraph, this.typeRegistry);
    }

    @Test
    public void fetchTypeGuid() {
        String exportRequestJson = "{ \"itemsToExport\": [ { \"typeName\": \"hive_db\", \"guid\": \"111-222-333\" } ]}";
        AtlasExportRequest exportRequest = (AtlasExportRequest)AtlasType.fromJson((String)exportRequestJson, AtlasExportRequest.class);
        List objectGuidMap = this.startEntityFetchByExportRequestSpy.get(exportRequest);
        Assert.assertEquals((String)((AtlasObjectId)objectGuidMap.get(0)).getGuid(), (String)"111-222-333");
    }

    @Test
    public void fetchTypeUniqueAttributes() {
        String exportRequestJson = "{ \"itemsToExport\": [ { \"typeName\": \"hive_db\", \"uniqueAttributes\": {\"qualifiedName\": \"stocks@cl1\"} } ]}";
        AtlasExportRequest exportRequest = (AtlasExportRequest)AtlasType.fromJson((String)exportRequestJson, AtlasExportRequest.class);
        this.startEntityFetchByExportRequestSpy.get(exportRequest);
        Assert.assertEquals((String)this.startEntityFetchByExportRequestSpy.getGeneratedQuery(), (String)this.startEntityFetchByExportRequestSpy.getQueryTemplateForMatchType(exportRequest.getMatchTypeOptionValue()));
        Assert.assertEquals((Object)this.startEntityFetchByExportRequestSpy.getSuppliedBindingsMap().get("typeName"), (Object)"hive_db");
        Assert.assertEquals((Object)this.startEntityFetchByExportRequestSpy.getSuppliedBindingsMap().get("attrName"), (Object)"Referenceable.qualifiedName");
        Assert.assertEquals((Object)this.startEntityFetchByExportRequestSpy.getSuppliedBindingsMap().get("attrValue"), (Object)"stocks@cl1");
    }

    private class StartEntityFetchByExportRequestSpy
    extends StartEntityFetchByExportRequest {
        String generatedQuery;
        Map<String, Object> suppliedBindingsMap;

        public StartEntityFetchByExportRequestSpy(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry) {
            super(atlasGraph, typeRegistry, (AtlasGremlinQueryProvider)StartEntityFetchByExportRequestTest.this.atlasGremlin3QueryProvider);
        }

        List<String> executeGremlinQuery(String query, Map<String, Object> bindings) {
            this.generatedQuery = query;
            this.suppliedBindingsMap = bindings;
            return Collections.EMPTY_LIST;
        }

        public String getGeneratedQuery() {
            return this.generatedQuery;
        }

        public Map<String, Object> getSuppliedBindingsMap() {
            return this.suppliedBindingsMap;
        }
    }
}

