/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class RelationshipAttributesExtractorTest
extends AtlasTestBase {
    private static final String EXPORT_FULL = "full";
    private static final String EXPORT_CONNECTED = "connected";
    private static final String ENTITIES_SUB_DIR = "entities";
    private static final String QUALIFIED_NAME_DB = "db_test_1@02052019";
    private static final String QUALIFIED_NAME_TABLE_LINEAGE = "db_test_1.test_tbl_ctas_2@02052019";
    private static final String QUALIFIED_NAME_TABLE_NON_LINEAGE = "db_test_1.test_tbl_1@02052019";
    private static final String GUID_DB = "f0b72ab4-7452-4e42-ac74-2aee7728cce4";
    private static final String GUID_TABLE_1 = "4d5adf00-2c9b-4877-ad23-c41fd7319150";
    private static final String GUID_TABLE_2 = "8d0b834c-61ce-42d8-8f66-6fa51c36bccb";
    private static final String GUID_TABLE_CTAS_2 = "eaec545b-3ac7-4e1b-a497-bd4a2b6434a2";
    private static final String GUID_HIVE_PROCESS = "bd3138b2-f29e-4226-b859-de25eaa1c18b";
    private static final String DB1 = "db1";
    private static final String DB2 = "db2";
    private static final String TBL1 = "table1";
    private static final String TBL2 = "table2";
    private static final String HIVE_PROCESS = "table-lineage";
    private static final String HIVE_COLUMN_LINEAGE = "column-lineage";
    private static final String GUID_DB1 = "1c4e939e-ff6b-4229-92a4-b60c00deb547";
    private static final String GUID_DB2 = "77c3bccf-ca3f-42e7-b2dd-f5a35f63eea6";
    private static final String GUID_TBL1 = "3f6c02be-61e8-4dae-a7b8-cc37f289ce6e";
    private static final String GUID_TBL2 = "b8cbc39f-4467-429b-a7fe-4ba2c28cceca";
    private static final String GUID_PROCESS = "caf7f40a-b334-4f9e-9bf2-f24ce43db47f";
    private static final String GUID_COLUMN_LINEAGE = "d4cf482b-423c-4c88-9bd1-701477ed6fd8";
    @Inject
    private ImportService importService;
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private ExportService exportService;
    @Inject
    private AtlasEntityStoreV2 entityStore;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.loadBaseModel();
        this.loadHiveModel();
    }

    @BeforeTest
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @DataProvider(name="hiveDb")
    public static Object[][] getData(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("hive_db_lineage.zip");
    }

    @Test(dataProvider="hiveDb")
    public void importHiveDb(InputStream inputStream) throws AtlasBaseException, IOException {
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportDBFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveDb(QUALIFIED_NAME_DB, EXPORT_FULL, false));
        this.verifyDBFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportDBFullSkipLineageFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveDb(QUALIFIED_NAME_DB, EXPORT_FULL, true));
        this.verifyDBFullSkipLineageFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithLineageFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_FULL, false));
        this.verifyTableWithLineageFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithLineageSkipLineageFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_FULL, true));
        this.verifyTableWithLineageSkipLineageFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithoutLineageFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_NON_LINEAGE, EXPORT_FULL, false));
        this.verifyTableWithoutLineageFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithoutLineageSkipLineageFull() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_NON_LINEAGE, EXPORT_FULL, true));
        this.verifyTableWithoutLineageSkipLineageFull(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportDBConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveDb(QUALIFIED_NAME_DB, EXPORT_CONNECTED, false));
        this.verifyDBConn(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportDBSkipLineageConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveDb(QUALIFIED_NAME_DB, EXPORT_CONNECTED, true));
        this.verifyDBSkipLineageConn(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithLineageConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_CONNECTED, false));
        this.verifyTableWithLineageConn(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithLineageSkipLineageConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_CONNECTED, true));
        this.verifyTableWithLineageSkipLineageConn(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithoutLineageConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_NON_LINEAGE, EXPORT_CONNECTED, false));
        this.verifyTableWithoutLineageConn(source);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableWithoutLineageSkipLineageConn() throws Exception {
        ZipSource source = this.runExport(this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_NON_LINEAGE, EXPORT_CONNECTED, true));
        this.verifyTableWithoutLineageSkipLineageConn(source);
    }

    @Test
    public void interDbLineageConnectedExportTest() throws Exception {
        this.setupInterDbLineageData();
        ZipSource source = this.runExport(this.getExportRequestForHiveTable("db_1.table_1@cl1", EXPORT_CONNECTED, false));
        this.assertInterDbLineageConnectedExport(source);
    }

    private void setupInterDbLineageData() {
        RequestContext.get().setImportInProgress(true);
        this.createEntities(this.entityStore, ENTITIES_SUB_DIR, new String[]{DB1, DB2, TBL1, TBL2, HIVE_PROCESS, HIVE_COLUMN_LINEAGE});
        String[] entityGuids = new String[]{GUID_DB1, GUID_DB2, GUID_TBL1, GUID_TBL2, GUID_PROCESS, GUID_COLUMN_LINEAGE};
        this.verifyCreatedEntities(this.entityStore, entityGuids, 6);
        RequestContext.get().setImportInProgress(false);
    }

    private void loadHiveModel() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
    }

    private void loadBaseModel() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
    }

    private AtlasExportRequest getExportRequestForHiveDb(String hiveDbName, String fetchType, boolean skipLineage) {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("hive_db", "qualifiedName", (Object)hiveDbName));
        request.setItemsToExport(itemsToExport);
        request.setOptions(this.getOptionsMap(fetchType, skipLineage));
        return request;
    }

    private AtlasExportRequest getExportRequestForHiveTable(String hiveTableName, String fetchType, boolean skipLineage) {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("hive_table", "qualifiedName", (Object)hiveTableName));
        request.setItemsToExport(itemsToExport);
        request.setOptions(this.getOptionsMap(fetchType, skipLineage));
        return request;
    }

    private Map<String, Object> getOptionsMap(String fetchType, boolean skipLineage) {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        optionsMap.put("fetchType", fetchType.isEmpty() ? EXPORT_FULL : fetchType);
        optionsMap.put("skipLineage", skipLineage);
        return optionsMap;
    }

    private ZipSource runExport(AtlasExportRequest request) throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipSink zipSink = new ZipSink((OutputStream)baos);
        AtlasExportResult result = this.exportService.run(zipSink, request, "admin", "localhost", "1.0.0.0");
        zipSink.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        ZipSource zipSource = new ZipSource((InputStream)bis);
        return zipSource;
    }

    private void verifyDBFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)5);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2, GUID_HIVE_PROCESS);
    }

    private void verifyDBFullSkipLineageFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)4);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2);
    }

    private void verifyTableWithLineageFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)5);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2, GUID_HIVE_PROCESS);
    }

    private void verifyTableWithLineageSkipLineageFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)4);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2);
    }

    private void verifyTableWithoutLineageFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)5);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2, GUID_HIVE_PROCESS);
    }

    private void verifyTableWithoutLineageSkipLineageFull(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)4);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2);
    }

    private void verifyDBConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)5);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2, GUID_HIVE_PROCESS);
    }

    private void verifyDBSkipLineageConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)4);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1, GUID_TABLE_2, GUID_TABLE_CTAS_2);
    }

    private void verifyTableWithLineageConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)4);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_2, GUID_TABLE_CTAS_2, GUID_HIVE_PROCESS);
    }

    private void verifyTableWithLineageSkipLineageConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)2);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_CTAS_2);
    }

    private void verifyTableWithoutLineageConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)2);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1);
    }

    private void verifyTableWithoutLineageSkipLineageConn(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)2);
        Assert.assertFalse((boolean)zipSource.getCreationOrder().contains(GUID_HIVE_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB, GUID_TABLE_1);
    }

    private void assertInterDbLineageConnectedExport(ZipSource zipSource) {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)5);
        Assert.assertTrue((boolean)zipSource.getCreationOrder().contains(GUID_PROCESS));
        this.verifyExpectedEntities(this.getFileNames(zipSource), GUID_DB1, GUID_DB2, GUID_TBL1, GUID_TBL2, GUID_PROCESS);
    }

    private void verifyExpectedEntities(List<String> fileNames, String ... guids) {
        Assert.assertEquals((int)fileNames.size(), (int)guids.length);
        for (String guid : guids) {
            Assert.assertTrue((boolean)fileNames.contains(guid.toLowerCase()));
        }
    }

    private List<String> getFileNames(ZipSource zipSource) {
        ArrayList<String> ret = new ArrayList<String>();
        Assert.assertTrue((boolean)zipSource.hasNext());
        while (zipSource.hasNext()) {
            AtlasEntity atlasEntity = zipSource.next();
            Assert.assertNotNull((Object)atlasEntity);
            ret.add(atlasEntity.getGuid());
        }
        return ret;
    }
}

