/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.IncrementalExportEntityProvider;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.util.UniqueList;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class IncrementalExportEntityProviderTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasEntityStoreV2 entityStore;
    @Inject
    private AtlasGraph atlasGraph;
    private IncrementalExportEntityProvider incrementalExportEntityProvider;
    private ScriptEngine gremlinScriptEngine;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.basicSetup(this.typeDefStore, this.typeRegistry);
        RequestContext.get().setImportInProgress(true);
        this.createEntities(this.entityStore, "stocksDB-Entities", new String[]{"db", "table-columns"});
        String[] entityGuids = new String[]{"1637a33e-6512-447b-ade7-249c8cb5344b", "df122fc3-5555-40f8-a30f-3090b8a622f8"};
        this.verifyCreatedEntities(this.entityStore, entityGuids, 2);
        this.gremlinScriptEngine = this.atlasGraph.getGremlinScriptEngine();
        this.incrementalExportEntityProvider = new IncrementalExportEntityProvider(this.atlasGraph);
    }

    @AfterClass
    public void tearDown() {
        if (this.gremlinScriptEngine != null) {
            this.atlasGraph.releaseGremlinScriptEngine(this.gremlinScriptEngine);
        }
    }

    @Test
    public void verify() {
        this.executeQueries(0L, 1);
        this.executeQueries(1L, 9);
    }

    private void executeQueries(long timeStamp, int expectedEntityCount) {
        UniqueList uniqueList = new UniqueList();
        this.incrementalExportEntityProvider.populate("1637a33e-6512-447b-ade7-249c8cb5344b", timeStamp, uniqueList);
        for (String g : uniqueList.getList()) {
            Assert.assertTrue((boolean)(g instanceof String));
        }
        Assert.assertEquals((int)uniqueList.size(), (int)expectedEntityCount);
    }
}

