/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.impexp.ImportTransformer;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ImportTransformsTest {
    private final String ATTR_NAME_QUALIFIED_NAME = "qualifiedName";
    private final String COLUMN_QUALIFIED_NAME_FORMAT = "col%s.TABLE1.default@cl1";
    private final String lowerCaseCL1 = "@cl1";
    private final String lowerCaseCL2 = "@cl2";
    private final String jsonLowerCaseReplace = "{ \"hive_table\": { \"qualifiedName\":[ \"lowercase\", \"replace:@cl1:@cl2\" ] } }";
    private final String jsonReplaceLowerCase = "{ \"Asset\": { \"qualifiedName\":[ \"replace:@cl1:@cl2\" ] }, \"hive_table\": { \"qualifiedName\":[ \"lowercase\", \"replace:@cl1:@cl2\" ] } }";
    private final String jsonReplaceRemoveClassification = "{ \"hive_table\": { \"qualifiedName\":[ \"replace:@%s:@%s\"], \"*\":[ \"removeClassification:%s_to_%s\" ] } }";
    private final String jsonReplaceAndAddAttrValue = "{ \"hive_table\": { \"qualifiedName\":[ \"replace:@%s:@%s\"], \"*\":[ \"add:%s=list:%s\" ] } }";
    private final String jsonSingleClearAttrValue = "{ \"hive_table\": { \"*\":[ \"clearAttrValue:replicatedToCluster\", \"clearAttrValue:replicatedFromCluster\" ] } }";
    private final String jsonMultipleClearAttrValue = "{ \"hive_table\": { \"*\":[ \"clearAttrValue:replicatedToCluster,replicatedFromCluster\" ] } }";
    private final String jsonSetDeleted = "{ \"hive_table\": { \"*\":[ \"setDeleted\" ] } }";
    private final String jsonAddClasification = "{ \"hive_table\": { \"*\":[ \"addClassification:REPLICATED\" ] } }";
    private final String jsonAddClasification2 = "{ \"hive_table\": { \"*\":[ \"addClassification:REPLICATED_2\" ] } }";
    private final String jsonAddClasificationScoped = "{ \"hive_column\": { \"*\":[ \"addClassification:REPLICATED_2:topLevel\" ] } }";
    private ImportTransforms transform;
    private String HIVE_TABLE_ATTR_SYNC_INFO = "hive_table.syncInfo";
    private String HIVE_TABLE_ATTR_REPLICATED_FROM = "replicatedFromCluster";
    private String HIVE_TABLE_ATTR_REPLICATED_TO = "replicatedToCluster";

    @BeforeTest
    public void setup() {
        this.transform = ImportTransforms.fromJson((String)"{ \"hive_table\": { \"qualifiedName\":[ \"lowercase\", \"replace:@cl1:@cl2\" ] } }");
    }

    @BeforeMethod
    public void setUp() {
    }

    @Test
    public void transformEntityWith2Transforms() throws AtlasBaseException {
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        String attrValue = (String)entity.getAttribute("qualifiedName");
        this.transform.apply(entity);
        Assert.assertEquals((Object)entity.getAttribute("qualifiedName"), (Object)this.applyDefaultTransform(attrValue));
    }

    @Test
    public void transformEntityWithExtInfo() throws AtlasBaseException {
        this.addColumnTransform(this.transform);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getAtlasEntityWithExtInfo();
        AtlasEntity entity = entityWithExtInfo.getEntity();
        String attrValue = (String)entity.getAttribute("qualifiedName");
        String[] expectedValues = this.getExtEntityExpectedValues(entityWithExtInfo);
        this.transform.apply(entityWithExtInfo);
        Assert.assertEquals((Object)entityWithExtInfo.getEntity().getAttribute("qualifiedName"), (Object)this.applyDefaultTransform(attrValue));
        for (int i = 0; i < expectedValues.length; ++i) {
            Assert.assertEquals((Object)((AtlasEntity)entityWithExtInfo.getReferredEntities().get(Integer.toString(i))).getAttribute("qualifiedName"), (Object)expectedValues[i]);
        }
    }

    @Test
    public void transformEntityWithExtInfoNullCheck() throws AtlasBaseException {
        this.addColumnTransform(this.transform);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getAtlasEntityWithExtInfo();
        entityWithExtInfo.setReferredEntities(null);
        AtlasEntity.AtlasEntityWithExtInfo transformedEntityWithExtInfo = this.transform.apply(entityWithExtInfo);
        Assert.assertNotNull((Object)transformedEntityWithExtInfo);
        Assert.assertEquals((String)entityWithExtInfo.getEntity().getGuid(), (String)transformedEntityWithExtInfo.getEntity().getGuid());
    }

    @Test
    public void transformFromJsonWithMultipleEntries() {
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"Asset\": { \"qualifiedName\":[ \"replace:@cl1:@cl2\" ] }, \"hive_table\": { \"qualifiedName\":[ \"lowercase\", \"replace:@cl1:@cl2\" ] } }");
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((int)t.getTransforms().size(), (int)2);
    }

    @Test
    public void removeClassificationTransform_RemovesSpecifiedClassification() throws AtlasBaseException {
        ArrayList<AtlasClassification> classifications = new ArrayList<AtlasClassification>();
        classifications.add(new AtlasClassification("cl2_to_cl1"));
        String s = String.format("{ \"hive_table\": { \"qualifiedName\":[ \"replace:@%s:@%s\"], \"*\":[ \"removeClassification:%s_to_%s\" ] } }", "cl1", "cl2", "cl2", "cl1");
        ImportTransforms t = ImportTransforms.fromJson((String)s);
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        String expected_qualifiedName = entity.getAttribute("qualifiedName").toString().replace("@cl1", "@cl2");
        entity.setClassifications(classifications);
        Assert.assertEquals((int)entity.getClassifications().size(), (int)1);
        t.apply(entity);
        Assert.assertEquals((int)entity.getClassifications().size(), (int)0);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)entity.getAttribute("qualifiedName"), (Object)expected_qualifiedName);
    }

    @Test
    public void add_setsValueOfAttribute() throws AtlasBaseException {
        String expected_syncInfo = "cl1:import";
        String s = String.format("{ \"hive_table\": { \"qualifiedName\":[ \"replace:@%s:@%s\"], \"*\":[ \"add:%s=list:%s\" ] } }", "cl1", "cl2", this.HIVE_TABLE_ATTR_SYNC_INFO, "cl1:import");
        ImportTransforms t = ImportTransforms.fromJson((String)s);
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        String expected_qualifiedName = entity.getAttribute("qualifiedName").toString().replace("@cl1", "@cl2");
        t.apply(entity);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)entity.getAttribute("qualifiedName"), (Object)expected_qualifiedName);
        Assert.assertEquals((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_SYNC_INFO), (Object)new ArrayList<String>(){
            {
                this.add("cl1:import");
            }
        });
    }

    @Test
    public void clearAttrValue_removesValueOfAttribute() throws AtlasBaseException {
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        Assert.assertNotNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_FROM));
        Assert.assertNotNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_TO));
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"clearAttrValue:replicatedToCluster\", \"clearAttrValue:replicatedFromCluster\" ] } }");
        Assert.assertTrue((t.getTransforms().size() > 0 ? 1 : 0) != 0);
        t.apply(entity);
        Assert.assertNotNull((Object)t);
        Assert.assertNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_FROM));
        Assert.assertNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_TO));
    }

    @Test
    public void clearAttrValueForMultipleAttributes_removesValueOfAttribute() throws AtlasBaseException {
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"clearAttrValue:replicatedToCluster,replicatedFromCluster\" ] } }");
        Assert.assertTrue((t.getTransforms().size() > 0 ? 1 : 0) != 0);
        t.apply(entity);
        Assert.assertNotNull((Object)t);
        Assert.assertNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_FROM));
        Assert.assertNull((Object)entity.getAttribute(this.HIVE_TABLE_ATTR_REPLICATED_TO));
    }

    @Test
    public void setDeleted_SetsStatusToDeleted() throws AtlasBaseException {
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"setDeleted\" ] } }");
        Assert.assertTrue((t.getTransforms().size() > 0 ? 1 : 0) != 0);
        t.apply(entity);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.DELETED);
    }

    @Test
    public void addClassification_AddsClassificationToEntitiy() throws AtlasBaseException {
        AtlasEntity entity = this.getHiveTableAtlasEntity();
        int existingClassificationsCount = entity.getClassifications() != null ? entity.getClassifications().size() : 0;
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"addClassification:REPLICATED\" ] } }");
        Assert.assertTrue((t.getTransforms().size() > 0 ? 1 : 0) != 0);
        t.apply(entity);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((int)entity.getClassifications().size(), (int)(existingClassificationsCount + 1));
        this.addClassification_ExistingClassificationsAreHandled(entity);
        this.addClassification_MultipleClassificationsAreAdded(entity);
    }

    @Test
    public void addScopedClassification() throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getAtlasEntityWithExtInfo();
        AtlasEntity entity = (AtlasEntity)entityWithExtInfo.getReferredEntities().get("2");
        int existingClassificationsCount = entityWithExtInfo.getEntity().getClassifications() != null ? entity.getClassifications().size() : 0;
        ImportTransforms t = ImportTransforms.fromJson((String)"{ \"hive_column\": { \"*\":[ \"addClassification:REPLICATED_2:topLevel\" ] } }");
        Assert.assertTrue((t.getTransforms().size() > 0 ? 1 : 0) != 0);
        ImportTransformer.AddClassification classification = (ImportTransformer.AddClassification)((List)((Map)t.getTransforms().get("hive_column")).get("*")).get(0);
        AtlasObjectId objectId = new AtlasObjectId("hive_column", "qualifiedName", (Object)String.format("col%s.TABLE1.default@cl1", 2));
        classification.addFilter(objectId);
        t.apply(entityWithExtInfo);
        Assert.assertNotNull((Object)t);
        Assert.assertNull((Object)entityWithExtInfo.getEntity().getClassifications());
        Assert.assertNull((Object)((AtlasEntity)entityWithExtInfo.getReferredEntities().get("0")).getClassifications());
        Assert.assertEquals((int)((AtlasEntity)entityWithExtInfo.getReferredEntities().get("1")).getClassifications().size(), (int)(existingClassificationsCount + 1));
        Assert.assertNull((Object)((AtlasEntity)entityWithExtInfo.getReferredEntities().get("2")).getClassifications());
    }

    private void addClassification_ExistingClassificationsAreHandled(AtlasEntity entity) throws AtlasBaseException {
        int existingClassificationsCount = entity.getClassifications() != null ? entity.getClassifications().size() : 0;
        Assert.assertTrue((existingClassificationsCount > 0 ? 1 : 0) != 0);
        ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"addClassification:REPLICATED\" ] } }").apply(entity);
        Assert.assertEquals((int)entity.getClassifications().size(), (int)existingClassificationsCount);
    }

    private void addClassification_MultipleClassificationsAreAdded(AtlasEntity entity) throws AtlasBaseException {
        int existingClassificationsCount = entity.getClassifications().size();
        ImportTransforms.fromJson((String)"{ \"hive_table\": { \"*\":[ \"addClassification:REPLICATED_2\" ] } }").apply(entity);
        Assert.assertEquals((int)entity.getClassifications().size(), (int)(existingClassificationsCount + 1));
    }

    private String[] getExtEntityExpectedValues(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        String[] ret = new String[entityWithExtInfo.getReferredEntities().size()];
        for (int i = 0; i < ret.length; ++i) {
            String attrValue = (String)((AtlasEntity)entityWithExtInfo.getReferredEntities().get(Integer.toString(i))).getAttribute("qualifiedName");
            ret[i] = attrValue.replace("@cl1", "@cl2");
        }
        return ret;
    }

    private void addColumnTransform(ImportTransforms transform) throws AtlasBaseException {
        HashMap tr = new HashMap();
        ArrayList<ImportTransformer> trList = new ArrayList<ImportTransformer>();
        trList.add(ImportTransformer.getTransformer((String)String.format("replace:%s:%s", "@cl1", "@cl2")));
        tr.put("qualifiedName", trList);
        transform.getTransforms().put("hive_column", tr);
    }

    private String applyDefaultTransform(String attrValue) {
        return attrValue.toLowerCase().replace("@cl1", "@cl2");
    }

    private AtlasEntity getHiveTableAtlasEntity() {
        AtlasEntity entity = new AtlasEntity("hive_table");
        entity.setStatus(AtlasEntity.Status.ACTIVE);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("qualifiedName", "TABLE1.default@cl1");
        attributes.put("dbname", "someDB");
        attributes.put("name", "somename");
        attributes.put(this.HIVE_TABLE_ATTR_SYNC_INFO, null);
        attributes.put(this.HIVE_TABLE_ATTR_REPLICATED_FROM, "cl1");
        attributes.put(this.HIVE_TABLE_ATTR_REPLICATED_TO, "clx");
        entity.setAttributes(attributes);
        return entity;
    }

    private AtlasEntity getHiveColumnAtlasEntity(int index) {
        AtlasEntity entity = new AtlasEntity("hive_column");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("qualifiedName", String.format("col%s.TABLE1.default@cl1", index));
        attributes.put("name", "col" + index);
        entity.setAttributes(attributes);
        return entity;
    }

    private AtlasEntity.AtlasEntityWithExtInfo getAtlasEntityWithExtInfo() {
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(this.getHiveTableAtlasEntity());
        HashMap<String, AtlasEntity> referredEntities = new HashMap<String, AtlasEntity>();
        referredEntities.put("0", this.getHiveColumnAtlasEntity(1));
        referredEntities.put("1", this.getHiveColumnAtlasEntity(2));
        referredEntities.put("2", this.getHiveColumnAtlasEntity(3));
        ret.setReferredEntities(referredEntities);
        return ret;
    }
}

