/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ImportReactivateTableTest
extends AtlasTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImportReactivateTableTest.class);
    private static final String ENTITY_TYPE_COL = "hive_column";
    private static final String ENTITY_GUID_TABLE_WITH_REL_ATTRS = "e19e5683-d9ae-436a-af1e-0873582d0f1e";
    private static final String ENTITY_GUID_TABLE_WITHOUT_REL_ATTRS = "027a987e-867a-4c98-ac1e-c5ded41130d3";
    private static final String REPL_FROM = "cl1";
    private static final String REPL_TRANSFORMER = "[{\"conditions\":{\"__entity\":\"topLevel: \"},\"action\":{\"__entity\":\"ADD_CLASSIFICATION: cl1_replicated\"}},{\"action\":{\"__entity.replicatedTo\":\"CLEAR:\",\"__entity.replicatedFrom\":\"CLEAR:\"}},{\"conditions\":{\"hive_db.clusterName\":\"EQUALS: cl1\"},\"action\":{\"hive_db.clusterName\":\"SET: cl2\"}},{\"conditions\":{\"hive_db.location\":\"STARTS_WITH_IGNORE_CASE: file:///\"},\"action\":{\"hive_db.location\":\"REPLACE_PREFIX: = :file:///=file:///\"}},{\"conditions\":{\"hive_storagedesc.location\":\"STARTS_WITH_IGNORE_CASE: file:///\"},\"action\":{\"hive_storagedesc.location\":\"REPLACE_PREFIX: = :file:///=file:///\"}}]";
    @Inject
    private ImportService importService;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasEntityStore entityStore;
    @Inject
    private AtlasTypeDefStore typeDefStore;

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @BeforeTest
    public void setup() throws IOException, AtlasBaseException {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        this.basicSetup(this.typeDefStore, this.typeRegistry);
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    private void importSeedData() throws AtlasBaseException, IOException {
        TestLoadModelUtils.loadFsModel(this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadHiveModel(this.typeDefStore, this.typeRegistry);
        AtlasImportRequest atlasImportRequest = ZipFileResourceTestUtils.getDefaultImportRequest();
        atlasImportRequest.setOption("replicatedFrom", REPL_FROM);
        atlasImportRequest.setOption("transformers", REPL_TRANSFORMER);
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, atlasImportRequest, ImportReactivateTableTest.getDataWithoutRelationshipAttrs());
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, atlasImportRequest, ImportReactivateTableTest.getDataWithRelationshipAttrs());
    }

    public static InputStream getDataWithRelationshipAttrs() {
        return ZipFileResourceTestUtils.getInputStreamFrom("repl_exp_1.zip");
    }

    public static InputStream getDataWithoutRelationshipAttrs() {
        return ZipFileResourceTestUtils.getInputStreamFrom("stocks.zip");
    }

    @Test
    public void testWithRelationshipAttr() throws AtlasBaseException, IOException {
        this.testReactivation(ENTITY_GUID_TABLE_WITH_REL_ATTRS, 2);
    }

    @Test
    public void testWithoutRelationshipAttr() throws AtlasBaseException, IOException {
        this.testReactivation(ENTITY_GUID_TABLE_WITHOUT_REL_ATTRS, 7);
    }

    public void testReactivation(String tableEntityGuid, int columnCount) throws AtlasBaseException, IOException {
        this.importSeedData();
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getById(tableEntityGuid);
        EntityMutationResponse response = this.createColumn(entity.getEntity());
        String columnGuid = ((AtlasEntityHeader)response.getCreatedEntities().get(0)).getGuid();
        Assert.assertNotNull((Object)columnGuid);
        ++columnCount;
        this.entityStore.deleteById(tableEntityGuid);
        entity = this.entityStore.getById(tableEntityGuid);
        Assert.assertEquals((Object)entity.getEntity().getStatus(), (Object)AtlasEntity.Status.DELETED);
        this.importSeedData();
        AtlasEntity atlasEntity = this.entityStore.getById(tableEntityGuid).getEntity();
        Assert.assertEquals((Object)atlasEntity.getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        List columns = (List)atlasEntity.getRelationshipAttribute("columns");
        Assert.assertEquals((int)columns.size(), (int)columnCount);
        int activeColumnCount = 0;
        int deletedColumnCount = 0;
        for (AtlasRelatedObjectId column : columns) {
            if (column.getGuid().equals(columnGuid)) {
                Assert.assertEquals((Object)column.getEntityStatus(), (Object)AtlasEntity.Status.DELETED);
                Assert.assertEquals((Object)column.getRelationshipStatus(), (Object)AtlasRelationship.Status.DELETED);
                ++deletedColumnCount;
                continue;
            }
            Assert.assertEquals((Object)column.getEntityStatus(), (Object)AtlasEntity.Status.ACTIVE);
            Assert.assertEquals((Object)column.getRelationshipStatus(), (Object)AtlasRelationship.Status.ACTIVE);
            ++activeColumnCount;
        }
        Assert.assertEquals((int)activeColumnCount, (int)(--columnCount));
        Assert.assertEquals((int)deletedColumnCount, (int)1);
    }

    private EntityMutationResponse createColumn(AtlasEntity tblEntity) throws AtlasBaseException {
        AtlasEntity ret = new AtlasEntity(ENTITY_TYPE_COL);
        String name = "new_column";
        ret.setAttribute("name", (Object)name);
        ret.setAttribute("qualifiedName", (Object)(name + REPL_FROM));
        ret.setAttribute("type", (Object)"int");
        ret.setAttribute("comment", (Object)name);
        ret.setRelationshipAttribute("table", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)tblEntity));
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(ret), false);
        return response;
    }
}

