/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.impexp.HdfsPathEntityCreator;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class HdfsPathEntityCreatorTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private HdfsPathEntityCreator hdfsPathEntityCreator;
    private static final String expectedPath = "hdfs://server-name/warehouse/hr";
    private static final String expectedClusterName = "cl1";

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.basicSetup(this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadFsModel(this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void verifyCreate() throws AtlasBaseException {
        String expectedQualifiedName = HdfsPathEntityCreator.getQualifiedName((String)"hdfs://server-name/warehouse/hr/", (String)expectedClusterName);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.hdfsPathEntityCreator.getCreateEntity(expectedPath, expectedClusterName);
        Assert.assertNotNull((Object)entityWithExtInfo);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertEquals((Object)entity.getAttribute("path"), (Object)"hdfs://server-name/warehouse/hr/");
        Assert.assertEquals((Object)entity.getAttribute("qualifiedName"), (Object)expectedQualifiedName);
        Assert.assertEquals((Object)entity.getAttribute("name"), (Object)"hdfs://server-name/warehouse/hr/");
        Assert.assertEquals((Object)entity.getAttribute("clusterName"), (Object)expectedClusterName);
    }

    @Test(dependsOnMethods={"verifyCreate"})
    public void verifyGet() throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.hdfsPathEntityCreator.getCreateEntity(expectedPath, expectedClusterName);
        Assert.assertNotNull((Object)entityWithExtInfo);
    }
}

