/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ExportServiceTest
extends AtlasTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ExportServiceTest.class);
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    ExportService exportService;
    @Inject
    private ExportImportAuditService auditService;
    @Inject
    private AtlasEntityStoreV2 entityStore;

    @BeforeTest
    public void setupTest() throws IOException, AtlasBaseException {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        this.basicSetup(this.typeDefStore, this.typeRegistry);
    }

    @BeforeClass
    public void setupSampleData() throws Exception {
        super.initialize();
        AtlasTypesDef sampleTypes = TestUtilsV2.defineDeptEmployeeTypes();
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)sampleTypes, (AtlasTypeRegistry)this.typeRegistry);
        if (!typesToCreate.isEmpty()) {
            this.typeDefStore.createTypesDef(typesToCreate);
        }
        AtlasEntity.AtlasEntitiesWithExtInfo deptEg2 = TestUtilsV2.createDeptEg2();
        AtlasEntityStream entityStream = new AtlasEntityStream(deptEg2);
        EntityMutationResponse emr = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        Assert.assertNotNull((Object)emr);
        Assert.assertNotNull((Object)emr.getCreatedEntities());
        Assert.assertTrue((emr.getCreatedEntities().size() > 0 ? 1 : 0) != 0);
    }

    @AfterClass
    public void clear() throws Exception {
        Thread.sleep(1000L);
        this.assertExportImportAuditEntry(this.auditService);
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    private AtlasExportRequest getRequestForFullFetch() {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("hive_db", "qualifiedName", (Object)"default@cl1"));
        request.setItemsToExport(itemsToExport);
        return request;
    }

    private AtlasExportRequest getRequestForDept(boolean addFetchType, String fetchTypeValue, boolean addMatchType, String matchTypeValue) {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("Department", "name", (Object)"hr"));
        request.setItemsToExport(itemsToExport);
        this.setOptionsMap(request, addFetchType, fetchTypeValue, addMatchType, matchTypeValue);
        return request;
    }

    private AtlasExportRequest getRequestForEmployee() {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("Employee", "name", (Object)"Max"));
        request.setItemsToExport(itemsToExport);
        this.setOptionsMap(request, true, "CONNECTED", false, "");
        return request;
    }

    private void setOptionsMap(AtlasExportRequest request, boolean addFetchType, String fetchTypeValue, boolean addMatchType, String matchTypeValue) {
        HashMap<String, String> optionsMap = null;
        if (addFetchType) {
            if (optionsMap == null) {
                optionsMap = new HashMap<String, String>();
            }
            optionsMap.put("fetchType", fetchTypeValue);
            request.setOptions(optionsMap);
        }
        if (addMatchType) {
            if (optionsMap == null) {
                optionsMap = new HashMap();
            }
            optionsMap.put("matchType", matchTypeValue);
        }
        if (optionsMap != null) {
            request.setOptions(optionsMap);
        }
    }

    private ZipSource runExportWithParameters(AtlasExportRequest request) throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipSink zipSink = new ZipSink((OutputStream)baos);
        AtlasExportResult result = this.exportService.run(zipSink, request, "admin", "localhost", "1.0.0.0");
        zipSink.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        ZipSource zipSource = new ZipSource((InputStream)bis);
        return zipSource;
    }

    @Test
    public void exportType() throws AtlasBaseException {
        String requestingIP = "1.0.0.0";
        String hostName = "root";
        AtlasExportRequest request = this.getRequestForFullFetch();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipSink zipSink = new ZipSink((OutputStream)baos);
        AtlasExportResult result = this.exportService.run(zipSink, request, "admin", hostName, requestingIP);
        Assert.assertNotNull((Object)this.exportService);
        Assert.assertEquals((String)result.getHostName(), (String)hostName);
        Assert.assertEquals((String)result.getClientIpAddress(), (String)requestingIP);
        Assert.assertEquals((Object)request, (Object)result.getRequest());
        Assert.assertNotNull((Object)result.getSourceClusterName());
    }

    @Test(expectedExceptions={AtlasBaseException.class})
    public void requestingEntityNotFound_NoData() throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "root";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipSink zipSink = new ZipSink((OutputStream)baos);
        AtlasExportResult result = this.exportService.run(zipSink, this.getRequestForFullFetch(), "admin", hostName, requestingIP);
        Assert.assertNull((Object)result.getData());
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        new ZipSource((InputStream)bais);
    }

    @Test
    public void requestingEntityFoundDefaultFetch_ContainsData() throws Exception {
        ZipSource source = this.runExportWithParameters(this.getRequestForDept(false, "", false, ""));
        this.verifyExportForHrData(source);
    }

    @Test
    public void requestingHrEntityWithMatchTypeContains_ContainsData() throws Exception {
        ZipSource source = this.runExportWithParameters(this.getRequestForDept(false, "", true, "CONTAINS"));
        this.verifyExportForHrData(source);
    }

    @Test
    public void requestingHrEntityWithMatchTypeEndsWith_ContainsData() throws Exception {
        ZipSource source = this.runExportWithParameters(this.getRequestForDept(false, "", true, "ENDSWITH"));
        this.verifyExportForHrData(source);
    }

    @Test
    public void requestingDeptEntityFoundFullFetch_ContainsData() throws Exception {
        ZipSource source = this.runExportWithParameters(this.getRequestForDept(true, "FULL", false, ""));
        this.verifyExportForHrData(source);
    }

    @Test
    public void requestingDeptEntityFoundConnectedFetch_ContainsData() throws Exception {
        ZipSource source = this.runExportWithParameters(this.getRequestForDept(true, "CONNECTED", false, ""));
        this.verifyExportForHrDataForConnected(source);
    }

    @Test
    public void requestingEmployeeEntityFoundConnectedFetch_ContainsData() throws Exception {
        ZipSource zipSource = this.runExportWithParameters(this.getRequestForEmployee());
        this.verifyExportForEmployeeData(zipSource);
    }

    @Test
    public void verifyOverallStatus() {
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.FAIL, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[0]));
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.SUCCESS, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[]{AtlasExportResult.OperationStatus.SUCCESS}));
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.SUCCESS, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[]{AtlasExportResult.OperationStatus.SUCCESS, AtlasExportResult.OperationStatus.SUCCESS, AtlasExportResult.OperationStatus.SUCCESS}));
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.PARTIAL_SUCCESS, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[]{AtlasExportResult.OperationStatus.FAIL, AtlasExportResult.OperationStatus.PARTIAL_SUCCESS, AtlasExportResult.OperationStatus.SUCCESS}));
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.PARTIAL_SUCCESS, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[]{AtlasExportResult.OperationStatus.FAIL, AtlasExportResult.OperationStatus.FAIL, AtlasExportResult.OperationStatus.PARTIAL_SUCCESS}));
        Assert.assertEquals((Object)AtlasExportResult.OperationStatus.FAIL, (Object)this.exportService.getOverallOperationStatus(new AtlasExportResult.OperationStatus[]{AtlasExportResult.OperationStatus.FAIL, AtlasExportResult.OperationStatus.FAIL, AtlasExportResult.OperationStatus.FAIL}));
    }

    @Test(expectedExceptions={AtlasBaseException.class})
    public void requestingExportOfNonExistentEntity_ReturnsFailure() throws Exception {
        AtlasExportRequest request = this.getRequestForEmployee();
        this.tamperEmployeeRequest(request);
        this.runExportWithParameters(request);
    }

    @Test
    public void requestForTypeFull() {
        AtlasExportRequest req = this.getRequestForTypeFull("Department,Employee");
        Assert.assertNotNull((Object)req);
        Assert.assertEquals((int)req.getItemsToExport().size(), (int)1);
        Assert.assertEquals(req.getOptions().get("matchType"), (Object)"forType");
    }

    @Test
    public void verifyTypeFull() throws AtlasBaseException, IOException {
        ZipSource zipSource = this.runExportWithParameters(this.getRequestForTypeFull("Department,Employee,Manager"));
        this.verifyExportForFullEmployeeData(zipSource);
    }

    private AtlasExportRequest getRequestForTypeFull(String type) {
        String jsonRequest = "{ \"itemsToExport\": [ { \"typeName\": \"%s\" } ], \"options\": {  \"fetchType\": \"FULL\", \"matchType\": \"forType\"} }";
        return (AtlasExportRequest)AtlasType.fromJson((String)String.format(jsonRequest, type), AtlasExportRequest.class);
    }

    private void tamperEmployeeRequest(AtlasExportRequest request) {
        AtlasObjectId objectId = (AtlasObjectId)request.getItemsToExport().get(0);
        objectId.getUniqueAttributes().remove("name");
        objectId.getUniqueAttributes().put("qualifiedName", "XXX@121");
    }

    private void verifyExportForEmployeeData(ZipSource zipSource) throws AtlasBaseException {
        List<String> expectedEntityTypes = Arrays.asList("Manager", "Employee", "Department");
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)2);
        Assert.assertTrue((boolean)zipSource.hasNext());
        while (zipSource.hasNext()) {
            AtlasEntity entity = zipSource.next();
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)AtlasEntity.Status.ACTIVE, (Object)entity.getStatus());
            Assert.assertTrue((boolean)expectedEntityTypes.contains(entity.getTypeName()));
        }
        this.verifyTypeDefs(zipSource);
    }

    private void verifyExportForFullEmployeeData(ZipSource zipSource) throws AtlasBaseException {
        List<String> expectedEntityTypes = Arrays.asList("Manager", "Employee", "Department");
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertTrue((boolean)zipSource.hasNext());
        while (zipSource.hasNext()) {
            AtlasEntity entity = zipSource.next();
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)AtlasEntity.Status.ACTIVE, (Object)entity.getStatus());
            Assert.assertTrue((boolean)expectedEntityTypes.contains(entity.getTypeName()));
        }
        this.verifyTypeDefs(zipSource);
    }

    private void verifyExportForHrData(ZipSource zipSource) throws IOException, AtlasBaseException {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertTrue((zipSource.getCreationOrder().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)zipSource.hasNext());
        AtlasEntity entity = zipSource.next();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.getTypeName().equals("Department"));
        Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        this.verifyTypeDefs(zipSource);
    }

    private void verifyExportForHrDataForConnected(ZipSource zipSource) throws IOException, AtlasBaseException {
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)1);
        Assert.assertTrue((boolean)zipSource.hasNext());
        AtlasEntity entity = zipSource.next();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.getTypeName().equals("Department"));
        Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.ACTIVE);
        this.verifyTypeDefs(zipSource);
    }

    private void verifyTypeDefs(ZipSource zipSource) throws AtlasBaseException {
        Assert.assertEquals((int)zipSource.getTypesDef().getEnumDefs().size(), (int)1);
        Assert.assertEquals((int)zipSource.getTypesDef().getClassificationDefs().size(), (int)0);
        Assert.assertEquals((int)zipSource.getTypesDef().getStructDefs().size(), (int)1);
        Assert.assertEquals((int)zipSource.getTypesDef().getEntityDefs().size(), (int)4);
    }
}

