/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.util.UniqueList;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ExportIncrementalTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    ExportService exportService;
    @Inject
    private ImportService importService;
    @Inject
    private AtlasEntityStoreV2 entityStore;
    private final String EXPORT_REQUEST_INCREMENTAL = "export-incremental";
    private final String EXPORT_REQUEST_CONNECTED = "export-connected";
    private AtlasClassificationType classificationTypeT1;
    private long nextTimestamp;
    private static final String EXPORT_INCREMENTAL = "incremental";
    private static final String QUALIFIED_NAME_DB = "db_test_1@02052019";
    private static final String QUALIFIED_NAME_TABLE_LINEAGE = "db_test_1.test_tbl_ctas_2@02052019";
    private static final String GUID_DB = "f0b72ab4-7452-4e42-ac74-2aee7728cce4";
    private static final String GUID_TABLE_2 = "8d0b834c-61ce-42d8-8f66-6fa51c36bccb";
    private static final String GUID_TABLE_CTAS_2 = "eaec545b-3ac7-4e1b-a497-bd4a2b6434a2";

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.basicSetup(this.typeDefStore, this.typeRegistry);
        RequestContext.get().setImportInProgress(true);
        this.classificationTypeT1 = this.createNewClassification();
        this.createEntities(this.entityStore, "stocksDB-Entities", new String[]{"db", "table-columns"});
        String[] entityGuids = new String[]{"1637a33e-6512-447b-ade7-249c8cb5344b", "df122fc3-5555-40f8-a30f-3090b8a622f8"};
        this.verifyCreatedEntities(this.entityStore, entityGuids, 2);
    }

    @BeforeMethod
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @Test
    public void atT0_ReturnsAllEntities() throws AtlasBaseException, IOException {
        int expectedEntityCount = 2;
        AtlasExportRequest request = this.getIncrementalRequest(0L);
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, request);
        ZipSource source = this.getZipSourceFromInputStream(inputStream);
        AtlasEntity.AtlasEntityWithExtInfo entities = ZipFileResourceTestUtils.getEntities(source, 2);
        int count = 0;
        for (Map.Entry entry : entities.getReferredEntities().entrySet()) {
            Assert.assertNotNull(entry.getValue());
            ++count;
        }
        this.nextTimestamp = this.updateTimesampForNextIncrementalExport(source);
        Assert.assertEquals((int)count, (int)2);
    }

    private long updateTimesampForNextIncrementalExport(ZipSource source) throws AtlasBaseException {
        return source.getExportResult().getChangeMarker();
    }

    @Test(dependsOnMethods={"atT0_ReturnsAllEntities"})
    public void atT1_NewClassificationAttachedToTable_ReturnsChangedTable() throws AtlasBaseException, IOException {
        boolean expectedEntityCount = true;
        this.entityStore.addClassifications("df122fc3-5555-40f8-a30f-3090b8a622f8", (List)ImmutableList.of((Object)this.classificationTypeT1.createDefaultValue()));
        AtlasExportRequest request = this.getIncrementalRequest(this.nextTimestamp);
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, request);
        ZipSource source = this.getZipSourceFromInputStream(inputStream);
        AtlasEntity.AtlasEntityWithExtInfo entities = ZipFileResourceTestUtils.getEntities(source, 1);
        AtlasEntity entity = null;
        Iterator iterator = entities.getReferredEntities().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entity = (AtlasEntity)entry.getValue();
            Assert.assertNotNull((Object)entity);
        }
        this.nextTimestamp = this.updateTimesampForNextIncrementalExport(source);
        Assert.assertEquals((String)entity.getGuid(), (String)"df122fc3-5555-40f8-a30f-3090b8a622f8");
    }

    private AtlasClassificationType createNewClassification() {
        TestLoadModelUtils.createTypes(this.typeDefStore, "stocksDB-Entities", "typesdef-new-classification");
        return this.typeRegistry.getClassificationTypeByName("T1");
    }

    @Test(dependsOnMethods={"atT1_NewClassificationAttachedToTable_ReturnsChangedTable"})
    public void atT2_NewClassificationAttachedToColumn_ReturnsChangedColumn() throws AtlasBaseException, IOException {
        boolean expectedEntityCount = true;
        AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.entityStore.getById("df122fc3-5555-40f8-a30f-3090b8a622f8");
        long preExportTableEntityTimestamp = tableEntity.getEntity().getUpdateTime().getTime();
        this.entityStore.addClassifications("f87a5320-1529-4369-8d63-b637ebdf2c1c", (List)ImmutableList.of((Object)this.typeRegistry.getClassificationTypeByName("T1").createDefaultValue()));
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getIncrementalRequest(this.nextTimestamp));
        ZipSource source = this.getZipSourceFromInputStream(inputStream);
        AtlasEntity.AtlasEntityWithExtInfo entities = ZipFileResourceTestUtils.getEntities(source, 1);
        Iterator iterator = entities.getReferredEntities().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AtlasEntity entity = (AtlasEntity)entry.getValue();
            Assert.assertNotNull((Object)entity.getGuid());
        }
        long postUpdateTableEntityTimestamp = tableEntity.getEntity().getUpdateTime().getTime();
        Assert.assertEquals((long)preExportTableEntityTimestamp, (long)postUpdateTableEntityTimestamp);
    }

    private ZipSource getZipSourceFromInputStream(InputStream inputStream) {
        try {
            return new ZipSource(inputStream);
        }
        catch (IOException | AtlasBaseException e) {
            return null;
        }
    }

    @Test(dependsOnMethods={"atT2_NewClassificationAttachedToColumn_ReturnsChangedColumn"})
    public void exportingWithSameParameters_Succeeds() {
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getIncrementalRequest(this.nextTimestamp));
        Assert.assertNotNull((Object)this.getZipSourceFromInputStream(inputStream));
    }

    @Test
    public void connectedExport() {
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getConnected());
        ZipSource source = this.getZipSourceFromInputStream(inputStream);
        UniqueList creationOrder = new UniqueList();
        List zipCreationOrder = source.getCreationOrder();
        creationOrder.addAll((Collection)zipCreationOrder);
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((int)creationOrder.size(), (int)zipCreationOrder.size());
    }

    @DataProvider(name="hiveDb")
    public static Object[][] getData(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("hive_db_lineage.zip");
    }

    @Test(dataProvider="hiveDb")
    public void importHiveDb(InputStream stream) throws AtlasBaseException, IOException {
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, stream);
    }

    @Test(dependsOnMethods={"importHiveDb"})
    public void exportTableInrementalConnected() throws AtlasBaseException, IOException {
        InputStream source = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_INCREMENTAL, 0L, true));
        ZipSource sourceCopy = this.getZipSourceCopy(source);
        this.verifyExpectedEntities(this.getFileNames(sourceCopy), GUID_DB, GUID_TABLE_CTAS_2);
        this.nextTimestamp = this.updateTimesampForNextIncrementalExport(sourceCopy);
        source = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_INCREMENTAL, this.nextTimestamp, true));
        this.entityStore.addClassifications(GUID_TABLE_CTAS_2, (List)ImmutableList.of((Object)this.classificationTypeT1.createDefaultValue()));
        source = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, this.getExportRequestForHiveTable(QUALIFIED_NAME_TABLE_LINEAGE, EXPORT_INCREMENTAL, this.nextTimestamp, true));
        this.verifyExpectedEntities(this.getFileNames(this.getZipSourceCopy(source)), GUID_TABLE_CTAS_2);
    }

    private AtlasExportRequest getIncrementalRequest(long timestamp) {
        try {
            AtlasExportRequest request = TestResourceFileUtils.readObjectFromJson("stocksDB-Entities", "export-incremental", AtlasExportRequest.class);
            request.getOptions().put("changeMarker", timestamp);
            return request;
        }
        catch (IOException e) {
            throw new SkipException(String.format("getIncrementalRequest: '%s' could not be loaded.", "export-incremental"));
        }
    }

    private AtlasExportRequest getConnected() {
        try {
            return TestResourceFileUtils.readObjectFromJson("stocksDB-Entities", "export-connected", AtlasExportRequest.class);
        }
        catch (IOException e) {
            throw new SkipException(String.format("getIncrementalRequest: '%s' could not be loaded.", "export-connected"));
        }
    }

    private AtlasExportRequest getExportRequestForHiveTable(String name, String fetchType, long changeMarker, boolean skipLineage) {
        AtlasExportRequest request = new AtlasExportRequest();
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        itemsToExport.add(new AtlasObjectId("hive_table", "qualifiedName", (Object)name));
        request.setItemsToExport(itemsToExport);
        request.setOptions(this.getOptionsMap(fetchType, changeMarker, skipLineage));
        return request;
    }

    private Map<String, Object> getOptionsMap(String fetchType, long changeMarker, boolean skipLineage) {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        optionsMap.put("fetchType", fetchType.isEmpty() ? "full" : fetchType);
        optionsMap.put("changeMarker", changeMarker);
        optionsMap.put("skipLineage", skipLineage);
        return optionsMap;
    }

    private void verifyExpectedEntities(List<String> fileNames, String ... guids) {
        Assert.assertEquals((int)fileNames.size(), (int)guids.length);
        for (String guid : guids) {
            Assert.assertTrue((boolean)fileNames.contains(guid.toLowerCase()));
        }
    }

    private List<String> getFileNames(ZipSource zipSource) {
        ArrayList<String> ret = new ArrayList<String>();
        Assert.assertTrue((boolean)zipSource.hasNext());
        while (zipSource.hasNext()) {
            AtlasEntity atlasEntity = zipSource.next();
            Assert.assertNotNull((Object)atlasEntity);
            ret.add(atlasEntity.getGuid());
        }
        return ret;
    }

    private ZipSource getZipSourceCopy(InputStream is) throws IOException, AtlasBaseException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        return new ZipSource((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }
}

