/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.atlas.TestModules;
import org.apache.atlas.model.migration.MigrationImportStatus;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.migration.DataMigrationStatusService;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class DataMigrationStatusServiceTest {
    @Inject
    AtlasGraph atlasGraph;

    @Test
    public void createUpdateDelete() {
        String STATUS_DONE = "DONE";
        DataMigrationStatusService dataMigrationStatusService = new DataMigrationStatusService(this.atlasGraph);
        MigrationImportStatus expected = new MigrationImportStatus("/tmp/defg.zip");
        expected.setTotalCount(3333L);
        expected.setCurrentIndex(20L);
        expected.setStartTime(new Date());
        MigrationImportStatus ret = dataMigrationStatusService.getCreate(expected);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((String)ret.getName(), (String)expected.getName());
        Assert.assertEquals((Object)ret.getStartTime(), (Object)expected.getStartTime());
        Assert.assertEquals((long)ret.getTotalCount(), (long)expected.getTotalCount());
        Assert.assertEquals((long)ret.getCurrentIndex(), (long)expected.getCurrentIndex());
        dataMigrationStatusService.savePosition(Long.valueOf(100L));
        Assert.assertNotNull((Object)dataMigrationStatusService.getStatus());
        Assert.assertNotNull((Object)dataMigrationStatusService.getStatus().getCurrentIndex(), (String)"100");
        Assert.assertNotNull((Object)dataMigrationStatusService.getCreate(expected).getCurrentIndex(), (String)"100");
        dataMigrationStatusService.setStatus("DONE");
        Assert.assertNotNull((Object)dataMigrationStatusService.getCreate(expected).getOperationStatus());
        Assert.assertEquals((String)dataMigrationStatusService.getCreate(expected).getOperationStatus(), (String)"DONE");
        dataMigrationStatusService.delete();
        Assert.assertNull((Object)dataMigrationStatusService.getStatus());
    }
}

