/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.List;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AtlasImportRequestTest {
    @Test
    public void serializeAtlasImportRequstFromJsonWithEmptyOptions() {
        String jsonData = "{ \"options\": {} }";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNotNull((Object)request.getOptions());
        Assert.assertNull(request.getOptions().get("transforms"));
        ImportTransforms tr = ImportTransforms.fromJson((String)((String)request.getOptions().get("transforms")));
        Assert.assertNull((Object)tr);
    }

    @Test
    public void serializeOptions_VerifyAccessors() {
        String guid = "\"abcd\"";
        String pos = "\"1\"";
        String trueVal = "\"true\"";
        String jsonData = "{ \"options\":                {\"startGuid\":" + guid + ",\"startPosition\":" + pos + ",\"updateTypeDefinition\":" + trueVal + "}}";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNotNull((Object)request.getStartGuid());
        Assert.assertNotNull((Object)request.getStartPosition());
        Assert.assertNotNull((Object)request.getUpdateTypeDefs());
        Assert.assertEquals((String)request.getStartGuid(), (String)guid.replace("\"", ""));
        Assert.assertEquals((String)request.getStartPosition(), (String)pos.replace("\"", ""));
        Assert.assertEquals((String)request.getUpdateTypeDefs(), (String)trueVal.replace("\"", ""));
    }

    @Test
    public void optionsDefaultsTest() {
        String jsonData = "{ \"options\":                {}}";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNull((Object)request.getStartGuid());
        Assert.assertNull((Object)request.getStartPosition());
        Assert.assertNull((Object)request.getUpdateTypeDefs());
    }

    @Test
    public void serializeAtlasImportRequstFromJsonWithEmptyTransforms() {
        String jsonData = "{ \"options\": { \"transforms\": \"{ }\" } }";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNotNull((Object)request.getOptions());
        Assert.assertNotNull(request.getOptions().get("transforms"));
        ImportTransforms tr = ImportTransforms.fromJson((String)((String)request.getOptions().get("transforms")));
        Assert.assertNotNull((Object)tr);
        Assert.assertNotNull((Object)tr.getTransforms());
        Assert.assertEquals((int)tr.getTransforms().size(), (int)0);
    }

    @Test
    public void serializeAtlasImportRequstFromJsonWith1Transform() {
        String jsonData = "{ \"options\": { \"transforms\": \"{ \\\"hive_db\\\": { \\\"qualifiedName\\\": [ \\\"replace:@cl1:@cl2\\\" ] } }\" } }";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNotNull((Object)request.getOptions());
        Assert.assertNotNull(request.getOptions().get("transforms"));
        ImportTransforms tr = ImportTransforms.fromJson((String)((String)request.getOptions().get("transforms")));
        Assert.assertNotNull((Object)tr);
        Assert.assertNotNull((Object)tr.getTransforms());
        Assert.assertEquals((int)tr.getTransforms().size(), (int)1);
        Assert.assertTrue((boolean)tr.getTransforms().containsKey("hive_db"));
        Assert.assertEquals((int)tr.getTransforms("hive_db").entrySet().size(), (int)1);
        Assert.assertTrue((boolean)tr.getTransforms("hive_db").containsKey("qualifiedName"));
        Assert.assertEquals((int)((List)tr.getTransforms("hive_db").get("qualifiedName")).size(), (int)1);
    }

    @Test
    public void serializeAtlasImportRequstFromJson() {
        String jsonData = "{ \"options\": { \"transforms\": \"{ \\\"hive_db\\\": { \\\"qualifiedName\\\": [ \\\"replace:@cl1:@cl2\\\" ] }, \\\"hive_table\\\": { \\\"qualifiedName\\\": [ \\\"lowercase\\\", \\\"replace:@cl1:@cl2\\\" ] } }\" } } }";
        AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
        Assert.assertNotNull((Object)request);
        Assert.assertNotNull((Object)request.getOptions());
        Assert.assertNotNull(request.getOptions().get("transforms"));
        ImportTransforms tr = ImportTransforms.fromJson((String)((String)request.getOptions().get("transforms")));
        Assert.assertNotNull((Object)tr);
        Assert.assertNotNull((Object)tr.getTransforms());
        Assert.assertEquals((int)tr.getTransforms().size(), (int)2);
        Assert.assertTrue((boolean)tr.getTransforms().containsKey("hive_db"));
        Assert.assertEquals((int)tr.getTransforms("hive_db").entrySet().size(), (int)1);
        Assert.assertTrue((boolean)tr.getTransforms("hive_db").containsKey("qualifiedName"));
        Assert.assertEquals((int)((List)tr.getTransforms("hive_db").get("qualifiedName")).size(), (int)1);
        Assert.assertTrue((boolean)tr.getTransforms().containsKey("hive_table"));
        Assert.assertEquals((int)tr.getTransforms("hive_table").entrySet().size(), (int)1);
        Assert.assertTrue((boolean)tr.getTransforms("hive_table").containsKey("qualifiedName"));
        Assert.assertEquals((int)((List)tr.getTransforms("hive_table").get("qualifiedName")).size(), (int)2);
    }
}

