/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.audit.InMemoryEntityAuditRepository;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class AuditRepositoryTestBase {
    protected EntityAuditRepository eventRepository;

    private String rand() {
        return TestUtilsV2.randomString((int)10);
    }

    @BeforeTest
    public void setUp() throws Exception {
        this.eventRepository = new InMemoryEntityAuditRepository();
    }

    @Test
    public void testAddEventsV1() throws Exception {
        EntityAuditEvent event = new EntityAuditEvent(this.rand(), Long.valueOf(System.currentTimeMillis()), "u1", EntityAuditEvent.EntityAuditAction.ENTITY_CREATE, "d1", new Referenceable(this.rand(), new String[0]));
        this.eventRepository.putEventsV1(new EntityAuditEvent[]{event});
        List events = this.eventRepository.listEventsV1(event.getEntityId(), null, (short)10);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventV1Equals((EntityAuditEvent)events.get(0), event);
    }

    @Test
    public void testListPaginationV1() throws Exception {
        String id1 = "id1" + this.rand();
        String id2 = "id2" + this.rand();
        String id3 = "id3" + this.rand();
        long ts = System.currentTimeMillis();
        Referenceable entity = new Referenceable(this.rand(), new String[0]);
        ArrayList<EntityAuditEvent> expectedEvents = new ArrayList<EntityAuditEvent>(3);
        for (int i = 0; i < 3; ++i) {
            EntityAuditEvent event = new EntityAuditEvent(id2, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.ENTITY_UPDATE, "details" + i, entity);
            this.eventRepository.putEventsV1(new EntityAuditEvent[]{event});
            expectedEvents.add(event);
            this.eventRepository.putEventsV1(new EntityAuditEvent[]{new EntityAuditEvent(id1, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.TAG_DELETE, "details" + i, entity)});
            this.eventRepository.putEventsV1(new EntityAuditEvent[]{new EntityAuditEvent(id3, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.TAG_ADD, "details" + i, entity)});
        }
        List events = this.eventRepository.listEventsV1(id2, null, (short)3);
        Assert.assertEquals((int)events.size(), (int)3);
        this.assertEventV1Equals((EntityAuditEvent)events.get(0), (EntityAuditEvent)expectedEvents.get(0));
        this.assertEventV1Equals((EntityAuditEvent)events.get(1), (EntityAuditEvent)expectedEvents.get(1));
        this.assertEventV1Equals((EntityAuditEvent)events.get(2), (EntityAuditEvent)expectedEvents.get(2));
        events = this.eventRepository.listEventsV1(id2, ((EntityAuditEvent)events.get(2)).getEventKey(), (short)3);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventV1Equals((EntityAuditEvent)events.get(0), (EntityAuditEvent)expectedEvents.get(2));
    }

    @Test
    public void testInvalidEntityIdV1() throws Exception {
        List events = this.eventRepository.listEventsV1(this.rand(), null, (short)3);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    protected void assertEventV1Equals(EntityAuditEvent actual, EntityAuditEvent expected) {
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
        }
        Assert.assertEquals((String)actual.getEntityId(), (String)expected.getEntityId());
        Assert.assertEquals((Object)actual.getAction(), (Object)expected.getAction());
        Assert.assertEquals((long)actual.getTimestamp(), (long)expected.getTimestamp());
        Assert.assertEquals((String)actual.getDetails(), (String)expected.getDetails());
    }

    @Test
    public void testAddEventsV2() throws Exception {
        EntityAuditEventV2 event = new EntityAuditEventV2(this.rand(), System.currentTimeMillis(), "u1", EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE, "d1", new AtlasEntity(this.rand()));
        this.eventRepository.putEventsV2(new EntityAuditEventV2[]{event});
        List events = this.eventRepository.listEventsV2(event.getEntityId(), null, null, (short)10);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), event);
    }

    @Test
    public void testListPaginationV2() throws Exception {
        String id1 = "id1" + this.rand();
        String id2 = "id2" + this.rand();
        String id3 = "id3" + this.rand();
        long ts = System.currentTimeMillis();
        AtlasEntity entity = new AtlasEntity(this.rand());
        ArrayList<EntityAuditEventV2> expectedEvents = new ArrayList<EntityAuditEventV2>(3);
        for (int i = 0; i < 3; ++i) {
            EntityAuditEventV2 event = new EntityAuditEventV2(id2, ts - (long)i, "user" + i, EntityAuditEventV2.EntityAuditActionV2.ENTITY_UPDATE, "details" + i, entity);
            this.eventRepository.putEventsV2(new EntityAuditEventV2[]{event});
            expectedEvents.add(event);
            this.eventRepository.putEventsV2(new EntityAuditEventV2[]{new EntityAuditEventV2(id1, ts - (long)i, "user" + i, EntityAuditEventV2.EntityAuditActionV2.ENTITY_DELETE, "details" + i, entity)});
            this.eventRepository.putEventsV2(new EntityAuditEventV2[]{new EntityAuditEventV2(id3, ts - (long)i, "user" + i, EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE, "details" + i, entity)});
        }
        List events = this.eventRepository.listEventsV2(id2, null, null, (short)3);
        Assert.assertEquals((int)events.size(), (int)3);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), (EntityAuditEventV2)expectedEvents.get(0));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(1), (EntityAuditEventV2)expectedEvents.get(1));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(2), (EntityAuditEventV2)expectedEvents.get(2));
        events = this.eventRepository.listEventsV2(id2, null, ((EntityAuditEventV2)events.get(2)).getEventKey(), (short)3);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), (EntityAuditEventV2)expectedEvents.get(2));
    }

    @Test
    public void testInvalidEntityIdV2() throws Exception {
        List events = this.eventRepository.listEventsV1(this.rand(), null, (short)3);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Test
    public void testSortListV2() throws Exception {
        String id1 = "id1" + this.rand();
        long ts = System.currentTimeMillis();
        AtlasEntity entity = new AtlasEntity(this.rand());
        ArrayList<EntityAuditEventV2> expectedEvents = new ArrayList<EntityAuditEventV2>(3);
        expectedEvents.add(new EntityAuditEventV2(id1, ts, "user-a", EntityAuditEventV2.EntityAuditActionV2.ENTITY_UPDATE, "details-1", entity));
        expectedEvents.add(new EntityAuditEventV2(id1, ts + 1L, "user-C", EntityAuditEventV2.EntityAuditActionV2.ENTITY_DELETE, "details-2", entity));
        expectedEvents.add(new EntityAuditEventV2(id1, ts + 2L, "User-b", EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE, "details-3", entity));
        for (EntityAuditEventV2 event : expectedEvents) {
            this.eventRepository.putEventsV2(new EntityAuditEventV2[]{event});
        }
        List events = this.eventRepository.listEventsV2(id1, null, "timestamp", false, 0, (short)2);
        Assert.assertEquals((int)events.size(), (int)2);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), (EntityAuditEventV2)expectedEvents.get(0));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(1), (EntityAuditEventV2)expectedEvents.get(1));
        events = this.eventRepository.listEventsV2(id1, null, "user", false, 0, (short)3);
        Assert.assertEquals((int)events.size(), (int)3);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), (EntityAuditEventV2)expectedEvents.get(0));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(1), (EntityAuditEventV2)expectedEvents.get(2));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(2), (EntityAuditEventV2)expectedEvents.get(1));
        events = this.eventRepository.listEventsV2(id1, null, "action", false, 0, (short)3);
        Assert.assertEquals((int)events.size(), (int)3);
        this.assertEventV2Equals((EntityAuditEventV2)events.get(0), (EntityAuditEventV2)expectedEvents.get(2));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(1), (EntityAuditEventV2)expectedEvents.get(1));
        this.assertEventV2Equals((EntityAuditEventV2)events.get(2), (EntityAuditEventV2)expectedEvents.get(0));
    }

    protected void assertEventV2Equals(EntityAuditEventV2 actual, EntityAuditEventV2 expected) {
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
        }
        Assert.assertEquals((String)actual.getEntityId(), (String)expected.getEntityId());
        Assert.assertEquals((Object)actual.getAction(), (Object)expected.getAction());
        Assert.assertEquals((long)actual.getTimestamp(), (long)expected.getTimestamp());
        Assert.assertEquals((String)actual.getDetails(), (String)expected.getDetails());
    }
}

